/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * A summary of a result for a container scan <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = ContainerScanResultSummary.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class ContainerScanResultSummary
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "repository",
        "image",
        "compartmentId",
        "containerScanTargetId",
        "highestProblemSeverity",
        "problemCount",
        "timeStarted",
        "timeFinished"
    })
    public ContainerScanResultSummary(
            String id,
            String repository,
            String image,
            String compartmentId,
            String containerScanTargetId,
            ScanResultProblemSeverity highestProblemSeverity,
            Integer problemCount,
            java.util.Date timeStarted,
            java.util.Date timeFinished) {
        super();
        this.id = id;
        this.repository = repository;
        this.image = image;
        this.compartmentId = compartmentId;
        this.containerScanTargetId = containerScanTargetId;
        this.highestProblemSeverity = highestProblemSeverity;
        this.problemCount = problemCount;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of container scan result. Immutable and generated on creation.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of container scan result. Immutable and generated on creation.
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /** Repository in which the container image scanned is located */
        @com.fasterxml.jackson.annotation.JsonProperty("repository")
        private String repository;

        /**
         * Repository in which the container image scanned is located
         *
         * @param repository the value to set
         * @return this builder
         */
        public Builder repository(String repository) {
            this.repository = repository;
            this.__explicitlySet__.add("repository");
            return this;
        }
        /** Image name */
        @com.fasterxml.jackson.annotation.JsonProperty("image")
        private String image;

        /**
         * Image name
         *
         * @param image the value to set
         * @return this builder
         */
        public Builder image(String image) {
            this.image = image;
            this.__explicitlySet__.add("image");
            return this;
        }
        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of the container scan result's compartment. This is set to the same as the compartmentId
         * of the container scan target
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of the container scan result's compartment. This is set to the same as the compartmentId
         * of the container scan target
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of container scan target. Immutable and generated on creation.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("containerScanTargetId")
        private String containerScanTargetId;

        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of container scan target. Immutable and generated on creation.
         *
         * @param containerScanTargetId the value to set
         * @return this builder
         */
        public Builder containerScanTargetId(String containerScanTargetId) {
            this.containerScanTargetId = containerScanTargetId;
            this.__explicitlySet__.add("containerScanTargetId");
            return this;
        }
        /** Highest problem severity in this report */
        @com.fasterxml.jackson.annotation.JsonProperty("highestProblemSeverity")
        private ScanResultProblemSeverity highestProblemSeverity;

        /**
         * Highest problem severity in this report
         *
         * @param highestProblemSeverity the value to set
         * @return this builder
         */
        public Builder highestProblemSeverity(ScanResultProblemSeverity highestProblemSeverity) {
            this.highestProblemSeverity = highestProblemSeverity;
            this.__explicitlySet__.add("highestProblemSeverity");
            return this;
        }
        /** Total number of problems found in this scan */
        @com.fasterxml.jackson.annotation.JsonProperty("problemCount")
        private Integer problemCount;

        /**
         * Total number of problems found in this scan
         *
         * @param problemCount the value to set
         * @return this builder
         */
        public Builder problemCount(Integer problemCount) {
            this.problemCount = problemCount;
            this.__explicitlySet__.add("problemCount");
            return this;
        }
        /**
         * Date and time the scan was started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeStarted")
        private java.util.Date timeStarted;

        /**
         * Date and time the scan was started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeStarted the value to set
         * @return this builder
         */
        public Builder timeStarted(java.util.Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }
        /**
         * Date and time the scan was completed, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeFinished")
        private java.util.Date timeFinished;

        /**
         * Date and time the scan was completed, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeFinished the value to set
         * @return this builder
         */
        public Builder timeFinished(java.util.Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public ContainerScanResultSummary build() {
            ContainerScanResultSummary model =
                    new ContainerScanResultSummary(
                            this.id,
                            this.repository,
                            this.image,
                            this.compartmentId,
                            this.containerScanTargetId,
                            this.highestProblemSeverity,
                            this.problemCount,
                            this.timeStarted,
                            this.timeFinished);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(ContainerScanResultSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("repository")) {
                this.repository(model.getRepository());
            }
            if (model.wasPropertyExplicitlySet("image")) {
                this.image(model.getImage());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("containerScanTargetId")) {
                this.containerScanTargetId(model.getContainerScanTargetId());
            }
            if (model.wasPropertyExplicitlySet("highestProblemSeverity")) {
                this.highestProblemSeverity(model.getHighestProblemSeverity());
            }
            if (model.wasPropertyExplicitlySet("problemCount")) {
                this.problemCount(model.getProblemCount());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * container scan result. Immutable and generated on creation.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * container scan result. Immutable and generated on creation.
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /** Repository in which the container image scanned is located */
    @com.fasterxml.jackson.annotation.JsonProperty("repository")
    private final String repository;

    /**
     * Repository in which the container image scanned is located
     *
     * @return the value
     */
    public String getRepository() {
        return repository;
    }

    /** Image name */
    @com.fasterxml.jackson.annotation.JsonProperty("image")
    private final String image;

    /**
     * Image name
     *
     * @return the value
     */
    public String getImage() {
        return image;
    }

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * the container scan result's compartment. This is set to the same as the compartmentId of the
     * container scan target
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * the container scan result's compartment. This is set to the same as the compartmentId of the
     * container scan target
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * container scan target. Immutable and generated on creation.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("containerScanTargetId")
    private final String containerScanTargetId;

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * container scan target. Immutable and generated on creation.
     *
     * @return the value
     */
    public String getContainerScanTargetId() {
        return containerScanTargetId;
    }

    /** Highest problem severity in this report */
    @com.fasterxml.jackson.annotation.JsonProperty("highestProblemSeverity")
    private final ScanResultProblemSeverity highestProblemSeverity;

    /**
     * Highest problem severity in this report
     *
     * @return the value
     */
    public ScanResultProblemSeverity getHighestProblemSeverity() {
        return highestProblemSeverity;
    }

    /** Total number of problems found in this scan */
    @com.fasterxml.jackson.annotation.JsonProperty("problemCount")
    private final Integer problemCount;

    /**
     * Total number of problems found in this scan
     *
     * @return the value
     */
    public Integer getProblemCount() {
        return problemCount;
    }

    /**
     * Date and time the scan was started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeStarted")
    private final java.util.Date timeStarted;

    /**
     * Date and time the scan was started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeStarted() {
        return timeStarted;
    }

    /**
     * Date and time the scan was completed, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeFinished")
    private final java.util.Date timeFinished;

    /**
     * Date and time the scan was completed, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeFinished() {
        return timeFinished;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("ContainerScanResultSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", repository=").append(String.valueOf(this.repository));
        sb.append(", image=").append(String.valueOf(this.image));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", containerScanTargetId=").append(String.valueOf(this.containerScanTargetId));
        sb.append(", highestProblemSeverity=").append(String.valueOf(this.highestProblemSeverity));
        sb.append(", problemCount=").append(String.valueOf(this.problemCount));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerScanResultSummary)) {
            return false;
        }

        ContainerScanResultSummary other = (ContainerScanResultSummary) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.repository, other.repository)
                && java.util.Objects.equals(this.image, other.image)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.containerScanTargetId, other.containerScanTargetId)
                && java.util.Objects.equals(
                        this.highestProblemSeverity, other.highestProblemSeverity)
                && java.util.Objects.equals(this.problemCount, other.problemCount)
                && java.util.Objects.equals(this.timeStarted, other.timeStarted)
                && java.util.Objects.equals(this.timeFinished, other.timeFinished)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result = (result * PRIME) + (this.repository == null ? 43 : this.repository.hashCode());
        result = (result * PRIME) + (this.image == null ? 43 : this.image.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.containerScanTargetId == null
                                ? 43
                                : this.containerScanTargetId.hashCode());
        result =
                (result * PRIME)
                        + (this.highestProblemSeverity == null
                                ? 43
                                : this.highestProblemSeverity.hashCode());
        result = (result * PRIME) + (this.problemCount == null ? 43 : this.problemCount.hashCode());
        result = (result * PRIME) + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = (result * PRIME) + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
