/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/** Sort by field for Host CIS (Center for Internet Security) Benchmark Scans. */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
public enum HostCisBenchmarkScanResultSortBy implements com.oracle.bmc.http.internal.BmcEnum {
    TimeStarted("timeStarted"),
    TimeFinished("timeFinished"),
    CisBenchmarkScanIssuesCount("cisBenchmarkScanIssuesCount"),
    ;

    private final String value;
    private static java.util.Map<String, HostCisBenchmarkScanResultSortBy> map;

    static {
        map = new java.util.HashMap<>();
        for (HostCisBenchmarkScanResultSortBy v : HostCisBenchmarkScanResultSortBy.values()) {
            map.put(v.getValue(), v);
        }
    }

    HostCisBenchmarkScanResultSortBy(String value) {
        this.value = value;
    }

    @com.fasterxml.jackson.annotation.JsonValue
    public String getValue() {
        return value;
    }

    @com.fasterxml.jackson.annotation.JsonCreator
    public static HostCisBenchmarkScanResultSortBy create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid HostCisBenchmarkScanResultSortBy: " + key);
    }
}
