/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * A summary of a result for all CIS (Center for Internet Security) benchmark execution for this
 * host <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = HostCisBenchmarkScanResultSummary.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class HostCisBenchmarkScanResultSummary
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "displayName",
        "instanceId",
        "compartmentId",
        "timeStarted",
        "timeFinished",
        "cisBenchmarkScanIssuesCount",
        "lifecycleState"
    })
    public HostCisBenchmarkScanResultSummary(
            String id,
            String displayName,
            String instanceId,
            String compartmentId,
            java.util.Date timeStarted,
            java.util.Date timeFinished,
            Integer cisBenchmarkScanIssuesCount,
            LifecycleState lifecycleState) {
        super();
        this.id = id;
        this.displayName = displayName;
        this.instanceId = instanceId;
        this.compartmentId = compartmentId;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.cisBenchmarkScanIssuesCount = cisBenchmarkScanIssuesCount;
        this.lifecycleState = lifecycleState;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** Unique identifier of the scan */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * Unique identifier of the scan
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /** Name of the resource */
        @com.fasterxml.jackson.annotation.JsonProperty("displayName")
        private String displayName;

        /**
         * Name of the resource
         *
         * @param displayName the value to set
         * @return this builder
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }
        /** Instance ID of the Compute Instance scanned */
        @com.fasterxml.jackson.annotation.JsonProperty("instanceId")
        private String instanceId;

        /**
         * Instance ID of the Compute Instance scanned
         *
         * @param instanceId the value to set
         * @return this builder
         */
        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }
        /**
         * Compartment ID of the resource. This is set to the same as the compartment ID of the scan
         * target
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * Compartment ID of the resource. This is set to the same as the compartment ID of the scan
         * target
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /**
         * Date and time the scan was started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeStarted")
        private java.util.Date timeStarted;

        /**
         * Date and time the scan was started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeStarted the value to set
         * @return this builder
         */
        public Builder timeStarted(java.util.Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }
        /**
         * Date and time the scan was completed, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeFinished")
        private java.util.Date timeFinished;

        /**
         * Date and time the scan was completed, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeFinished the value to set
         * @return this builder
         */
        public Builder timeFinished(java.util.Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }
        /**
         * Total number of CIS (Center for Internet Security) benchmark issues found in this scan
         */
        @com.fasterxml.jackson.annotation.JsonProperty("cisBenchmarkScanIssuesCount")
        private Integer cisBenchmarkScanIssuesCount;

        /**
         * Total number of CIS (Center for Internet Security) benchmark issues found in this scan
         *
         * @param cisBenchmarkScanIssuesCount the value to set
         * @return this builder
         */
        public Builder cisBenchmarkScanIssuesCount(Integer cisBenchmarkScanIssuesCount) {
            this.cisBenchmarkScanIssuesCount = cisBenchmarkScanIssuesCount;
            this.__explicitlySet__.add("cisBenchmarkScanIssuesCount");
            return this;
        }
        /** The current state of the result. */
        @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
        private LifecycleState lifecycleState;

        /**
         * The current state of the result.
         *
         * @param lifecycleState the value to set
         * @return this builder
         */
        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public HostCisBenchmarkScanResultSummary build() {
            HostCisBenchmarkScanResultSummary model =
                    new HostCisBenchmarkScanResultSummary(
                            this.id,
                            this.displayName,
                            this.instanceId,
                            this.compartmentId,
                            this.timeStarted,
                            this.timeFinished,
                            this.cisBenchmarkScanIssuesCount,
                            this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(HostCisBenchmarkScanResultSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("cisBenchmarkScanIssuesCount")) {
                this.cisBenchmarkScanIssuesCount(model.getCisBenchmarkScanIssuesCount());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** Unique identifier of the scan */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * Unique identifier of the scan
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /** Name of the resource */
    @com.fasterxml.jackson.annotation.JsonProperty("displayName")
    private final String displayName;

    /**
     * Name of the resource
     *
     * @return the value
     */
    public String getDisplayName() {
        return displayName;
    }

    /** Instance ID of the Compute Instance scanned */
    @com.fasterxml.jackson.annotation.JsonProperty("instanceId")
    private final String instanceId;

    /**
     * Instance ID of the Compute Instance scanned
     *
     * @return the value
     */
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * Compartment ID of the resource. This is set to the same as the compartment ID of the scan
     * target
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * Compartment ID of the resource. This is set to the same as the compartment ID of the scan
     * target
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /**
     * Date and time the scan was started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeStarted")
    private final java.util.Date timeStarted;

    /**
     * Date and time the scan was started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeStarted() {
        return timeStarted;
    }

    /**
     * Date and time the scan was completed, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeFinished")
    private final java.util.Date timeFinished;

    /**
     * Date and time the scan was completed, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeFinished() {
        return timeFinished;
    }

    /** Total number of CIS (Center for Internet Security) benchmark issues found in this scan */
    @com.fasterxml.jackson.annotation.JsonProperty("cisBenchmarkScanIssuesCount")
    private final Integer cisBenchmarkScanIssuesCount;

    /**
     * Total number of CIS (Center for Internet Security) benchmark issues found in this scan
     *
     * @return the value
     */
    public Integer getCisBenchmarkScanIssuesCount() {
        return cisBenchmarkScanIssuesCount;
    }

    /** The current state of the result. */
    @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
    private final LifecycleState lifecycleState;

    /**
     * The current state of the result.
     *
     * @return the value
     */
    public LifecycleState getLifecycleState() {
        return lifecycleState;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("HostCisBenchmarkScanResultSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", cisBenchmarkScanIssuesCount=")
                .append(String.valueOf(this.cisBenchmarkScanIssuesCount));
        sb.append(", lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostCisBenchmarkScanResultSummary)) {
            return false;
        }

        HostCisBenchmarkScanResultSummary other = (HostCisBenchmarkScanResultSummary) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.instanceId, other.instanceId)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.timeStarted, other.timeStarted)
                && java.util.Objects.equals(this.timeFinished, other.timeFinished)
                && java.util.Objects.equals(
                        this.cisBenchmarkScanIssuesCount, other.cisBenchmarkScanIssuesCount)
                && java.util.Objects.equals(this.lifecycleState, other.lifecycleState)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = (result * PRIME) + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = (result * PRIME) + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = (result * PRIME) + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result =
                (result * PRIME)
                        + (this.cisBenchmarkScanIssuesCount == null
                                ? 43
                                : this.cisBenchmarkScanIssuesCount.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
