/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * An endpoint protection found in a host scan <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = HostEndpointProtectionScanResultEndpointProtection.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class HostEndpointProtectionScanResultEndpointProtection
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "service",
        "configurationFinding",
        "timeSignatureUpdated",
        "severity"
    })
    public HostEndpointProtectionScanResultEndpointProtection(
            String service,
            String configurationFinding,
            java.util.Date timeSignatureUpdated,
            ScanResultProblemSeverity severity) {
        super();
        this.service = service;
        this.configurationFinding = configurationFinding;
        this.timeSignatureUpdated = timeSignatureUpdated;
        this.severity = severity;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** Name of endpoint protection service */
        @com.fasterxml.jackson.annotation.JsonProperty("service")
        private String service;

        /**
         * Name of endpoint protection service
         *
         * @param service the value to set
         * @return this builder
         */
        public Builder service(String service) {
            this.service = service;
            this.__explicitlySet__.add("service");
            return this;
        }
        /** Configuration information for endpoint protection service at the time of scan */
        @com.fasterxml.jackson.annotation.JsonProperty("configurationFinding")
        private String configurationFinding;

        /**
         * Configuration information for endpoint protection service at the time of scan
         *
         * @param configurationFinding the value to set
         * @return this builder
         */
        public Builder configurationFinding(String configurationFinding) {
            this.configurationFinding = configurationFinding;
            this.__explicitlySet__.add("configurationFinding");
            return this;
        }
        /**
         * Date and time endpoint protection signature was updated, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeSignatureUpdated")
        private java.util.Date timeSignatureUpdated;

        /**
         * Date and time endpoint protection signature was updated, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeSignatureUpdated the value to set
         * @return this builder
         */
        public Builder timeSignatureUpdated(java.util.Date timeSignatureUpdated) {
            this.timeSignatureUpdated = timeSignatureUpdated;
            this.__explicitlySet__.add("timeSignatureUpdated");
            return this;
        }
        /** Problem severity */
        @com.fasterxml.jackson.annotation.JsonProperty("severity")
        private ScanResultProblemSeverity severity;

        /**
         * Problem severity
         *
         * @param severity the value to set
         * @return this builder
         */
        public Builder severity(ScanResultProblemSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public HostEndpointProtectionScanResultEndpointProtection build() {
            HostEndpointProtectionScanResultEndpointProtection model =
                    new HostEndpointProtectionScanResultEndpointProtection(
                            this.service,
                            this.configurationFinding,
                            this.timeSignatureUpdated,
                            this.severity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(HostEndpointProtectionScanResultEndpointProtection model) {
            if (model.wasPropertyExplicitlySet("service")) {
                this.service(model.getService());
            }
            if (model.wasPropertyExplicitlySet("configurationFinding")) {
                this.configurationFinding(model.getConfigurationFinding());
            }
            if (model.wasPropertyExplicitlySet("timeSignatureUpdated")) {
                this.timeSignatureUpdated(model.getTimeSignatureUpdated());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** Name of endpoint protection service */
    @com.fasterxml.jackson.annotation.JsonProperty("service")
    private final String service;

    /**
     * Name of endpoint protection service
     *
     * @return the value
     */
    public String getService() {
        return service;
    }

    /** Configuration information for endpoint protection service at the time of scan */
    @com.fasterxml.jackson.annotation.JsonProperty("configurationFinding")
    private final String configurationFinding;

    /**
     * Configuration information for endpoint protection service at the time of scan
     *
     * @return the value
     */
    public String getConfigurationFinding() {
        return configurationFinding;
    }

    /**
     * Date and time endpoint protection signature was updated, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeSignatureUpdated")
    private final java.util.Date timeSignatureUpdated;

    /**
     * Date and time endpoint protection signature was updated, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeSignatureUpdated() {
        return timeSignatureUpdated;
    }

    /** Problem severity */
    @com.fasterxml.jackson.annotation.JsonProperty("severity")
    private final ScanResultProblemSeverity severity;

    /**
     * Problem severity
     *
     * @return the value
     */
    public ScanResultProblemSeverity getSeverity() {
        return severity;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("HostEndpointProtectionScanResultEndpointProtection(");
        sb.append("super=").append(super.toString());
        sb.append("service=").append(String.valueOf(this.service));
        sb.append(", configurationFinding=").append(String.valueOf(this.configurationFinding));
        sb.append(", timeSignatureUpdated=").append(String.valueOf(this.timeSignatureUpdated));
        sb.append(", severity=").append(String.valueOf(this.severity));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostEndpointProtectionScanResultEndpointProtection)) {
            return false;
        }

        HostEndpointProtectionScanResultEndpointProtection other =
                (HostEndpointProtectionScanResultEndpointProtection) o;
        return java.util.Objects.equals(this.service, other.service)
                && java.util.Objects.equals(this.configurationFinding, other.configurationFinding)
                && java.util.Objects.equals(this.timeSignatureUpdated, other.timeSignatureUpdated)
                && java.util.Objects.equals(this.severity, other.severity)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.service == null ? 43 : this.service.hashCode());
        result =
                (result * PRIME)
                        + (this.configurationFinding == null
                                ? 43
                                : this.configurationFinding.hashCode());
        result =
                (result * PRIME)
                        + (this.timeSignatureUpdated == null
                                ? 43
                                : this.timeSignatureUpdated.hashCode());
        result = (result * PRIME) + (this.severity == null ? 43 : this.severity.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
