/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Summary of a host scan vulnerability <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = HostVulnerabilitySummary.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class HostVulnerabilitySummary
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "compartmentId",
        "cveReference",
        "severity",
        "state",
        "name",
        "timeLastDetected",
        "timeFirstDetected",
        "hostCount",
        "vulnerabilityType",
        "lifecycleState"
    })
    public HostVulnerabilitySummary(
            String id,
            String compartmentId,
            String cveReference,
            ScanResultProblemSeverity severity,
            ScanResultVulnerabilityState state,
            String name,
            java.util.Date timeLastDetected,
            java.util.Date timeFirstDetected,
            Integer hostCount,
            VulnerabilityType vulnerabilityType,
            LifecycleState lifecycleState) {
        super();
        this.id = id;
        this.compartmentId = compartmentId;
        this.cveReference = cveReference;
        this.severity = severity;
        this.state = state;
        this.name = name;
        this.timeLastDetected = timeLastDetected;
        this.timeFirstDetected = timeFirstDetected;
        this.hostCount = hostCount;
        this.vulnerabilityType = vulnerabilityType;
        this.lifecycleState = lifecycleState;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** ID of the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * ID of the vulnerability
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /**
         * Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in
         * different compartments.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in
         * different compartments.
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /** Reference to MITRE CVE ID */
        @com.fasterxml.jackson.annotation.JsonProperty("cveReference")
        private String cveReference;

        /**
         * Reference to MITRE CVE ID
         *
         * @param cveReference the value to set
         * @return this builder
         */
        public Builder cveReference(String cveReference) {
            this.cveReference = cveReference;
            this.__explicitlySet__.add("cveReference");
            return this;
        }
        /** Severity of the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("severity")
        private ScanResultProblemSeverity severity;

        /**
         * Severity of the vulnerability
         *
         * @param severity the value to set
         * @return this builder
         */
        public Builder severity(ScanResultProblemSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }
        /** State of the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("state")
        private ScanResultVulnerabilityState state;

        /**
         * State of the vulnerability
         *
         * @param state the value to set
         * @return this builder
         */
        public Builder state(ScanResultVulnerabilityState state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }
        /** Vulnerability name */
        @com.fasterxml.jackson.annotation.JsonProperty("name")
        private String name;

        /**
         * Vulnerability name
         *
         * @param name the value to set
         * @return this builder
         */
        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }
        /** Date of scan result that most recently reported the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("timeLastDetected")
        private java.util.Date timeLastDetected;

        /**
         * Date of scan result that most recently reported the vulnerability
         *
         * @param timeLastDetected the value to set
         * @return this builder
         */
        public Builder timeLastDetected(java.util.Date timeLastDetected) {
            this.timeLastDetected = timeLastDetected;
            this.__explicitlySet__.add("timeLastDetected");
            return this;
        }
        /** Date of scan result that first reported the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("timeFirstDetected")
        private java.util.Date timeFirstDetected;

        /**
         * Date of scan result that first reported the vulnerability
         *
         * @param timeFirstDetected the value to set
         * @return this builder
         */
        public Builder timeFirstDetected(java.util.Date timeFirstDetected) {
            this.timeFirstDetected = timeFirstDetected;
            this.__explicitlySet__.add("timeFirstDetected");
            return this;
        }
        /**
         * Number of scanned hosts in this compartment whose scan results currently report this
         * vulnerability
         */
        @com.fasterxml.jackson.annotation.JsonProperty("hostCount")
        private Integer hostCount;

        /**
         * Number of scanned hosts in this compartment whose scan results currently report this
         * vulnerability
         *
         * @param hostCount the value to set
         * @return this builder
         */
        public Builder hostCount(Integer hostCount) {
            this.hostCount = hostCount;
            this.__explicitlySet__.add("hostCount");
            return this;
        }
        /** Specifies the type of Vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilityType")
        private VulnerabilityType vulnerabilityType;

        /**
         * Specifies the type of Vulnerability
         *
         * @param vulnerabilityType the value to set
         * @return this builder
         */
        public Builder vulnerabilityType(VulnerabilityType vulnerabilityType) {
            this.vulnerabilityType = vulnerabilityType;
            this.__explicitlySet__.add("vulnerabilityType");
            return this;
        }
        /** The current state of the resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
        private LifecycleState lifecycleState;

        /**
         * The current state of the resource.
         *
         * @param lifecycleState the value to set
         * @return this builder
         */
        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public HostVulnerabilitySummary build() {
            HostVulnerabilitySummary model =
                    new HostVulnerabilitySummary(
                            this.id,
                            this.compartmentId,
                            this.cveReference,
                            this.severity,
                            this.state,
                            this.name,
                            this.timeLastDetected,
                            this.timeFirstDetected,
                            this.hostCount,
                            this.vulnerabilityType,
                            this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(HostVulnerabilitySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("cveReference")) {
                this.cveReference(model.getCveReference());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetected")) {
                this.timeLastDetected(model.getTimeLastDetected());
            }
            if (model.wasPropertyExplicitlySet("timeFirstDetected")) {
                this.timeFirstDetected(model.getTimeFirstDetected());
            }
            if (model.wasPropertyExplicitlySet("hostCount")) {
                this.hostCount(model.getHostCount());
            }
            if (model.wasPropertyExplicitlySet("vulnerabilityType")) {
                this.vulnerabilityType(model.getVulnerabilityType());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** ID of the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * ID of the vulnerability
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /**
     * Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in
     * different compartments.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in
     * different compartments.
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /** Reference to MITRE CVE ID */
    @com.fasterxml.jackson.annotation.JsonProperty("cveReference")
    private final String cveReference;

    /**
     * Reference to MITRE CVE ID
     *
     * @return the value
     */
    public String getCveReference() {
        return cveReference;
    }

    /** Severity of the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("severity")
    private final ScanResultProblemSeverity severity;

    /**
     * Severity of the vulnerability
     *
     * @return the value
     */
    public ScanResultProblemSeverity getSeverity() {
        return severity;
    }

    /** State of the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("state")
    private final ScanResultVulnerabilityState state;

    /**
     * State of the vulnerability
     *
     * @return the value
     */
    public ScanResultVulnerabilityState getState() {
        return state;
    }

    /** Vulnerability name */
    @com.fasterxml.jackson.annotation.JsonProperty("name")
    private final String name;

    /**
     * Vulnerability name
     *
     * @return the value
     */
    public String getName() {
        return name;
    }

    /** Date of scan result that most recently reported the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("timeLastDetected")
    private final java.util.Date timeLastDetected;

    /**
     * Date of scan result that most recently reported the vulnerability
     *
     * @return the value
     */
    public java.util.Date getTimeLastDetected() {
        return timeLastDetected;
    }

    /** Date of scan result that first reported the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("timeFirstDetected")
    private final java.util.Date timeFirstDetected;

    /**
     * Date of scan result that first reported the vulnerability
     *
     * @return the value
     */
    public java.util.Date getTimeFirstDetected() {
        return timeFirstDetected;
    }

    /**
     * Number of scanned hosts in this compartment whose scan results currently report this
     * vulnerability
     */
    @com.fasterxml.jackson.annotation.JsonProperty("hostCount")
    private final Integer hostCount;

    /**
     * Number of scanned hosts in this compartment whose scan results currently report this
     * vulnerability
     *
     * @return the value
     */
    public Integer getHostCount() {
        return hostCount;
    }

    /** Specifies the type of Vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilityType")
    private final VulnerabilityType vulnerabilityType;

    /**
     * Specifies the type of Vulnerability
     *
     * @return the value
     */
    public VulnerabilityType getVulnerabilityType() {
        return vulnerabilityType;
    }

    /** The current state of the resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
    private final LifecycleState lifecycleState;

    /**
     * The current state of the resource.
     *
     * @return the value
     */
    public LifecycleState getLifecycleState() {
        return lifecycleState;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("HostVulnerabilitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", cveReference=").append(String.valueOf(this.cveReference));
        sb.append(", severity=").append(String.valueOf(this.severity));
        sb.append(", state=").append(String.valueOf(this.state));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", timeLastDetected=").append(String.valueOf(this.timeLastDetected));
        sb.append(", timeFirstDetected=").append(String.valueOf(this.timeFirstDetected));
        sb.append(", hostCount=").append(String.valueOf(this.hostCount));
        sb.append(", vulnerabilityType=").append(String.valueOf(this.vulnerabilityType));
        sb.append(", lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostVulnerabilitySummary)) {
            return false;
        }

        HostVulnerabilitySummary other = (HostVulnerabilitySummary) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.cveReference, other.cveReference)
                && java.util.Objects.equals(this.severity, other.severity)
                && java.util.Objects.equals(this.state, other.state)
                && java.util.Objects.equals(this.name, other.name)
                && java.util.Objects.equals(this.timeLastDetected, other.timeLastDetected)
                && java.util.Objects.equals(this.timeFirstDetected, other.timeFirstDetected)
                && java.util.Objects.equals(this.hostCount, other.hostCount)
                && java.util.Objects.equals(this.vulnerabilityType, other.vulnerabilityType)
                && java.util.Objects.equals(this.lifecycleState, other.lifecycleState)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = (result * PRIME) + (this.cveReference == null ? 43 : this.cveReference.hashCode());
        result = (result * PRIME) + (this.severity == null ? 43 : this.severity.hashCode());
        result = (result * PRIME) + (this.state == null ? 43 : this.state.hashCode());
        result = (result * PRIME) + (this.name == null ? 43 : this.name.hashCode());
        result =
                (result * PRIME)
                        + (this.timeLastDetected == null ? 43 : this.timeLastDetected.hashCode());
        result =
                (result * PRIME)
                        + (this.timeFirstDetected == null ? 43 : this.timeFirstDetected.hashCode());
        result = (result * PRIME) + (this.hostCount == null ? 43 : this.hostCount.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerabilityType == null ? 43 : this.vulnerabilityType.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
