/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Details of the vulnerable package found <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = Package.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class Package extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"name", "version", "cveFixVersion", "type", "locations"})
    public Package(
            String name,
            String version,
            String cveFixVersion,
            Type type,
            java.util.List<String> locations) {
        super();
        this.name = name;
        this.version = version;
        this.cveFixVersion = cveFixVersion;
        this.type = type;
        this.locations = locations;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** Name of the package */
        @com.fasterxml.jackson.annotation.JsonProperty("name")
        private String name;

        /**
         * Name of the package
         *
         * @param name the value to set
         * @return this builder
         */
        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }
        /** Package version */
        @com.fasterxml.jackson.annotation.JsonProperty("version")
        private String version;

        /**
         * Package version
         *
         * @param version the value to set
         * @return this builder
         */
        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }
        /** Package version in which the CVE was fixed */
        @com.fasterxml.jackson.annotation.JsonProperty("cveFixVersion")
        private String cveFixVersion;

        /**
         * Package version in which the CVE was fixed
         *
         * @param cveFixVersion the value to set
         * @return this builder
         */
        public Builder cveFixVersion(String cveFixVersion) {
            this.cveFixVersion = cveFixVersion;
            this.__explicitlySet__.add("cveFixVersion");
            return this;
        }
        /** Package type */
        @com.fasterxml.jackson.annotation.JsonProperty("type")
        private Type type;

        /**
         * Package type
         *
         * @param type the value to set
         * @return this builder
         */
        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }
        /** Disk locations where package was found */
        @com.fasterxml.jackson.annotation.JsonProperty("locations")
        private java.util.List<String> locations;

        /**
         * Disk locations where package was found
         *
         * @param locations the value to set
         * @return this builder
         */
        public Builder locations(java.util.List<String> locations) {
            this.locations = locations;
            this.__explicitlySet__.add("locations");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public Package build() {
            Package model =
                    new Package(
                            this.name, this.version, this.cveFixVersion, this.type, this.locations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(Package model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("cveFixVersion")) {
                this.cveFixVersion(model.getCveFixVersion());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("locations")) {
                this.locations(model.getLocations());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** Name of the package */
    @com.fasterxml.jackson.annotation.JsonProperty("name")
    private final String name;

    /**
     * Name of the package
     *
     * @return the value
     */
    public String getName() {
        return name;
    }

    /** Package version */
    @com.fasterxml.jackson.annotation.JsonProperty("version")
    private final String version;

    /**
     * Package version
     *
     * @return the value
     */
    public String getVersion() {
        return version;
    }

    /** Package version in which the CVE was fixed */
    @com.fasterxml.jackson.annotation.JsonProperty("cveFixVersion")
    private final String cveFixVersion;

    /**
     * Package version in which the CVE was fixed
     *
     * @return the value
     */
    public String getCveFixVersion() {
        return cveFixVersion;
    }

    /** Package type */
    public enum Type implements com.oracle.bmc.http.internal.BmcEnum {
        Java("JAVA"),
        Apk("APK"),
        Rpm("RPM"),
        Deb("DEB"),
        Go("GO"),
        Npm("NPM"),
        Python("PYTHON"),
        Rust("RUST"),
        PhpComposer("PHP_COMPOSER"),
        Gem("GEM"),
        MsrcKb("MSRC_KB"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by
         * this version of the SDK.
         */
        UnknownEnumValue(null);

        private static final org.slf4j.Logger LOG = org.slf4j.LoggerFactory.getLogger(Type.class);

        private final String value;
        private static java.util.Map<String, Type> map;

        static {
            map = new java.util.HashMap<>();
            for (Type v : Type.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        Type(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", key);
            return UnknownEnumValue;
        }
    };
    /** Package type */
    @com.fasterxml.jackson.annotation.JsonProperty("type")
    private final Type type;

    /**
     * Package type
     *
     * @return the value
     */
    public Type getType() {
        return type;
    }

    /** Disk locations where package was found */
    @com.fasterxml.jackson.annotation.JsonProperty("locations")
    private final java.util.List<String> locations;

    /**
     * Disk locations where package was found
     *
     * @return the value
     */
    public java.util.List<String> getLocations() {
        return locations;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("Package(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", cveFixVersion=").append(String.valueOf(this.cveFixVersion));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", locations=").append(String.valueOf(this.locations));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Package)) {
            return false;
        }

        Package other = (Package) o;
        return java.util.Objects.equals(this.name, other.name)
                && java.util.Objects.equals(this.version, other.version)
                && java.util.Objects.equals(this.cveFixVersion, other.cveFixVersion)
                && java.util.Objects.equals(this.type, other.type)
                && java.util.Objects.equals(this.locations, other.locations)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.name == null ? 43 : this.name.hashCode());
        result = (result * PRIME) + (this.version == null ? 43 : this.version.hashCode());
        result =
                (result * PRIME)
                        + (this.cveFixVersion == null ? 43 : this.cveFixVersion.hashCode());
        result = (result * PRIME) + (this.type == null ? 43 : this.type.hashCode());
        result = (result * PRIME) + (this.locations == null ? 43 : this.locations.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
