/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Information on a container image impacted by a vulnerability <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = VulnerabilityImpactedContainerSummary.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class VulnerabilityImpactedContainerSummary
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "containerScanTargetId",
        "repository",
        "registry",
        "image",
        "lastContainerScanId",
        "timeScanCompleted"
    })
    public VulnerabilityImpactedContainerSummary(
            String containerScanTargetId,
            String repository,
            String registry,
            String image,
            String lastContainerScanId,
            java.util.Date timeScanCompleted) {
        super();
        this.containerScanTargetId = containerScanTargetId;
        this.repository = repository;
        this.registry = registry;
        this.image = image;
        this.lastContainerScanId = lastContainerScanId;
        this.timeScanCompleted = timeScanCompleted;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** The scan target id of the repository scan result */
        @com.fasterxml.jackson.annotation.JsonProperty("containerScanTargetId")
        private String containerScanTargetId;

        /**
         * The scan target id of the repository scan result
         *
         * @param containerScanTargetId the value to set
         * @return this builder
         */
        public Builder containerScanTargetId(String containerScanTargetId) {
            this.containerScanTargetId = containerScanTargetId;
            this.__explicitlySet__.add("containerScanTargetId");
            return this;
        }
        /** The repository id of the container image. */
        @com.fasterxml.jackson.annotation.JsonProperty("repository")
        private String repository;

        /**
         * The repository id of the container image.
         *
         * @param repository the value to set
         * @return this builder
         */
        public Builder repository(String repository) {
            this.repository = repository;
            this.__explicitlySet__.add("repository");
            return this;
        }
        /** The registry key of the container image. */
        @com.fasterxml.jackson.annotation.JsonProperty("registry")
        private String registry;

        /**
         * The registry key of the container image.
         *
         * @param registry the value to set
         * @return this builder
         */
        public Builder registry(String registry) {
            this.registry = registry;
            this.__explicitlySet__.add("registry");
            return this;
        }
        /** The name of the container image. */
        @com.fasterxml.jackson.annotation.JsonProperty("image")
        private String image;

        /**
         * The name of the container image.
         *
         * @param image the value to set
         * @return this builder
         */
        public Builder image(String image) {
            this.image = image;
            this.__explicitlySet__.add("image");
            return this;
        }
        /** The ID of the last container image scan result Id */
        @com.fasterxml.jackson.annotation.JsonProperty("lastContainerScanId")
        private String lastContainerScanId;

        /**
         * The ID of the last container image scan result Id
         *
         * @param lastContainerScanId the value to set
         * @return this builder
         */
        public Builder lastContainerScanId(String lastContainerScanId) {
            this.lastContainerScanId = lastContainerScanId;
            this.__explicitlySet__.add("lastContainerScanId");
            return this;
        }
        /**
         * Date and time the scan was completed, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeScanCompleted")
        private java.util.Date timeScanCompleted;

        /**
         * Date and time the scan was completed, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeScanCompleted the value to set
         * @return this builder
         */
        public Builder timeScanCompleted(java.util.Date timeScanCompleted) {
            this.timeScanCompleted = timeScanCompleted;
            this.__explicitlySet__.add("timeScanCompleted");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public VulnerabilityImpactedContainerSummary build() {
            VulnerabilityImpactedContainerSummary model =
                    new VulnerabilityImpactedContainerSummary(
                            this.containerScanTargetId,
                            this.repository,
                            this.registry,
                            this.image,
                            this.lastContainerScanId,
                            this.timeScanCompleted);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(VulnerabilityImpactedContainerSummary model) {
            if (model.wasPropertyExplicitlySet("containerScanTargetId")) {
                this.containerScanTargetId(model.getContainerScanTargetId());
            }
            if (model.wasPropertyExplicitlySet("repository")) {
                this.repository(model.getRepository());
            }
            if (model.wasPropertyExplicitlySet("registry")) {
                this.registry(model.getRegistry());
            }
            if (model.wasPropertyExplicitlySet("image")) {
                this.image(model.getImage());
            }
            if (model.wasPropertyExplicitlySet("lastContainerScanId")) {
                this.lastContainerScanId(model.getLastContainerScanId());
            }
            if (model.wasPropertyExplicitlySet("timeScanCompleted")) {
                this.timeScanCompleted(model.getTimeScanCompleted());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** The scan target id of the repository scan result */
    @com.fasterxml.jackson.annotation.JsonProperty("containerScanTargetId")
    private final String containerScanTargetId;

    /**
     * The scan target id of the repository scan result
     *
     * @return the value
     */
    public String getContainerScanTargetId() {
        return containerScanTargetId;
    }

    /** The repository id of the container image. */
    @com.fasterxml.jackson.annotation.JsonProperty("repository")
    private final String repository;

    /**
     * The repository id of the container image.
     *
     * @return the value
     */
    public String getRepository() {
        return repository;
    }

    /** The registry key of the container image. */
    @com.fasterxml.jackson.annotation.JsonProperty("registry")
    private final String registry;

    /**
     * The registry key of the container image.
     *
     * @return the value
     */
    public String getRegistry() {
        return registry;
    }

    /** The name of the container image. */
    @com.fasterxml.jackson.annotation.JsonProperty("image")
    private final String image;

    /**
     * The name of the container image.
     *
     * @return the value
     */
    public String getImage() {
        return image;
    }

    /** The ID of the last container image scan result Id */
    @com.fasterxml.jackson.annotation.JsonProperty("lastContainerScanId")
    private final String lastContainerScanId;

    /**
     * The ID of the last container image scan result Id
     *
     * @return the value
     */
    public String getLastContainerScanId() {
        return lastContainerScanId;
    }

    /**
     * Date and time the scan was completed, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeScanCompleted")
    private final java.util.Date timeScanCompleted;

    /**
     * Date and time the scan was completed, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeScanCompleted() {
        return timeScanCompleted;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("VulnerabilityImpactedContainerSummary(");
        sb.append("super=").append(super.toString());
        sb.append("containerScanTargetId=").append(String.valueOf(this.containerScanTargetId));
        sb.append(", repository=").append(String.valueOf(this.repository));
        sb.append(", registry=").append(String.valueOf(this.registry));
        sb.append(", image=").append(String.valueOf(this.image));
        sb.append(", lastContainerScanId=").append(String.valueOf(this.lastContainerScanId));
        sb.append(", timeScanCompleted=").append(String.valueOf(this.timeScanCompleted));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VulnerabilityImpactedContainerSummary)) {
            return false;
        }

        VulnerabilityImpactedContainerSummary other = (VulnerabilityImpactedContainerSummary) o;
        return java.util.Objects.equals(this.containerScanTargetId, other.containerScanTargetId)
                && java.util.Objects.equals(this.repository, other.repository)
                && java.util.Objects.equals(this.registry, other.registry)
                && java.util.Objects.equals(this.image, other.image)
                && java.util.Objects.equals(this.lastContainerScanId, other.lastContainerScanId)
                && java.util.Objects.equals(this.timeScanCompleted, other.timeScanCompleted)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.containerScanTargetId == null
                                ? 43
                                : this.containerScanTargetId.hashCode());
        result = (result * PRIME) + (this.repository == null ? 43 : this.repository.hashCode());
        result = (result * PRIME) + (this.registry == null ? 43 : this.registry.hashCode());
        result = (result * PRIME) + (this.image == null ? 43 : this.image.hashCode());
        result =
                (result * PRIME)
                        + (this.lastContainerScanId == null
                                ? 43
                                : this.lastContainerScanId.hashCode());
        result =
                (result * PRIME)
                        + (this.timeScanCompleted == null ? 43 : this.timeScanCompleted.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
