/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.vulnerabilityscanning.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/vulnerabilityscanning/ListHostCisBenchmarkScanResultsExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use
 * ListHostCisBenchmarkScanResultsRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
public class ListHostCisBenchmarkScanResultsRequest
        extends com.oracle.bmc.requests.BmcRequest<java.lang.Void> {

    /** The ID of the compartment in which to list resources. */
    private String compartmentId;

    /** The ID of the compartment in which to list resources. */
    public String getCompartmentId() {
        return compartmentId;
    }
    /** The ID of a compute instance */
    private String instanceId;

    /** The ID of a compute instance */
    public String getInstanceId() {
        return instanceId;
    }
    /** Parameter to filter by highestProblemSeverity for scan results */
    private com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity
            highestProblemSeverity;

    /** Parameter to filter by highestProblemSeverity for scan results */
    public com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity
            getHighestProblemSeverity() {
        return highestProblemSeverity;
    }
    /**
     * Date and time on or after which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    private java.util.Date timeStartedGreaterThanOrEqualTo;

    /**
     * Date and time on or after which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    public java.util.Date getTimeStartedGreaterThanOrEqualTo() {
        return timeStartedGreaterThanOrEqualTo;
    }
    /**
     * Date and time on or before which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    private java.util.Date timeStartedLessThanOrEqualTo;

    /**
     * Date and time on or before which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    public java.util.Date getTimeStartedLessThanOrEqualTo() {
        return timeStartedLessThanOrEqualTo;
    }
    /** The sort order to use, either 'ASC' or 'DESC'. */
    private com.oracle.bmc.vulnerabilityscanning.model.SortOrder sortOrder;

    /** The sort order to use, either 'ASC' or 'DESC'. */
    public com.oracle.bmc.vulnerabilityscanning.model.SortOrder getSortOrder() {
        return sortOrder;
    }
    /**
     * The field to sort by. Only one sort order may be provided. Default order is descending. If no
     * value is specified timeFinished is default.
     */
    private com.oracle.bmc.vulnerabilityscanning.model.HostCisBenchmarkScanResultSortBy sortBy;

    /**
     * The field to sort by. Only one sort order may be provided. Default order is descending. If no
     * value is specified timeFinished is default.
     */
    public com.oracle.bmc.vulnerabilityscanning.model.HostCisBenchmarkScanResultSortBy getSortBy() {
        return sortBy;
    }
    /** The maximum number of items to return. */
    private Integer limit;

    /** The maximum number of items to return. */
    public Integer getLimit() {
        return limit;
    }
    /**
     * The page token representing the page at which to start retrieving results. This is usually
     * retrieved from a previous list call.
     */
    private String page;

    /**
     * The page token representing the page at which to start retrieving results. This is usually
     * retrieved from a previous list call.
     */
    public String getPage() {
        return page;
    }
    /** The client request ID for tracing. */
    private String opcRequestId;

    /** The client request ID for tracing. */
    public String getOpcRequestId() {
        return opcRequestId;
    }
    /** A filter to return only resources that match the entire display name given. */
    private String displayName;

    /** A filter to return only resources that match the entire display name given. */
    public String getDisplayName() {
        return displayName;
    }
    /** A flag to return only the latest scan result of an instance. */
    private Boolean isLatestOnly;

    /** A flag to return only the latest scan result of an instance. */
    public Boolean getIsLatestOnly() {
        return isLatestOnly;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    ListHostCisBenchmarkScanResultsRequest, java.lang.Void> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /** The ID of the compartment in which to list resources. */
        private String compartmentId = null;

        /**
         * The ID of the compartment in which to list resources.
         *
         * @param compartmentId the value to set
         * @return this builder instance
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        /** The ID of a compute instance */
        private String instanceId = null;

        /**
         * The ID of a compute instance
         *
         * @param instanceId the value to set
         * @return this builder instance
         */
        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /** Parameter to filter by highestProblemSeverity for scan results */
        private com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity
                highestProblemSeverity = null;

        /**
         * Parameter to filter by highestProblemSeverity for scan results
         *
         * @param highestProblemSeverity the value to set
         * @return this builder instance
         */
        public Builder highestProblemSeverity(
                com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity
                        highestProblemSeverity) {
            this.highestProblemSeverity = highestProblemSeverity;
            return this;
        }

        /**
         * Date and time on or after which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        private java.util.Date timeStartedGreaterThanOrEqualTo = null;

        /**
         * Date and time on or after which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeStartedGreaterThanOrEqualTo the value to set
         * @return this builder instance
         */
        public Builder timeStartedGreaterThanOrEqualTo(
                java.util.Date timeStartedGreaterThanOrEqualTo) {
            this.timeStartedGreaterThanOrEqualTo = timeStartedGreaterThanOrEqualTo;
            return this;
        }

        /**
         * Date and time on or before which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        private java.util.Date timeStartedLessThanOrEqualTo = null;

        /**
         * Date and time on or before which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeStartedLessThanOrEqualTo the value to set
         * @return this builder instance
         */
        public Builder timeStartedLessThanOrEqualTo(java.util.Date timeStartedLessThanOrEqualTo) {
            this.timeStartedLessThanOrEqualTo = timeStartedLessThanOrEqualTo;
            return this;
        }

        /** The sort order to use, either 'ASC' or 'DESC'. */
        private com.oracle.bmc.vulnerabilityscanning.model.SortOrder sortOrder = null;

        /**
         * The sort order to use, either 'ASC' or 'DESC'.
         *
         * @param sortOrder the value to set
         * @return this builder instance
         */
        public Builder sortOrder(com.oracle.bmc.vulnerabilityscanning.model.SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        /**
         * The field to sort by. Only one sort order may be provided. Default order is descending.
         * If no value is specified timeFinished is default.
         */
        private com.oracle.bmc.vulnerabilityscanning.model.HostCisBenchmarkScanResultSortBy sortBy =
                null;

        /**
         * The field to sort by. Only one sort order may be provided. Default order is descending.
         * If no value is specified timeFinished is default.
         *
         * @param sortBy the value to set
         * @return this builder instance
         */
        public Builder sortBy(
                com.oracle.bmc.vulnerabilityscanning.model.HostCisBenchmarkScanResultSortBy
                        sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        /** The maximum number of items to return. */
        private Integer limit = null;

        /**
         * The maximum number of items to return.
         *
         * @param limit the value to set
         * @return this builder instance
         */
        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * The page token representing the page at which to start retrieving results. This is
         * usually retrieved from a previous list call.
         */
        private String page = null;

        /**
         * The page token representing the page at which to start retrieving results. This is
         * usually retrieved from a previous list call.
         *
         * @param page the value to set
         * @return this builder instance
         */
        public Builder page(String page) {
            this.page = page;
            return this;
        }

        /** The client request ID for tracing. */
        private String opcRequestId = null;

        /**
         * The client request ID for tracing.
         *
         * @param opcRequestId the value to set
         * @return this builder instance
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /** A filter to return only resources that match the entire display name given. */
        private String displayName = null;

        /**
         * A filter to return only resources that match the entire display name given.
         *
         * @param displayName the value to set
         * @return this builder instance
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        /** A flag to return only the latest scan result of an instance. */
        private Boolean isLatestOnly = null;

        /**
         * A flag to return only the latest scan result of an instance.
         *
         * @param isLatestOnly the value to set
         * @return this builder instance
         */
        public Builder isLatestOnly(Boolean isLatestOnly) {
            this.isLatestOnly = isLatestOnly;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(ListHostCisBenchmarkScanResultsRequest o) {
            compartmentId(o.getCompartmentId());
            instanceId(o.getInstanceId());
            highestProblemSeverity(o.getHighestProblemSeverity());
            timeStartedGreaterThanOrEqualTo(o.getTimeStartedGreaterThanOrEqualTo());
            timeStartedLessThanOrEqualTo(o.getTimeStartedLessThanOrEqualTo());
            sortOrder(o.getSortOrder());
            sortBy(o.getSortBy());
            limit(o.getLimit());
            page(o.getPage());
            opcRequestId(o.getOpcRequestId());
            displayName(o.getDisplayName());
            isLatestOnly(o.getIsLatestOnly());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of ListHostCisBenchmarkScanResultsRequest as configured by this
         * builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of ListHostCisBenchmarkScanResultsRequest
         */
        public ListHostCisBenchmarkScanResultsRequest build() {
            ListHostCisBenchmarkScanResultsRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Build the instance of ListHostCisBenchmarkScanResultsRequest as configured by this
         * builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of ListHostCisBenchmarkScanResultsRequest
         */
        public ListHostCisBenchmarkScanResultsRequest buildWithoutInvocationCallback() {
            ListHostCisBenchmarkScanResultsRequest request =
                    new ListHostCisBenchmarkScanResultsRequest();
            request.compartmentId = compartmentId;
            request.instanceId = instanceId;
            request.highestProblemSeverity = highestProblemSeverity;
            request.timeStartedGreaterThanOrEqualTo = timeStartedGreaterThanOrEqualTo;
            request.timeStartedLessThanOrEqualTo = timeStartedLessThanOrEqualTo;
            request.sortOrder = sortOrder;
            request.sortBy = sortBy;
            request.limit = limit;
            request.page = page;
            request.opcRequestId = opcRequestId;
            request.displayName = displayName;
            request.isLatestOnly = isLatestOnly;
            return request;
            // new ListHostCisBenchmarkScanResultsRequest(compartmentId, instanceId,
            // highestProblemSeverity, timeStartedGreaterThanOrEqualTo,
            // timeStartedLessThanOrEqualTo, sortOrder, sortBy, limit, page, opcRequestId,
            // displayName, isLatestOnly);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .compartmentId(compartmentId)
                .instanceId(instanceId)
                .highestProblemSeverity(highestProblemSeverity)
                .timeStartedGreaterThanOrEqualTo(timeStartedGreaterThanOrEqualTo)
                .timeStartedLessThanOrEqualTo(timeStartedLessThanOrEqualTo)
                .sortOrder(sortOrder)
                .sortBy(sortBy)
                .limit(limit)
                .page(page)
                .opcRequestId(opcRequestId)
                .displayName(displayName)
                .isLatestOnly(isLatestOnly);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",instanceId=").append(String.valueOf(this.instanceId));
        sb.append(",highestProblemSeverity=").append(String.valueOf(this.highestProblemSeverity));
        sb.append(",timeStartedGreaterThanOrEqualTo=")
                .append(String.valueOf(this.timeStartedGreaterThanOrEqualTo));
        sb.append(",timeStartedLessThanOrEqualTo=")
                .append(String.valueOf(this.timeStartedLessThanOrEqualTo));
        sb.append(",sortOrder=").append(String.valueOf(this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf(this.sortBy));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",isLatestOnly=").append(String.valueOf(this.isLatestOnly));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListHostCisBenchmarkScanResultsRequest)) {
            return false;
        }

        ListHostCisBenchmarkScanResultsRequest other = (ListHostCisBenchmarkScanResultsRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.instanceId, other.instanceId)
                && java.util.Objects.equals(
                        this.highestProblemSeverity, other.highestProblemSeverity)
                && java.util.Objects.equals(
                        this.timeStartedGreaterThanOrEqualTo, other.timeStartedGreaterThanOrEqualTo)
                && java.util.Objects.equals(
                        this.timeStartedLessThanOrEqualTo, other.timeStartedLessThanOrEqualTo)
                && java.util.Objects.equals(this.sortOrder, other.sortOrder)
                && java.util.Objects.equals(this.sortBy, other.sortBy)
                && java.util.Objects.equals(this.limit, other.limit)
                && java.util.Objects.equals(this.page, other.page)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.isLatestOnly, other.isLatestOnly);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = (result * PRIME) + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result =
                (result * PRIME)
                        + (this.highestProblemSeverity == null
                                ? 43
                                : this.highestProblemSeverity.hashCode());
        result =
                (result * PRIME)
                        + (this.timeStartedGreaterThanOrEqualTo == null
                                ? 43
                                : this.timeStartedGreaterThanOrEqualTo.hashCode());
        result =
                (result * PRIME)
                        + (this.timeStartedLessThanOrEqualTo == null
                                ? 43
                                : this.timeStartedLessThanOrEqualTo.hashCode());
        result = (result * PRIME) + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = (result * PRIME) + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = (result * PRIME) + (this.limit == null ? 43 : this.limit.hashCode());
        result = (result * PRIME) + (this.page == null ? 43 : this.page.hashCode());
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = (result * PRIME) + (this.isLatestOnly == null ? 43 : this.isLatestOnly.hashCode());
        return result;
    }
}
