/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.DomainGovernanceAsync;
import com.oracle.bmc.tenantmanagercontrolplane.internal.http.CreateDomainGovernanceConverter;
import com.oracle.bmc.tenantmanagercontrolplane.internal.http.DeleteDomainGovernanceConverter;
import com.oracle.bmc.tenantmanagercontrolplane.internal.http.GetDomainGovernanceConverter;
import com.oracle.bmc.tenantmanagercontrolplane.internal.http.ListDomainGovernancesConverter;
import com.oracle.bmc.tenantmanagercontrolplane.internal.http.UpdateDomainGovernanceConverter;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateDomainGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteDomainGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetDomainGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListDomainGovernancesRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateDomainGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateDomainGovernanceResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteDomainGovernanceResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetDomainGovernanceResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListDomainGovernancesResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateDomainGovernanceResponse;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainGovernanceAsyncClient
implements DomainGovernanceAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DomainGovernanceAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DOMAINGOVERNANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DomainGovernanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DomainGovernanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DomainGovernanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DomainGovernanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DomainGovernanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DomainGovernanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DomainGovernanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DomainGovernanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateDomainGovernanceResponse> createDomainGovernance(CreateDomainGovernanceRequest request, AsyncHandler<CreateDomainGovernanceRequest, CreateDomainGovernanceResponse> handler) {
        LOG.trace("Called async createDomainGovernance");
        CreateDomainGovernanceRequest interceptedRequest = CreateDomainGovernanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDomainGovernanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDomainGovernanceResponse> transformer = CreateDomainGovernanceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDomainGovernanceRequest, CreateDomainGovernanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDomainGovernanceRequest, CreateDomainGovernanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDomainGovernanceResponse> deleteDomainGovernance(DeleteDomainGovernanceRequest request, AsyncHandler<DeleteDomainGovernanceRequest, DeleteDomainGovernanceResponse> handler) {
        LOG.trace("Called async deleteDomainGovernance");
        DeleteDomainGovernanceRequest interceptedRequest = DeleteDomainGovernanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDomainGovernanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDomainGovernanceResponse> transformer = DeleteDomainGovernanceConverter.fromResponse();
        AsyncHandler<DeleteDomainGovernanceRequest, DeleteDomainGovernanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDomainGovernanceRequest, DeleteDomainGovernanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDomainGovernanceResponse> getDomainGovernance(GetDomainGovernanceRequest request, AsyncHandler<GetDomainGovernanceRequest, GetDomainGovernanceResponse> handler) {
        LOG.trace("Called async getDomainGovernance");
        GetDomainGovernanceRequest interceptedRequest = GetDomainGovernanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDomainGovernanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDomainGovernanceResponse> transformer = GetDomainGovernanceConverter.fromResponse();
        AsyncHandler<GetDomainGovernanceRequest, GetDomainGovernanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDomainGovernanceRequest, GetDomainGovernanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDomainGovernancesResponse> listDomainGovernances(ListDomainGovernancesRequest request, AsyncHandler<ListDomainGovernancesRequest, ListDomainGovernancesResponse> handler) {
        LOG.trace("Called async listDomainGovernances");
        ListDomainGovernancesRequest interceptedRequest = ListDomainGovernancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDomainGovernancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDomainGovernancesResponse> transformer = ListDomainGovernancesConverter.fromResponse();
        AsyncHandler<ListDomainGovernancesRequest, ListDomainGovernancesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDomainGovernancesRequest, ListDomainGovernancesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDomainGovernanceResponse> updateDomainGovernance(UpdateDomainGovernanceRequest request, AsyncHandler<UpdateDomainGovernanceRequest, UpdateDomainGovernanceResponse> handler) {
        LOG.trace("Called async updateDomainGovernance");
        UpdateDomainGovernanceRequest interceptedRequest = UpdateDomainGovernanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDomainGovernanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDomainGovernanceResponse> transformer = UpdateDomainGovernanceConverter.fromResponse();
        AsyncHandler<UpdateDomainGovernanceRequest, UpdateDomainGovernanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDomainGovernanceRequest, UpdateDomainGovernanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DomainGovernanceAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DomainGovernanceAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DomainGovernanceAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

