/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.tenantmanagercontrolplane.Link;
import com.oracle.bmc.tenantmanagercontrolplane.model.LinkSummary;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListLinksRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListLinksResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class LinkPaginators {
    private final Link client;

    public Iterable<ListLinksResponse> listLinksResponseIterator(final ListLinksRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLinksRequest.Builder>(){

            public ListLinksRequest.Builder get() {
                return ListLinksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLinksResponse, String>(){

            public String apply(ListLinksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLinksRequest.Builder>, ListLinksRequest>(){

            public ListLinksRequest apply(RequestBuilderAndToken<ListLinksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListLinksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLinksRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListLinksRequest, ListLinksResponse>(){

            public ListLinksResponse apply(ListLinksRequest request) {
                return LinkPaginators.this.client.listLinks(request);
            }
        });
    }

    public Iterable<LinkSummary> listLinksRecordIterator(final ListLinksRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLinksRequest.Builder>(){

            public ListLinksRequest.Builder get() {
                return ListLinksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLinksResponse, String>(){

            public String apply(ListLinksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLinksRequest.Builder>, ListLinksRequest>(){

            public ListLinksRequest apply(RequestBuilderAndToken<ListLinksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListLinksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLinksRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListLinksRequest, ListLinksResponse>(){

            public ListLinksResponse apply(ListLinksRequest request) {
                return LinkPaginators.this.client.listLinks(request);
            }
        }, (Function)new Function<ListLinksResponse, List<LinkSummary>>(){

            public List<LinkSummary> apply(ListLinksResponse response) {
                return response.getLinkCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public LinkPaginators(Link client) {
        this.client = client;
    }
}

