/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.tenantmanagercontrolplane.RecipientInvitation;
import com.oracle.bmc.tenantmanagercontrolplane.model.LifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetRecipientInvitationResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class RecipientInvitationWaiters {
    private final ExecutorService executorService;
    private final RecipientInvitation client;

    public Waiter<GetRecipientInvitationRequest, GetRecipientInvitationResponse> forRecipientInvitation(GetRecipientInvitationRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRecipientInvitation(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRecipientInvitationRequest, GetRecipientInvitationResponse> forRecipientInvitation(GetRecipientInvitationRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRecipientInvitation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRecipientInvitationRequest, GetRecipientInvitationResponse> forRecipientInvitation(GetRecipientInvitationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRecipientInvitation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRecipientInvitationRequest, GetRecipientInvitationResponse> forRecipientInvitation(BmcGenericWaiter waiter, GetRecipientInvitationRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetRecipientInvitationRequest, GetRecipientInvitationResponse>(){

            public GetRecipientInvitationResponse apply(GetRecipientInvitationRequest request) {
                return RecipientInvitationWaiters.this.client.getRecipientInvitation(request);
            }
        }, (Predicate)new Predicate<GetRecipientInvitationResponse>(){

            public boolean apply(GetRecipientInvitationResponse response) {
                return targetStatesSet.contains((Object)response.getRecipientInvitation().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Terminated)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public RecipientInvitationWaiters(ExecutorService executorService, RecipientInvitation client) {
        this.executorService = executorService;
        this.client = client;
    }
}

