/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CancelSenderInvitationRequest
extends BmcRequest<Void> {
    private String senderInvitationId;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    @ConstructorProperties(value={"senderInvitationId", "ifMatch", "opcRetryToken", "opcRequestId"})
    CancelSenderInvitationRequest(String senderInvitationId, String ifMatch, String opcRetryToken, String opcRequestId) {
        this.senderInvitationId = senderInvitationId;
        this.ifMatch = ifMatch;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSenderInvitationId() {
        return this.senderInvitationId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<CancelSenderInvitationRequest, Void> {
        private String senderInvitationId;
        private String ifMatch;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelSenderInvitationRequest o) {
            this.senderInvitationId(o.getSenderInvitationId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelSenderInvitationRequest build() {
            CancelSenderInvitationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder senderInvitationId(String senderInvitationId) {
            this.senderInvitationId = senderInvitationId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CancelSenderInvitationRequest buildWithoutInvocationCallback() {
            return new CancelSenderInvitationRequest(this.senderInvitationId, this.ifMatch, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "CancelSenderInvitationRequest.Builder(senderInvitationId=" + this.senderInvitationId + ", ifMatch=" + this.ifMatch + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

