/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDomainGovernanceRequest
extends BmcRequest<Void> {
    private String domainGovernanceId;
    private String opcRequestId;

    @ConstructorProperties(value={"domainGovernanceId", "opcRequestId"})
    GetDomainGovernanceRequest(String domainGovernanceId, String opcRequestId) {
        this.domainGovernanceId = domainGovernanceId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDomainGovernanceId() {
        return this.domainGovernanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDomainGovernanceRequest, Void> {
        private String domainGovernanceId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDomainGovernanceRequest o) {
            this.domainGovernanceId(o.getDomainGovernanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDomainGovernanceRequest build() {
            GetDomainGovernanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder domainGovernanceId(String domainGovernanceId) {
            this.domainGovernanceId = domainGovernanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDomainGovernanceRequest buildWithoutInvocationCallback() {
            return new GetDomainGovernanceRequest(this.domainGovernanceId, this.opcRequestId);
        }

        public String toString() {
            return "GetDomainGovernanceRequest.Builder(domainGovernanceId=" + this.domainGovernanceId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

