/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetSenderInvitationRequest
extends BmcRequest<Void> {
    private String senderInvitationId;
    private String opcRequestId;

    @ConstructorProperties(value={"senderInvitationId", "opcRequestId"})
    GetSenderInvitationRequest(String senderInvitationId, String opcRequestId) {
        this.senderInvitationId = senderInvitationId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSenderInvitationId() {
        return this.senderInvitationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSenderInvitationRequest, Void> {
        private String senderInvitationId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSenderInvitationRequest o) {
            this.senderInvitationId(o.getSenderInvitationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSenderInvitationRequest build() {
            GetSenderInvitationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder senderInvitationId(String senderInvitationId) {
            this.senderInvitationId = senderInvitationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetSenderInvitationRequest buildWithoutInvocationCallback() {
            return new GetSenderInvitationRequest(this.senderInvitationId, this.opcRequestId);
        }

        public String toString() {
            return "GetSenderInvitationRequest.Builder(senderInvitationId=" + this.senderInvitationId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

