/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.tenantmanagercontrolplane.model.LifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.model.SortOrder;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDomainGovernancesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String domainId;
    private String domainGovernanceId;
    private LifecycleState lifecycleState;
    private String name;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"compartmentId", "domainId", "domainGovernanceId", "lifecycleState", "name", "opcRequestId", "page", "limit", "sortBy", "sortOrder"})
    ListDomainGovernancesRequest(String compartmentId, String domainId, String domainGovernanceId, LifecycleState lifecycleState, String name, String opcRequestId, String page, Integer limit, SortBy sortBy, SortOrder sortOrder) {
        this.compartmentId = compartmentId;
        this.domainId = domainId;
        this.domainGovernanceId = domainGovernanceId;
        this.lifecycleState = lifecycleState;
        this.name = name;
        this.opcRequestId = opcRequestId;
        this.page = page;
        this.limit = limit;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getDomainGovernanceId() {
        return this.domainGovernanceId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getName() {
        return this.name;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDomainGovernancesRequest, Void> {
        private String compartmentId;
        private String domainId;
        private String domainGovernanceId;
        private LifecycleState lifecycleState;
        private String name;
        private String opcRequestId;
        private String page;
        private Integer limit;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDomainGovernancesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.domainId(o.getDomainId());
            this.domainGovernanceId(o.getDomainGovernanceId());
            this.lifecycleState(o.getLifecycleState());
            this.name(o.getName());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDomainGovernancesRequest build() {
            ListDomainGovernancesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder domainGovernanceId(String domainGovernanceId) {
            this.domainGovernanceId = domainGovernanceId;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListDomainGovernancesRequest buildWithoutInvocationCallback() {
            return new ListDomainGovernancesRequest(this.compartmentId, this.domainId, this.domainGovernanceId, this.lifecycleState, this.name, this.opcRequestId, this.page, this.limit, this.sortBy, this.sortOrder);
        }

        public String toString() {
            return "ListDomainGovernancesRequest.Builder(compartmentId=" + this.compartmentId + ", domainId=" + this.domainId + ", domainGovernanceId=" + this.domainGovernanceId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", name=" + this.name + ", opcRequestId=" + this.opcRequestId + ", page=" + this.page + ", limit=" + this.limit + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

