/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.tenantmanagercontrolplane.model.LifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.model.SortOrder;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListLinksRequest
extends BmcRequest<Void> {
    private String parentTenancyId;
    private String childTenancyId;
    private LifecycleState lifecycleState;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"parentTenancyId", "childTenancyId", "lifecycleState", "opcRequestId", "page", "limit", "sortOrder"})
    ListLinksRequest(String parentTenancyId, String childTenancyId, LifecycleState lifecycleState, String opcRequestId, String page, Integer limit, SortOrder sortOrder) {
        this.parentTenancyId = parentTenancyId;
        this.childTenancyId = childTenancyId;
        this.lifecycleState = lifecycleState;
        this.opcRequestId = opcRequestId;
        this.page = page;
        this.limit = limit;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getParentTenancyId() {
        return this.parentTenancyId;
    }

    public String getChildTenancyId() {
        return this.childTenancyId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder
    implements BmcRequest.Builder<ListLinksRequest, Void> {
        private String parentTenancyId;
        private String childTenancyId;
        private LifecycleState lifecycleState;
        private String opcRequestId;
        private String page;
        private Integer limit;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListLinksRequest o) {
            this.parentTenancyId(o.getParentTenancyId());
            this.childTenancyId(o.getChildTenancyId());
            this.lifecycleState(o.getLifecycleState());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListLinksRequest build() {
            ListLinksRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder parentTenancyId(String parentTenancyId) {
            this.parentTenancyId = parentTenancyId;
            return this;
        }

        public Builder childTenancyId(String childTenancyId) {
            this.childTenancyId = childTenancyId;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListLinksRequest buildWithoutInvocationCallback() {
            return new ListLinksRequest(this.parentTenancyId, this.childTenancyId, this.lifecycleState, this.opcRequestId, this.page, this.limit, this.sortOrder);
        }

        public String toString() {
            return "ListLinksRequest.Builder(parentTenancyId=" + this.parentTenancyId + ", childTenancyId=" + this.childTenancyId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", opcRequestId=" + this.opcRequestId + ", page=" + this.page + ", limit=" + this.limit + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }
}

