/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.usageapi.Usageapi;
import com.oracle.bmc.usageapi.UsageapiPaginators;
import com.oracle.bmc.usageapi.internal.http.CreateQueryConverter;
import com.oracle.bmc.usageapi.internal.http.DeleteQueryConverter;
import com.oracle.bmc.usageapi.internal.http.GetQueryConverter;
import com.oracle.bmc.usageapi.internal.http.ListQueriesConverter;
import com.oracle.bmc.usageapi.internal.http.RequestSummarizedConfigurationsConverter;
import com.oracle.bmc.usageapi.internal.http.RequestSummarizedUsagesConverter;
import com.oracle.bmc.usageapi.internal.http.UpdateQueryConverter;
import com.oracle.bmc.usageapi.requests.CreateQueryRequest;
import com.oracle.bmc.usageapi.requests.DeleteQueryRequest;
import com.oracle.bmc.usageapi.requests.GetQueryRequest;
import com.oracle.bmc.usageapi.requests.ListQueriesRequest;
import com.oracle.bmc.usageapi.requests.RequestSummarizedConfigurationsRequest;
import com.oracle.bmc.usageapi.requests.RequestSummarizedUsagesRequest;
import com.oracle.bmc.usageapi.requests.UpdateQueryRequest;
import com.oracle.bmc.usageapi.responses.CreateQueryResponse;
import com.oracle.bmc.usageapi.responses.DeleteQueryResponse;
import com.oracle.bmc.usageapi.responses.GetQueryResponse;
import com.oracle.bmc.usageapi.responses.ListQueriesResponse;
import com.oracle.bmc.usageapi.responses.RequestSummarizedConfigurationsResponse;
import com.oracle.bmc.usageapi.responses.RequestSummarizedUsagesResponse;
import com.oracle.bmc.usageapi.responses.UpdateQueryResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageapiClient
implements Usageapi {
    private static final Logger LOG = LoggerFactory.getLogger(UsageapiClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("USAGEAPI").serviceEndpointPrefix("").serviceEndpointTemplate("https://usageapi.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final UsageapiPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public UsageapiClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public UsageapiClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public UsageapiClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public UsageapiClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public UsageapiClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public UsageapiClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public UsageapiClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    protected UsageapiClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        this.paginators = new UsageapiPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CreateQueryResponse createQuery(CreateQueryRequest request) {
        LOG.trace("Called createQuery");
        CreateQueryRequest interceptedRequest = CreateQueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateQueryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateQueryResponse> transformer = CreateQueryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateQueryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateQueryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateQueryDetails(), (BmcRequest)retriedRequest);
                return (CreateQueryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteQueryResponse deleteQuery(DeleteQueryRequest request) {
        LOG.trace("Called deleteQuery");
        DeleteQueryRequest interceptedRequest = DeleteQueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteQueryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteQueryResponse> transformer = DeleteQueryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteQueryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteQueryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteQueryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetQueryResponse getQuery(GetQueryRequest request) {
        LOG.trace("Called getQuery");
        GetQueryRequest interceptedRequest = GetQueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetQueryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetQueryResponse> transformer = GetQueryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetQueryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetQueryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetQueryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListQueriesResponse listQueries(ListQueriesRequest request) {
        LOG.trace("Called listQueries");
        ListQueriesRequest interceptedRequest = ListQueriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListQueriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListQueriesResponse> transformer = ListQueriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListQueriesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListQueriesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListQueriesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSummarizedConfigurationsResponse requestSummarizedConfigurations(RequestSummarizedConfigurationsRequest request) {
        LOG.trace("Called requestSummarizedConfigurations");
        RequestSummarizedConfigurationsRequest interceptedRequest = RequestSummarizedConfigurationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedConfigurationsResponse> transformer = RequestSummarizedConfigurationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSummarizedConfigurationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSummarizedConfigurationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (RequestSummarizedConfigurationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RequestSummarizedUsagesResponse requestSummarizedUsages(RequestSummarizedUsagesRequest request) {
        LOG.trace("Called requestSummarizedUsages");
        RequestSummarizedUsagesRequest interceptedRequest = RequestSummarizedUsagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedUsagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedUsagesResponse> transformer = RequestSummarizedUsagesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (RequestSummarizedUsagesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RequestSummarizedUsagesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRequestSummarizedUsagesDetails(), (BmcRequest)retriedRequest);
                return (RequestSummarizedUsagesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateQueryResponse updateQuery(UpdateQueryRequest request) {
        LOG.trace("Called updateQuery");
        UpdateQueryRequest interceptedRequest = UpdateQueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateQueryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateQueryResponse> transformer = UpdateQueryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateQueryResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateQueryResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateQueryDetails(), (BmcRequest)retriedRequest);
                return (UpdateQueryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UsageapiPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, UsageapiClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public UsageapiClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new UsageapiClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

