/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.usageapi.model.ConfigurationAggregation;
import com.oracle.bmc.usageapi.requests.RequestSummarizedConfigurationsRequest;
import com.oracle.bmc.usageapi.responses.RequestSummarizedConfigurationsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSummarizedConfigurationsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSummarizedConfigurationsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RequestSummarizedConfigurationsRequest interceptRequest(RequestSummarizedConfigurationsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RequestSummarizedConfigurationsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getTenantId(), (String)"tenantId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200107").path("configuration");
        target = target.queryParam("tenantId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTenantId())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, RequestSummarizedConfigurationsResponse> fromResponse() {
        Function<Response, RequestSummarizedConfigurationsResponse> transformer = new Function<Response, RequestSummarizedConfigurationsResponse>(){

            public RequestSummarizedConfigurationsResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.usageapi.responses.RequestSummarizedConfigurationsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ConfigurationAggregation.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                RequestSummarizedConfigurationsResponse.Builder builder = RequestSummarizedConfigurationsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.configurationAggregation((ConfigurationAggregation)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                RequestSummarizedConfigurationsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

