/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.usageapi.model.UpdateQueryDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateQueryRequest
extends BmcRequest<UpdateQueryDetails> {
    private UpdateQueryDetails updateQueryDetails;
    private String queryId;
    private String opcRequestId;
    private String ifMatch;

    @InternalSdk
    public UpdateQueryDetails getBody$() {
        return this.updateQueryDetails;
    }

    @ConstructorProperties(value={"updateQueryDetails", "queryId", "opcRequestId", "ifMatch"})
    UpdateQueryRequest(UpdateQueryDetails updateQueryDetails, String queryId, String opcRequestId, String ifMatch) {
        this.updateQueryDetails = updateQueryDetails;
        this.queryId = queryId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateQueryDetails getUpdateQueryDetails() {
        return this.updateQueryDetails;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateQueryRequest, UpdateQueryDetails> {
        private UpdateQueryDetails updateQueryDetails;
        private String queryId;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateQueryRequest o) {
            this.updateQueryDetails(o.getUpdateQueryDetails());
            this.queryId(o.getQueryId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateQueryRequest build() {
            UpdateQueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateQueryDetails body) {
            this.updateQueryDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder updateQueryDetails(UpdateQueryDetails updateQueryDetails) {
            this.updateQueryDetails = updateQueryDetails;
            return this;
        }

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateQueryRequest buildWithoutInvocationCallback() {
            return new UpdateQueryRequest(this.updateQueryDetails, this.queryId, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "UpdateQueryRequest.Builder(updateQueryDetails=" + this.updateQueryDetails + ", queryId=" + this.queryId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

