/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecretVersion {
    @JsonProperty(value="contentType")
    private final ContentType contentType;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="secretId")
    private final String secretId;
    @JsonProperty(value="stages")
    private final List<Stages> stages;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeOfDeletion")
    private final Date timeOfDeletion;
    @JsonProperty(value="timeOfCurrentVersionExpiry")
    private final Date timeOfCurrentVersionExpiry;
    @JsonProperty(value="versionNumber")
    private final Long versionNumber;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().contentType(this.contentType).name(this.name).secretId(this.secretId).stages(this.stages).timeCreated(this.timeCreated).timeOfDeletion(this.timeOfDeletion).timeOfCurrentVersionExpiry(this.timeOfCurrentVersionExpiry).versionNumber(this.versionNumber);
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public List<Stages> getStages() {
        return this.stages;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeOfDeletion() {
        return this.timeOfDeletion;
    }

    public Date getTimeOfCurrentVersionExpiry() {
        return this.timeOfCurrentVersionExpiry;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretVersion)) {
            return false;
        }
        SecretVersion other = (SecretVersion)o;
        Long this$versionNumber = this.getVersionNumber();
        Long other$versionNumber = other.getVersionNumber();
        if (this$versionNumber == null ? other$versionNumber != null : !((Object)this$versionNumber).equals(other$versionNumber)) {
            return false;
        }
        ContentType this$contentType = this.getContentType();
        ContentType other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !((Object)((Object)this$contentType)).equals((Object)other$contentType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$secretId = this.getSecretId();
        String other$secretId = other.getSecretId();
        if (this$secretId == null ? other$secretId != null : !this$secretId.equals(other$secretId)) {
            return false;
        }
        List<Stages> this$stages = this.getStages();
        List<Stages> other$stages = other.getStages();
        if (this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        Date this$timeOfDeletion = this.getTimeOfDeletion();
        Date other$timeOfDeletion = other.getTimeOfDeletion();
        if (this$timeOfDeletion == null ? other$timeOfDeletion != null : !((Object)this$timeOfDeletion).equals(other$timeOfDeletion)) {
            return false;
        }
        Date this$timeOfCurrentVersionExpiry = this.getTimeOfCurrentVersionExpiry();
        Date other$timeOfCurrentVersionExpiry = other.getTimeOfCurrentVersionExpiry();
        if (this$timeOfCurrentVersionExpiry == null ? other$timeOfCurrentVersionExpiry != null : !((Object)this$timeOfCurrentVersionExpiry).equals(other$timeOfCurrentVersionExpiry)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $versionNumber = this.getVersionNumber();
        result = result * 59 + ($versionNumber == null ? 43 : ((Object)$versionNumber).hashCode());
        ContentType $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : ((Object)((Object)$contentType)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $secretId = this.getSecretId();
        result = result * 59 + ($secretId == null ? 43 : $secretId.hashCode());
        List<Stages> $stages = this.getStages();
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        Date $timeOfDeletion = this.getTimeOfDeletion();
        result = result * 59 + ($timeOfDeletion == null ? 43 : ((Object)$timeOfDeletion).hashCode());
        Date $timeOfCurrentVersionExpiry = this.getTimeOfCurrentVersionExpiry();
        result = result * 59 + ($timeOfCurrentVersionExpiry == null ? 43 : ((Object)$timeOfCurrentVersionExpiry).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "SecretVersion(contentType=" + (Object)((Object)this.getContentType()) + ", name=" + this.getName() + ", secretId=" + this.getSecretId() + ", stages=" + this.getStages() + ", timeCreated=" + this.getTimeCreated() + ", timeOfDeletion=" + this.getTimeOfDeletion() + ", timeOfCurrentVersionExpiry=" + this.getTimeOfCurrentVersionExpiry() + ", versionNumber=" + this.getVersionNumber() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"contentType", "name", "secretId", "stages", "timeCreated", "timeOfDeletion", "timeOfCurrentVersionExpiry", "versionNumber"})
    @Deprecated
    public SecretVersion(ContentType contentType, String name, String secretId, List<Stages> stages, Date timeCreated, Date timeOfDeletion, Date timeOfCurrentVersionExpiry, Long versionNumber) {
        this.contentType = contentType;
        this.name = name;
        this.secretId = secretId;
        this.stages = stages;
        this.timeCreated = timeCreated;
        this.timeOfDeletion = timeOfDeletion;
        this.timeOfCurrentVersionExpiry = timeOfCurrentVersionExpiry;
        this.versionNumber = versionNumber;
    }

    public static enum Stages {
        Current("CURRENT"),
        Pending("PENDING"),
        Latest("LATEST"),
        Previous("PREVIOUS"),
        Deprecated("DEPRECATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Stages> map;

        private Stages(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Stages create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Stages', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Stages.class);
            map = new HashMap<String, Stages>();
            for (Stages v : Stages.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ContentType {
        Base64("BASE64"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ContentType> map;

        private ContentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ContentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ContentType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ContentType.class);
            map = new HashMap<String, ContentType>();
            for (ContentType v : ContentType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="contentType")
        private ContentType contentType;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="secretId")
        private String secretId;
        @JsonProperty(value="stages")
        private List<Stages> stages;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeOfDeletion")
        private Date timeOfDeletion;
        @JsonProperty(value="timeOfCurrentVersionExpiry")
        private Date timeOfCurrentVersionExpiry;
        @JsonProperty(value="versionNumber")
        private Long versionNumber;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder contentType(ContentType contentType) {
            this.contentType = contentType;
            this.__explicitlySet__.add("contentType");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            this.__explicitlySet__.add("secretId");
            return this;
        }

        public Builder stages(List<Stages> stages) {
            this.stages = stages;
            this.__explicitlySet__.add("stages");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeOfDeletion(Date timeOfDeletion) {
            this.timeOfDeletion = timeOfDeletion;
            this.__explicitlySet__.add("timeOfDeletion");
            return this;
        }

        public Builder timeOfCurrentVersionExpiry(Date timeOfCurrentVersionExpiry) {
            this.timeOfCurrentVersionExpiry = timeOfCurrentVersionExpiry;
            this.__explicitlySet__.add("timeOfCurrentVersionExpiry");
            return this;
        }

        public Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            this.__explicitlySet__.add("versionNumber");
            return this;
        }

        public SecretVersion build() {
            SecretVersion __instance__ = new SecretVersion(this.contentType, this.name, this.secretId, this.stages, this.timeCreated, this.timeOfDeletion, this.timeOfCurrentVersionExpiry, this.versionNumber);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(SecretVersion o) {
            Builder copiedBuilder = this.contentType(o.getContentType()).name(o.getName()).secretId(o.getSecretId()).stages(o.getStages()).timeCreated(o.getTimeCreated()).timeOfDeletion(o.getTimeOfDeletion()).timeOfCurrentVersionExpiry(o.getTimeOfCurrentVersionExpiry()).versionNumber(o.getVersionNumber());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "SecretVersion.Builder(contentType=" + (Object)((Object)this.contentType) + ", name=" + this.name + ", secretId=" + this.secretId + ", stages=" + this.stages + ", timeCreated=" + this.timeCreated + ", timeOfDeletion=" + this.timeOfDeletion + ", timeOfCurrentVersionExpiry=" + this.timeOfCurrentVersionExpiry + ", versionNumber=" + this.versionNumber + ")";
        }
    }
}

