/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import com.oracle.bmc.vault.model.ScheduleSecretDeletionDetails;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ScheduleSecretDeletionRequest
extends BmcRequest<ScheduleSecretDeletionDetails> {
    private String secretId;
    private ScheduleSecretDeletionDetails scheduleSecretDeletionDetails;
    private String ifMatch;
    private String opcRequestId;

    @InternalSdk
    public ScheduleSecretDeletionDetails getBody$() {
        return this.scheduleSecretDeletionDetails;
    }

    @ConstructorProperties(value={"secretId", "scheduleSecretDeletionDetails", "ifMatch", "opcRequestId"})
    ScheduleSecretDeletionRequest(String secretId, ScheduleSecretDeletionDetails scheduleSecretDeletionDetails, String ifMatch, String opcRequestId) {
        this.secretId = secretId;
        this.scheduleSecretDeletionDetails = scheduleSecretDeletionDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSecretId() {
        return this.secretId;
    }

    public ScheduleSecretDeletionDetails getScheduleSecretDeletionDetails() {
        return this.scheduleSecretDeletionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ScheduleSecretDeletionRequest, ScheduleSecretDeletionDetails> {
        private String secretId;
        private ScheduleSecretDeletionDetails scheduleSecretDeletionDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ScheduleSecretDeletionRequest o) {
            this.secretId(o.getSecretId());
            this.scheduleSecretDeletionDetails(o.getScheduleSecretDeletionDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ScheduleSecretDeletionRequest build() {
            ScheduleSecretDeletionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ScheduleSecretDeletionDetails body) {
            this.scheduleSecretDeletionDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public Builder scheduleSecretDeletionDetails(ScheduleSecretDeletionDetails scheduleSecretDeletionDetails) {
            this.scheduleSecretDeletionDetails = scheduleSecretDeletionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ScheduleSecretDeletionRequest buildWithoutInvocationCallback() {
            return new ScheduleSecretDeletionRequest(this.secretId, this.scheduleSecretDeletionDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "ScheduleSecretDeletionRequest.Builder(secretId=" + this.secretId + ", scheduleSecretDeletionDetails=" + this.scheduleSecretDeletionDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

