/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.waas.Waas;
import com.oracle.bmc.waas.model.LifecycleStates;
import com.oracle.bmc.waas.requests.GetAddressListRequest;
import com.oracle.bmc.waas.requests.GetCertificateRequest;
import com.oracle.bmc.waas.requests.GetCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.GetWaasPolicyRequest;
import com.oracle.bmc.waas.requests.GetWorkRequestRequest;
import com.oracle.bmc.waas.responses.GetAddressListResponse;
import com.oracle.bmc.waas.responses.GetCertificateResponse;
import com.oracle.bmc.waas.responses.GetCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.GetWaasPolicyResponse;
import com.oracle.bmc.waas.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class WaasWaiters {
    private final ExecutorService executorService;
    private final Waas client;

    public Waiter<GetAddressListRequest, GetAddressListResponse> forAddressList(GetAddressListRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAddressList(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAddressListRequest, GetAddressListResponse> forAddressList(GetAddressListRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAddressList(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAddressListRequest, GetAddressListResponse> forAddressList(GetAddressListRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAddressList(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAddressListRequest, GetAddressListResponse> forAddressList(BmcGenericWaiter waiter, GetAddressListRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetAddressListRequest, GetAddressListResponse>(){

            public GetAddressListResponse apply(GetAddressListRequest request) {
                return WaasWaiters.this.client.getAddressList(request);
            }
        }, (Predicate)new Predicate<GetAddressListResponse>(){

            public boolean apply(GetAddressListResponse response) {
                return targetStatesSet.contains((Object)response.getAddressList().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCertificate(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCertificate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(GetCertificateRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCertificate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCertificateRequest, GetCertificateResponse> forCertificate(BmcGenericWaiter waiter, GetCertificateRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetCertificateRequest, GetCertificateResponse>(){

            public GetCertificateResponse apply(GetCertificateRequest request) {
                return WaasWaiters.this.client.getCertificate(request);
            }
        }, (Predicate)new Predicate<GetCertificateResponse>(){

            public boolean apply(GetCertificateResponse response) {
                return targetStatesSet.contains((Object)response.getCertificate().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse> forCustomProtectionRule(GetCustomProtectionRuleRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCustomProtectionRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse> forCustomProtectionRule(GetCustomProtectionRuleRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCustomProtectionRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse> forCustomProtectionRule(GetCustomProtectionRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCustomProtectionRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse> forCustomProtectionRule(BmcGenericWaiter waiter, GetCustomProtectionRuleRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse>(){

            public GetCustomProtectionRuleResponse apply(GetCustomProtectionRuleRequest request) {
                return WaasWaiters.this.client.getCustomProtectionRule(request);
            }
        }, (Predicate)new Predicate<GetCustomProtectionRuleResponse>(){

            public boolean apply(GetCustomProtectionRuleResponse response) {
                return targetStatesSet.contains((Object)response.getCustomProtectionRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetWaasPolicyRequest, GetWaasPolicyResponse> forWaasPolicy(GetWaasPolicyRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forWaasPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetWaasPolicyRequest, GetWaasPolicyResponse> forWaasPolicy(GetWaasPolicyRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forWaasPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetWaasPolicyRequest, GetWaasPolicyResponse> forWaasPolicy(GetWaasPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forWaasPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetWaasPolicyRequest, GetWaasPolicyResponse> forWaasPolicy(BmcGenericWaiter waiter, GetWaasPolicyRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWaasPolicyRequest, GetWaasPolicyResponse>(){

            public GetWaasPolicyResponse apply(GetWaasPolicyRequest request) {
                return WaasWaiters.this.client.getWaasPolicy(request);
            }
        }, (Predicate)new Predicate<GetWaasPolicyResponse>(){

            public boolean apply(GetWaasPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getWaasPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return WaasWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public WaasWaiters(ExecutorService executorService, Waas client) {
        this.executorService = executorService;
        this.client = client;
    }
}

