/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import com.oracle.bmc.waas.model.LifecycleStates;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListCustomProtectionRulesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private List<String> id;
    private List<String> displayName;
    private List<LifecycleStates> lifecycleState;
    private Date timeCreatedGreaterThanOrEqualTo;
    private Date timeCreatedLessThan;

    @ConstructorProperties(value={"compartmentId", "opcRequestId", "limit", "page", "sortBy", "sortOrder", "id", "displayName", "lifecycleState", "timeCreatedGreaterThanOrEqualTo", "timeCreatedLessThan"})
    ListCustomProtectionRulesRequest(String compartmentId, String opcRequestId, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, List<String> id, List<String> displayName, List<LifecycleStates> lifecycleState, Date timeCreatedGreaterThanOrEqualTo, Date timeCreatedLessThan) {
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.id = id;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
        this.timeCreatedLessThan = timeCreatedLessThan;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public List<String> getId() {
        return this.id;
    }

    public List<String> getDisplayName() {
        return this.displayName;
    }

    public List<LifecycleStates> getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreatedGreaterThanOrEqualTo() {
        return this.timeCreatedGreaterThanOrEqualTo;
    }

    public Date getTimeCreatedLessThan() {
        return this.timeCreatedLessThan;
    }

    public static class Builder
    implements BmcRequest.Builder<ListCustomProtectionRulesRequest, Void> {
        private String compartmentId;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private List<String> id;
        private List<String> displayName;
        private List<LifecycleStates> lifecycleState;
        private Date timeCreatedGreaterThanOrEqualTo;
        private Date timeCreatedLessThan;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListCustomProtectionRulesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.id(o.getId());
            this.displayName(o.getDisplayName());
            this.lifecycleState(o.getLifecycleState());
            this.timeCreatedGreaterThanOrEqualTo(o.getTimeCreatedGreaterThanOrEqualTo());
            this.timeCreatedLessThan(o.getTimeCreatedLessThan());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListCustomProtectionRulesRequest build() {
            ListCustomProtectionRulesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder id(List<String> id) {
            this.id = id;
            return this;
        }

        public Builder displayName(List<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder lifecycleState(List<LifecycleStates> lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder timeCreatedGreaterThanOrEqualTo(Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCreatedLessThan(Date timeCreatedLessThan) {
            this.timeCreatedLessThan = timeCreatedLessThan;
            return this;
        }

        public ListCustomProtectionRulesRequest buildWithoutInvocationCallback() {
            return new ListCustomProtectionRulesRequest(this.compartmentId, this.opcRequestId, this.limit, this.page, this.sortBy, this.sortOrder, this.id, this.displayName, this.lifecycleState, this.timeCreatedGreaterThanOrEqualTo, this.timeCreatedLessThan);
        }

        public String toString() {
            return "ListCustomProtectionRulesRequest.Builder(compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", id=" + this.id + ", displayName=" + this.displayName + ", lifecycleState=" + this.lifecycleState + ", timeCreatedGreaterThanOrEqualTo=" + this.timeCreatedGreaterThanOrEqualTo + ", timeCreatedLessThan=" + this.timeCreatedLessThan + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Id("id"),
        CompartmentId("compartmentId"),
        DisplayName("displayName"),
        ModSecurityRuleId("modSecurityRuleId"),
        TimeCreated("timeCreated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

