/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListRecommendationsRequest
extends BmcRequest<Void> {
    private String waasPolicyId;
    private String opcRequestId;
    private RecommendedAction recommendedAction;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"waasPolicyId", "opcRequestId", "recommendedAction", "limit", "page"})
    ListRecommendationsRequest(String waasPolicyId, String opcRequestId, RecommendedAction recommendedAction, Integer limit, String page) {
        this.waasPolicyId = waasPolicyId;
        this.opcRequestId = opcRequestId;
        this.recommendedAction = recommendedAction;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public RecommendedAction getRecommendedAction() {
        return this.recommendedAction;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRecommendationsRequest, Void> {
        private String waasPolicyId;
        private String opcRequestId;
        private RecommendedAction recommendedAction;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRecommendationsRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.recommendedAction(o.getRecommendedAction());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRecommendationsRequest build() {
            ListRecommendationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder recommendedAction(RecommendedAction recommendedAction) {
            this.recommendedAction = recommendedAction;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListRecommendationsRequest buildWithoutInvocationCallback() {
            return new ListRecommendationsRequest(this.waasPolicyId, this.opcRequestId, this.recommendedAction, this.limit, this.page);
        }

        public String toString() {
            return "ListRecommendationsRequest.Builder(waasPolicyId=" + this.waasPolicyId + ", opcRequestId=" + this.opcRequestId + ", recommendedAction=" + (Object)((Object)this.recommendedAction) + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }

    public static enum RecommendedAction {
        Detect("DETECT"),
        Block("BLOCK");

        private final String value;
        private static Map<String, RecommendedAction> map;

        private RecommendedAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RecommendedAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid RecommendedAction: " + key);
        }

        static {
            map = new HashMap<String, RecommendedAction>();
            for (RecommendedAction v : RecommendedAction.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

