/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.incident;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.ODLLogRecord;

public final class IncidentLogUtil {
    public static String log(Logger logger, Level level, String msg, Object[] args, Throwable thrown) {
        if (!logger.isLoggable(level)) {
            return null;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        rec.setLoggerName(logger.getName());
        rec.setParameters(args);
        rec.setResourceBundle(logger.getResourceBundle());
        rec.setResourceBundleName(logger.getResourceBundleName());
        rec.setThrown(thrown);
        logger.log((LogRecord)rec);
        return rec.getErrorInstanceId();
    }

    public static String log(Logger logger, Level level, String msg, Object arg, Throwable thrown) {
        return IncidentLogUtil.log(logger, level, msg, new Object[]{arg}, thrown);
    }

    public static String logp(Logger logger, Level level, String srcClass, String srcMethod, String msg, Object[] args, Throwable thrown) {
        if (!logger.isLoggable(level)) {
            return null;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        rec.setLoggerName(logger.getName());
        rec.setParameters(args);
        rec.setResourceBundle(logger.getResourceBundle());
        rec.setResourceBundleName(logger.getResourceBundleName());
        rec.setSourceClassName(srcClass);
        rec.setSourceMethodName(srcMethod);
        rec.setThrown(thrown);
        logger.log((LogRecord)rec);
        return rec.getErrorInstanceId();
    }

    public static String logrb(Logger logger, Level level, String srcClass, String srcMethod, String bundleName, String msg, Object[] args, Throwable thrown) {
        if (!logger.isLoggable(level)) {
            return null;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        rec.setLoggerName(logger.getName());
        rec.setParameters(args);
        rec.setResourceBundle(IncidentLogUtil.getResourceBundle(bundleName));
        rec.setResourceBundleName(bundleName);
        rec.setSourceClassName(srcClass);
        rec.setSourceMethodName(srcMethod);
        rec.setThrown(thrown);
        logger.log((LogRecord)rec);
        return rec.getErrorInstanceId();
    }

    private static ResourceBundle getResourceBundle(String resourceBundleName) {
        if (resourceBundleName == null) {
            return null;
        }
        Locale loc = Locale.getDefault();
        Object rb = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                return ResourceBundle.getBundle(resourceBundleName, loc, cl);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return ResourceBundle.getBundle(resourceBundleName, loc, ClassLoader.getSystemClassLoader());
        }
        catch (Exception e) {
            return null;
        }
    }
}

