/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.spi.websphere;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.impl.common.SecurityContext;
import oracle.security.jps.internal.api.runtime.SubjectSecurity;
import oracle.security.jps.util.SubjectUtil;

class SecurityContextImpl
implements SecurityContext {
    private SubjectSecurity m_jpsSecurity = SubjectSecurity.getInstance();
    private Logger m_logger = LoggerFactory.getFrameworkLogger();

    SecurityContextImpl() throws Exception {
    }

    @Override
    public String getUserName() {
        try {
            return SubjectUtil.getUserName((Subject)this.getCurrentSubject());
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public Subject getCurrentSubject() {
        Subject subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return Subject.getSubject(AccessController.getContext());
            }
        });
        if (subject == null) {
            subject = SubjectUtil.getCurrentSubject();
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.finer("unable to get Subject using JAAS API; using JPS security got: " + subject);
            }
        } else if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.finer("using the JAAS API got Subject: " + subject);
        }
        return subject;
    }

    @Override
    public <T> T executeAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return (T)this.m_jpsSecurity.executeAs(subject, action);
    }
}

