/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import oracle.as.config.notification.DocumentChangeListener;
import oracle.as.config.notification.DocumentChangedEvent;
import oracle.as.jmx.framework.annotations.Inject;
import oracle.as.jmx.framework.mapping.MBeanProxy;
import oracle.as.jmx.framework.services.EventBroadcaster;
import oracle.as.jmx.framework.services.JMXSupport;
import oracle.as.management.exception.ASException;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.dms.config.Config;
import oracle.dms.console.DMSConsole;
import oracle.dms.event.EventResourceBundle;
import oracle.dms.event.config.Destination;
import oracle.dms.event.config.EventConfig;
import oracle.dms.event.config.EventConfigException;
import oracle.dms.event.config.EventConfigMBean;
import oracle.dms.event.config.Filter;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupportFactory;
import oracle.dms.util.Time;

public class JMXEventConfig
implements EventConfigMBean,
DocumentChangeListener,
MBeanRegistration {
    private String m_serverName = null;
    private JMXSupport m_jmxSupport = null;
    private volatile boolean m_isConfigUpdated;
    private static volatile long sConfigTimeStamp = 0L;
    private static String LOGGER_NAME = "oracle.dms.event";
    private static volatile int s_count = 0;
    private static final String CLASS_NAME = JMXEventConfig.class.getName();
    private static final String EVENT_CONFIG_MBEAN_ON = "oracle.dms.event.config:type=JMXEventConfig,name=DMSEventConfigMBean";
    private static final String WILDCARD = ",*";
    private ODLLogger m_logger = ODLLogger.getODLLogger((String)LOGGER_NAME, (String)EventResourceBundle.class.getName());
    private EventConfig m_EventConfig;
    private EventBroadcaster m_eventBroadcaster = null;
    private String m_accessLevel = null;
    private MBeanServer m_domainMbeanServer;
    private String m_serverKey;
    private String m_serverKeyValue;
    private Platform m_platform;

    public JMXEventConfig() throws NotCompliantMBeanException {
        String METHOD_NAME = "JMXEventConfig";
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, CLASS_NAME, "JMXEventConfig", "Server: " + this.getServerName() + " " + " id: " + this + " R/W: " + this.accessLevel() + " JMXEventConfig() " + " m_EventConfig = " + this.m_EventConfig);
        }
    }

    public JMXEventConfig(EventConfig eventConfig) throws NotCompliantMBeanException {
        String currentPlatform;
        String METHOD_NAME = "JMXEventConfig";
        if (eventConfig == null) {
            throw new IllegalArgumentException();
        }
        this.m_EventConfig = eventConfig;
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, CLASS_NAME, "JMXEventConfig", "Server: " + this.getServerName() + " " + " id: " + this + " R/W: " + this.accessLevel() + " JMXEventConfig(EventConfig) " + " m_EventConfig = " + this.m_EventConfig);
        }
        if ((currentPlatform = PlatformSupportFactory.getPlatformSupport().getPlatform().toString()).compareTo(Platform.WebLogic.toString()) == 0) {
            this.m_platform = Platform.WebLogic;
            this.m_serverKey = "Location";
            this.m_serverKeyValue = ",Location=";
        } else if (currentPlatform.compareTo(Platform.WebSphere.toString()) == 0) {
            this.m_platform = Platform.WebSphere;
            this.m_serverKey = "process";
            this.m_serverKeyValue = ",process=";
        }
    }

    public synchronized void update(EventConfig eventConfig) throws Exception {
        if (eventConfig == null) {
            throw new IllegalArgumentException();
        }
        this.m_EventConfig = eventConfig;
        DMSConsole.getConsole().getConfig().getEventConfig().syncAndActivateConfiguration(this.m_EventConfig);
        this.resetConfigUpdated();
    }

    @Override
    public void activateConfiguration() throws Exception {
        String METHOD_NAME = "activateConfiguration";
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, CLASS_NAME, "activateConfiguration", "Server: " + this.getServerName() + " " + " id: " + this + " R/W: " + this.accessLevel() + " : time (m/s): " + Time.currentTimeMillis() + " count=" + s_count);
            ++s_count;
        }
        try {
            if (this.getJMXSupport().isReadOnly()) {
                this.m_logger.logp(Level.FINER, CLASS_NAME, "activateConfiguration", "Server: " + this.getServerName() + " " + " id: " + this + " R/W: " + this.accessLevel() + "ACTIVATING CONFIG:\n " + JMXEventConfig.getEventConfigAsString(DMSConsole.getConsole().getConfig().getEventConfig()));
                Thread.currentThread();
                Thread.sleep(10000L);
                this.sendEvent();
            } else {
                EventConfigMBean roEventConfigMBean = this.getEventConfigMBean();
                if (roEventConfigMBean != null) {
                    roEventConfigMBean.activateConfiguration();
                }
            }
        }
        catch (Exception e) {
            throw ASException.toException(e, Exception.class);
        }
        this.m_EventConfig.setConfigurationActivated(true);
        this.m_EventConfig.setConfigurationUpdated(true);
    }

    @Override
    public void addFilter(String id, String name, String eventTypesString, Map<String, String> props) throws Exception {
        if (id == null || props.isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments passed to EventConfig.addFilter; id=" + id + "; name=" + name + ";props=" + props + " for server " + this.getServerName());
        }
        try {
            this.m_EventConfig.addFilter(id, name, eventTypesString, props);
            this.m_isConfigUpdated = true;
        }
        catch (Exception e) {
            EventConfigException ec = new EventConfigException("DMS-58067", e);
            ec.addToken(id);
            ec.addToken(this.getServerName());
            throw ASException.toException(ec, Exception.class);
        }
    }

    @Override
    @Deprecated
    public void addFilter(Filter filter) throws Exception {
        String METHOD_NAME = "addFilter";
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, CLASS_NAME, "addFilter", "Server: " + this.getServerName() + " " + " id: " + this + " R/W: " + this.accessLevel() + " m_EventConfig = " + this.m_EventConfig);
            ++s_count;
        }
        if (filter == null) {
            throw new IllegalArgumentException("invalid arguments to addFilter; filter=" + filter + " for server " + this.getServerName());
        }
        this.m_EventConfig.addFilter(filter);
        this.m_isConfigUpdated = true;
    }

    @Override
    public void removeFilter(String filterId) throws Exception {
        if (!DMSUtil.isLegalIdentifier(filterId)) {
            throw new IllegalArgumentException("invalid arguments to removeFilter; filterId=" + filterId + " for server " + this.getServerName() + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        this.m_EventConfig.removeFilter(filterId);
        this.m_isConfigUpdated = true;
    }

    @Override
    public Filter getFilter(String filterId) throws Exception {
        if (this.m_EventConfig == null) {
            return null;
        }
        if (!DMSUtil.isLegalIdentifier(filterId)) {
            throw new IllegalArgumentException("invalid arguments to getFilter; filterId=" + filterId + "for server " + this.getServerName() + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        return this.m_EventConfig.getFilter(filterId);
    }

    @Override
    public String getFilterConditionAsString(String filterId) throws Exception {
        if (this.m_EventConfig == null) {
            return null;
        }
        return this.m_EventConfig.getFilterCondition(filterId);
    }

    @Override
    public Filter[] getFilters() throws Exception {
        if (this.m_EventConfig == null) {
            return null;
        }
        return this.m_EventConfig.getAllFilters().toArray(new Filter[0]);
    }

    @Override
    public void addDestination(Destination destination) throws Exception {
        if (destination != null) {
            boolean failIfFilterProvider = this.m_EventConfig.isDestinationIdUsedInActiveEventRoute(destination.getDestinationId(), true);
            this.m_EventConfig.validateDestination(destination, failIfFilterProvider);
        }
        this.m_EventConfig.addDestination(destination);
        this.m_isConfigUpdated = true;
    }

    @Override
    public void removeDestination(String destinationId) throws Exception {
        if (!DMSUtil.isLegalIdentifier(destinationId)) {
            throw new IllegalArgumentException("invalid arguments to removeDestination; destinationId=" + destinationId + " for server " + this.getServerName() + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        this.m_EventConfig.removeDestination(destinationId);
        this.m_isConfigUpdated = true;
    }

    @Override
    public Destination getDestination(String destinationId) throws Exception {
        if (this.m_EventConfig == null) {
            return null;
        }
        if (!DMSUtil.isLegalIdentifier(destinationId)) {
            throw new IllegalArgumentException("invalid arguments to getDestination; destinationId=" + destinationId + " for server " + this.getServerName() + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        return this.m_EventConfig.getDestination(destinationId);
    }

    @Override
    public Destination[] getDestinations() throws Exception {
        if (this.m_EventConfig == null) {
            return null;
        }
        return this.m_EventConfig.getAllDestinations().toArray(new Destination[0]);
    }

    @Override
    public void addEventRoute(String filterId, String destinationId) throws Exception {
        this.addEventRoute(filterId, destinationId, true);
    }

    @Override
    public void addEventRoute(String filterId, String destinationId, boolean enabled) throws Exception {
        Destination d;
        if (!DMSUtil.isLegalIdentifier(destinationId)) {
            throw new IllegalArgumentException("invalid arguments to addEventRoute; destinationId=" + destinationId + " for server " + this.getServerName() + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        if (enabled && destinationId != null && (d = this.m_EventConfig.getDestination(destinationId)) != null) {
            this.m_EventConfig.validateDestination(d, filterId != null);
        }
        this.m_EventConfig.addEventRoute(filterId, destinationId, enabled);
        this.m_isConfigUpdated = true;
    }

    @Override
    public void removeEventRoute(String filterId, String destinationId) throws Exception {
        this.m_EventConfig.removeEventRoute(filterId, destinationId);
        this.m_isConfigUpdated = true;
    }

    @Override
    @Deprecated
    public List<String> getEventRoutes(String filterId) throws Exception {
        if (this.m_EventConfig == null) {
            return Collections.emptyList();
        }
        return this.m_EventConfig.getEventRoutes(filterId);
    }

    @Override
    public Map<String, Boolean> getEventRouteStatus(String id, boolean isFilter) throws Exception {
        if (this.m_EventConfig == null) {
            return Collections.emptyMap();
        }
        return this.m_EventConfig.getEventRouteStatus(id, isFilter);
    }

    @Override
    public Map<String, Map<String, Boolean>> getAllEventRouteStatus() throws Exception {
        if (this.m_EventConfig == null) {
            return Collections.emptyMap();
        }
        return this.m_EventConfig.getAllEventRouteStatus();
    }

    @Deprecated
    public void load() throws IOException {
    }

    @Deprecated
    protected void doSave() {
    }

    @Deprecated
    public static void setConfiguration(Config config, boolean configValid) {
    }

    private String accessLevel() {
        JMXSupport jmxSupport = this.getJMXSupport();
        if (this.m_accessLevel == null) {
            this.m_accessLevel = jmxSupport != null ? (jmxSupport.isReadOnly() ? "RO" : "RW") : "UNKNOWN";
        }
        return this.m_accessLevel;
    }

    public boolean documentAdded(DocumentChangedEvent documentChangedEvent) {
        return true;
    }

    public boolean documentChanged(DocumentChangedEvent documentChangedEvent) throws Exception {
        return true;
    }

    @Deprecated
    public void sendEvent() {
        this.m_eventBroadcaster.sendManagementEvent("eventconfig.activation", "eventconfig.activated", (Object)this);
    }

    @Override
    public long getLastConfigActivationTime() throws Exception {
        return sConfigTimeStamp;
    }

    public boolean documentRemoved(DocumentChangedEvent documentChangedEvent) {
        return true;
    }

    @Inject
    public void setEventBroadcaster(EventBroadcaster eventBroadcaster) {
        this.m_eventBroadcaster = eventBroadcaster;
    }

    @Override
    public String getSummaryAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append('@').append(Integer.toHexString(this.hashCode())).append(" (").append(this.accessLevel()).append(") ").append('\n');
        sb.append(this.getJMXSupport().getObjectName().toString());
        sb.append("\n");
        sb.append(this.getServerName());
        sb.append("\n");
        if (this.m_isConfigUpdated) {
            sb.append("Pending configuration:\n");
            sb.append(JMXEventConfig.getEventConfigAsString(this.m_EventConfig));
        } else {
            sb.append("There are no pending config changes.\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    private static String getEventConfigAsString(EventConfig eventConfig) {
        StringBuilder sb = new StringBuilder();
        if (eventConfig == null) {
            sb.append("  Null configuration.\n");
        } else {
            Collection<Destination> ds = eventConfig.getAllDestinations();
            if (ds != null) {
                sb.append("  Destinations:\n");
                for (Destination d : ds) {
                    sb.append("    ");
                    sb.append(d.getDestinationId());
                    sb.append("\n      ");
                    sb.append(d.getDestinationClassName());
                    sb.append("\n");
                }
            } else {
                sb.append("  No destinations.\n");
            }
            Collection<Filter> fs = eventConfig.getAllFilters();
            if (fs != null) {
                sb.append("  Filters:\n");
                for (Filter f : fs) {
                    sb.append("    ");
                    sb.append(f.getFilterId());
                    sb.append("\n");
                }
            } else {
                sb.append("  No filters.\n");
            }
            Map<String, Map<String, Boolean>> allRoutes = eventConfig.getAllEventRouteStatus();
            if (allRoutes != null) {
                sb.append("  Event routes:\n");
                for (String filterId : allRoutes.keySet()) {
                    Map<String, Boolean> routesForFilter = allRoutes.get(filterId);
                    if (routesForFilter == null) continue;
                    for (String destinationId : routesForFilter.keySet()) {
                        sb.append("    ").append(filterId).append(" --> ").append(destinationId);
                        if (routesForFilter.get(destinationId).booleanValue()) {
                            sb.append(" (enabled)\n");
                            continue;
                        }
                        sb.append(" (disabled)\n ");
                    }
                }
            } else {
                sb.append("  No eventRoutes.\n");
            }
        }
        return sb.toString();
    }

    private String getServerName() {
        String METHOD_NAME = "getServerName";
        if (this.m_serverName == null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, CLASS_NAME, "getServerName", " id: " + this + " R/W: " + this.accessLevel() + " server name is: " + this.getJMXSupport());
            }
            if (this.getJMXSupport() != null) {
                this.m_logger.logp(Level.FINER, CLASS_NAME, "getServerName", " getObjectName=" + this.getJMXSupport().getObjectName() + " getKeyProperty=" + this.getJMXSupport().getObjectName().getKeyProperty("ServerName"));
                this.m_serverName = this.getJMXSupport().getObjectName().getKeyProperty("ServerName");
            }
        }
        return this.m_serverName;
    }

    protected JMXSupport getJMXSupport() {
        return this.m_jmxSupport;
    }

    @Inject
    public void setJMXSupport(JMXSupport jmxSupport) {
        String METHOD_NAME = "setJMXSupport";
        this.m_jmxSupport = jmxSupport;
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, CLASS_NAME, "setJMXSupport", "m_jmxSupport = " + this.m_jmxSupport);
        }
    }

    private EventConfigMBean getEventConfigMBean() throws Exception {
        ObjectName eventConfigON = null;
        String serverName = this.getServerName();
        if (this.m_platform == Platform.WebLogic) {
            eventConfigON = new ObjectName(EVENT_CONFIG_MBEAN_ON + this.m_serverKeyValue + serverName);
        } else if (this.m_platform == Platform.WebSphere) {
            Set<ObjectName> objNames = this.m_domainMbeanServer.queryNames(new ObjectName(EVENT_CONFIG_MBEAN_ON + this.m_serverKeyValue + serverName + WILDCARD), null);
            if (objNames != null && objNames.size() == 1) {
                eventConfigON = objNames.iterator().next();
            } else {
                throw new Exception("EventConfigMBean not found for server " + serverName);
            }
        }
        return (EventConfigMBean)MBeanProxy.newProxyInstance((MBeanServerConnection)this.m_domainMbeanServer, eventConfigON, EventConfigMBean.class, (boolean)true);
    }

    public boolean isConfigUpdated() {
        return this.m_isConfigUpdated;
    }

    public void resetConfigUpdated() {
        this.m_isConfigUpdated = false;
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.m_domainMbeanServer = server;
        return name;
    }
}

