/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import oracle.dms.reporter.TbmlReporter;
import oracle.dms.spy.ErrorObject;
import oracle.dms.table.ColumnDefinition;
import oracle.dms.table.ColumnDefinitionSupport;
import oracle.dms.table.Key;
import oracle.dms.table.Row;
import oracle.dms.table.RowComparator;
import oracle.dms.table.RowSelector;
import oracle.dms.table.RowSupport;
import oracle.dms.table.Schema;
import oracle.dms.table.SchemaSupport;
import oracle.dms.table.Table;
import oracle.dms.table.ValueType;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.NameSupport;
import oracle.dms.util.QueryOptions;

public class TableSupport
extends NameSupport
implements Table {
    protected Map<Key, RowSupport> m_rows = Collections.synchronizedMap(new LinkedHashMap());
    protected volatile SchemaSupport m_schema = null;
    private Set<String> m_keys = Collections.synchronizedSet(new TreeSet());
    private Hashtable<String, ValueType> m_types = new Hashtable();
    private Set<String> m_reportingServerNames = Collections.synchronizedSet(new HashSet());
    private boolean m_isCacheable = true;
    private Table.TableFamily m_family = Table.TableFamily.DEFAULT;
    static final Logger LOGGER = Logger.getLogger("oracle.dms.collector", "oracle.dms.util.dms");
    private static final String OMB = "OMB_";
    private static final String[] DEFAULT_KEYS = new String[]{"Host", "Name", "Parent", "Process"};
    private static final long serialVersionUID = -1150676101857L;

    public TableSupport() {
    }

    public TableSupport(TableSupport table, QueryOptions.QueryType queryType) {
        this();
        this.setName(table.m_name);
        this._copyFrom(table, new QueryOptions(queryType));
    }

    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("name=" + name);
        }
        this.m_name = name;
    }

    @Override
    public Schema getSchema() {
        return this.m_schema;
    }

    public void setSchema(SchemaSupport schema) {
        if (schema == null) {
            throw new IllegalArgumentException("schema=" + schema);
        }
        this.m_schema = schema;
    }

    @Override
    public int rowCount() {
        return this.m_rows.size();
    }

    public static String[] getDefaultKeys() {
        return (String[])DEFAULT_KEYS.clone();
    }

    @Override
    public Row getRow(Key key) {
        if (key == null) {
            return null;
        }
        return this.m_rows.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSupport[] getRows() {
        RowSupport[] rows;
        Map<Key, RowSupport> map = this.m_rows;
        synchronized (map) {
            rows = new RowSupport[this.m_rows.size()];
            this.m_rows.values().toArray(rows);
        }
        return rows;
    }

    public void setRows(RowSupport[] rows) {
        if (rows == null) {
            throw new IllegalArgumentException("rows=null");
        }
        if (rows.length == 0) {
            return;
        }
        for (RowSupport row : rows) {
            if (row == null) continue;
            row.setTable(this);
            Key key = row.getKey(true);
            this.m_rows.put(key, row);
        }
    }

    @Override
    public Enumeration<? extends Row> enumerateRows() {
        return this.enumerateRows((RowComparator)null);
    }

    @Override
    public Enumeration<? extends Row> enumerateRows(RowComparator comparator) {
        if (comparator == null) {
            return Collections.enumeration(this.m_rows.values());
        }
        Vector<RowSupport> vec = new Vector<RowSupport>(this.m_rows.values());
        Collections.sort(vec, comparator);
        return vec.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<? extends Row> enumerateRows(RowSelector selector) {
        if (selector == null) {
            return Collections.enumeration(this.m_rows.values());
        }
        Vector<RowSupport> selected = new Vector<RowSupport>();
        Map<Key, RowSupport> map = this.m_rows;
        synchronized (map) {
            for (RowSupport row : this.m_rows.values()) {
                if (!selector.select(row)) continue;
                selected.add(row);
            }
        }
        return selected.elements();
    }

    @Override
    public int keyCount() {
        return this.m_keys.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getKeys() {
        String[] ret;
        Set<String> set = this.m_keys;
        synchronized (set) {
            ret = new String[this.m_keys.size()];
            this.m_keys.toArray(ret);
        }
        return ret;
    }

    @Override
    public boolean containsKey(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        return this.m_keys.contains(name);
    }

    @Override
    public Enumeration<String> enumerateKeys(boolean sorted) {
        return Collections.enumeration(this.m_keys);
    }

    @Override
    public boolean containsColumn(String column) {
        if (column == null || column.trim().length() == 0) {
            return false;
        }
        return this.m_types.containsKey(column);
    }

    public void addRow(RowSupport row) {
        if (row == null) {
            return;
        }
        Key key = row.getKey(true);
        this.m_rows.put(key, row);
    }

    public RowSupport removeRow(Key key) {
        if (key == null) {
            return null;
        }
        return this.m_rows.remove(key);
    }

    @Override
    public boolean hasSchema() {
        return this.m_schema != null;
    }

    @Override
    public boolean hasRows() {
        return this.m_rows.size() > 0;
    }

    @Override
    public boolean hasKeys() {
        return this.m_keys.size() > 0;
    }

    public void addKey(String keyName) {
        if (keyName != null && keyName.trim().length() > 0) {
            this.m_keys.add(keyName);
        }
    }

    public void setKeys(Set<String> keyNames) {
        if (keyNames == null) {
            throw new IllegalArgumentException("keyNames=" + keyNames);
        }
        for (String key : keyNames) {
            if (key == null || key.trim().length() == 0) continue;
            this.m_keys.add(key);
        }
    }

    public void setKeys(String[] keyNames) {
        if (keyNames == null) {
            throw new IllegalArgumentException("keyNames=null");
        }
        for (String key : keyNames) {
            if (key == null || key.trim().length() == 0) continue;
            this.m_keys.add(key);
        }
    }

    public void setColumnType(String name, ValueType typeId) {
        if (name == null || name.trim().length() == 0 || typeId == null) {
            throw new IllegalArgumentException("name=" + name + " typeId=" + (Object)((Object)typeId));
        }
        this.m_types.put(name, typeId);
    }

    ValueType getColumnType(String name) {
        if (name == null || name.trim().length() == 0) {
            return ValueType.UNKNOWN;
        }
        ValueType type = this.m_types.get(name);
        if (type == null) {
            return ValueType.UNKNOWN;
        }
        return type;
    }

    public boolean containsColumnType(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        return this.m_types.containsKey(name);
    }

    public void setColumnTypes(Map<String, ValueType> columnTypes) {
        if (columnTypes == null || columnTypes.size() == 0) {
            return;
        }
        for (Map.Entry<String, ValueType> entry : columnTypes.entrySet()) {
            String name = entry.getKey();
            ValueType typeId = entry.getValue();
            this.setColumnType(name, typeId);
        }
    }

    public Map<String, ValueType> getColumnTypes() {
        return this.m_types == null ? null : (Map)this.m_types.clone();
    }

    public boolean addReportingServerNames(Set<String> serverNames) {
        if (serverNames == null || serverNames.size() == 0) {
            return false;
        }
        boolean changed = false;
        for (String name : serverNames) {
            changed |= this.addReportingServerName(name);
        }
        return changed;
    }

    public boolean addReportingServerName(String serverName) {
        if (serverName == null || serverName.trim().length() == 0) {
            return false;
        }
        return this.m_reportingServerNames.add(serverName);
    }

    public Set<String> getReportingServerNames() {
        return this.m_reportingServerNames;
    }

    public int reportingServerNameCount() {
        return this.m_reportingServerNames.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.appendNameHeader(buf);
        Map<Key, RowSupport> map = this.m_rows;
        synchronized (map) {
            for (RowSupport row : this.m_rows.values()) {
                buf.append('\n');
                row.appendRow(buf);
            }
        }
        return buf.toString();
    }

    public static String toString(CompositeData table) {
        Collection<?> rowCollection;
        if (table == null) {
            return "";
        }
        Object name = null;
        if (table.containsKey("Table")) {
            name = table.get("Table");
        }
        if (name == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        NameSupport.appendNameHeader(name.toString(), buf);
        Object rows = null;
        if (table.containsKey("Rows")) {
            rows = table.get("Rows");
        }
        if (rows == null || !(rows instanceof TabularData)) {
            return buf.toString();
        }
        Object schemaObj = null;
        if (table.containsKey("Schema")) {
            schemaObj = table.get("Schema");
        }
        TabularData schema = null;
        if (schemaObj != null && schemaObj instanceof TabularData) {
            schema = (TabularData)schemaObj;
        }
        if ((rowCollection = ((TabularData)rows).values()) == null) {
            return buf.toString();
        }
        for (CompositeData row : rowCollection) {
            buf.append('\n');
            Set<String> columns = row.getCompositeType().keySet();
            for (String column : columns) {
                CompositeData cdesc;
                Object value = row.get(column);
                if (value == null) continue;
                String unit = null;
                if (schema != null && (cdesc = schema.get(new String[]{column})) != null && cdesc.containsKey("Unit")) {
                    unit = (String)cdesc.get("Unit");
                }
                RowSupport.appendColumn(column, value, unit, buf);
            }
        }
        return buf.toString();
    }

    public static String[] toStrings(CompositeData[] tables) {
        if (tables == null) {
            return null;
        }
        String[] metrics = new String[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            metrics[i] = TableSupport.toString(tables[i]);
        }
        return metrics;
    }

    public synchronized TableSupport clone(QueryOptions options) {
        TableSupport clone = null;
        try {
            clone = (TableSupport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (options == null) {
            options = new QueryOptions(QueryOptions.QueryType.ALL);
        }
        clone.m_rows = Collections.synchronizedMap(new LinkedHashMap());
        clone._copyFrom(this, options);
        return clone;
    }

    public Object clone() {
        return this.clone(null);
    }

    @Override
    public void close() {
        HashMap<Key, RowSupport> rows = new HashMap<Key, RowSupport>(this.m_rows);
        this.m_rows.clear();
        this.m_types.clear();
        this.m_reportingServerNames.clear();
        if (this.m_schema != null) {
            this.m_schema.close();
        }
        for (RowSupport row : rows.values()) {
            row.close();
        }
        rows.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _copyFrom(TableSupport from, QueryOptions options) {
        boolean includeRows = from.hasRows() & options.includeRows();
        this.copyFromNoRows(from, options);
        if (!includeRows) {
            return;
        }
        RowSelector selector = this.getRowSelector(options);
        Map<Key, RowSupport> map = from.m_rows;
        synchronized (map) {
            for (RowSupport row : from.m_rows.values()) {
                if (selector != null && !selector.select(row)) continue;
                RowSupport newRow = row.clone(this);
                Key key = newRow.getKey();
                this.m_rows.put(key, newRow);
            }
        }
    }

    protected void copyFromNoRows(TableSupport from, QueryOptions options) {
        boolean includeSchema = from.hasSchema() && options.includeSchema();
        this.m_keys = Collections.synchronizedSet(new TreeSet<String>(from.m_keys));
        this.m_types = (Hashtable)from.m_types.clone();
        this.m_reportingServerNames = Collections.synchronizedSet(new HashSet<String>(from.m_reportingServerNames));
        this.m_isCacheable = from.m_isCacheable;
        this.m_family = from.m_family;
        boolean includeDescriptions = options.includeDescriptions();
        if (includeSchema) {
            this.m_schema = from.m_schema.clone(this, includeDescriptions);
            if (includeDescriptions) {
                this.m_isCacheable = false;
            }
        } else {
            this.m_schema = null;
        }
    }

    public void updateNoRows(TableSupport from, boolean includeSchema, boolean updateDescriptions) {
        includeSchema = from.hasSchema() && includeSchema;
        this.m_keys.addAll(from.m_keys);
        this.m_types.putAll(from.m_types);
        this.m_reportingServerNames.addAll(from.m_reportingServerNames);
        if (includeSchema && this.m_schema != null) {
            SchemaSupport schema = (SchemaSupport)from.getSchema();
            this.m_schema.update(schema, updateDescriptions);
        }
    }

    public void printTbml(PrintWriter out, QueryOptions options) {
        boolean includeSchema = true;
        boolean includeRows = true;
        boolean includeDescriptions = false;
        if (options != null) {
            includeSchema = options.includeSchema();
            includeRows = options.includeRows();
            includeDescriptions = options.includeDescriptions();
        }
        TbmlReporter.printTableHeading(this.m_name, this.m_keys, this.m_reportingServerNames, this.m_isCacheable && !includeDescriptions, out);
        if (includeSchema) {
            this.printTbmlSchema(out);
        }
        if (includeRows) {
            this.printTbmlValues(0L, out);
        }
        TbmlReporter.printTableEnding(out);
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTbmlSchema(PrintWriter out) {
        if (this.hasSchema()) {
            this.m_schema.printTbml(true, out);
        } else {
            Hashtable<String, ValueType> hashtable = this.m_types;
            synchronized (hashtable) {
                for (Map.Entry<String, ValueType> entry : this.m_types.entrySet()) {
                    String column = entry.getKey();
                    ValueType type = entry.getValue();
                    TbmlReporter.printColumnDefinition(column, type.toString(), null, null, out);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTbmlValues(long valueRefreshTime, PrintWriter out) {
        Map<Key, RowSupport> map = this.m_rows;
        synchronized (map) {
            for (RowSupport row : this.m_rows.values()) {
                row.printTbml(valueRefreshTime, out);
            }
        }
    }

    public String toTbml(QueryOptions options) {
        StringWriter buf = new StringWriter();
        if (options == null) {
            options = new QueryOptions(QueryOptions.QueryType.ALL);
        }
        this.printTbml(new PrintWriter(buf), options);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeData toOpenMBean() throws OpenDataException {
        ArrayList<String> tableFields = new ArrayList<String>(4);
        ArrayList<String> tableFieldDescs = new ArrayList<String>(4);
        ArrayList<OpenType> tableFieldTypes = new ArrayList<OpenType>(4);
        ArrayList<Object> tableFieldValues = new ArrayList<Object>(4);
        tableFields.add("Table");
        tableFieldDescs.add(DMSNLSupport.getString("OMB_Table"));
        tableFieldTypes.add(SimpleType.STRING);
        tableFieldValues.add(this.getName());
        if (this.hasRows()) {
            SimpleType[] columnTypes;
            String[] columnNames;
            int size;
            int i = 0;
            boolean hasKeys = true;
            String[] keys = this.getKeys();
            String rowId = "RowID";
            if (keys == null || keys.length == 0) {
                hasKeys = false;
                while (this.containsColumn(rowId)) {
                    rowId = "RowID" + i++;
                }
                keys = new String[]{rowId};
            }
            Hashtable<String, ValueType> hashtable = this.m_types;
            synchronized (hashtable) {
                size = this.m_types.size();
                columnNames = new String[hasKeys ? size : size + 1];
                columnTypes = new SimpleType[hasKeys ? size : size + 1];
                i = 0;
                for (Map.Entry<String, ValueType> entry : this.m_types.entrySet()) {
                    columnNames[i] = entry.getKey();
                    ValueType columnType = entry.getValue();
                    switch (columnType) {
                        case INTEGER: {
                            columnTypes[i] = SimpleType.INTEGER;
                            break;
                        }
                        case DOUBLE: {
                            columnTypes[i] = SimpleType.DOUBLE;
                            break;
                        }
                        case LONG: {
                            columnTypes[i] = SimpleType.LONG;
                            break;
                        }
                        default: {
                            columnTypes[i] = SimpleType.STRING;
                        }
                    }
                    ++i;
                }
            }
            if (!hasKeys) {
                columnNames[size] = rowId;
                columnTypes[size] = SimpleType.INTEGER;
            }
            CompositeType rowType = new CompositeType("MetricRow", DMSNLSupport.getString("OMB_MetricRow"), columnNames, columnNames, columnTypes);
            TabularType rowsType = new TabularType("MetricRows", DMSNLSupport.getString("OMB_MetricRows"), rowType, keys);
            TabularDataSupport rows = new TabularDataSupport(rowsType);
            i = 0;
            Enumeration<? extends Row> iter = this.enumerateRows();
            while (iter.hasMoreElements()) {
                RowSupport row = (RowSupport)iter.nextElement();
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                for (int j = 0; j < size; ++j) {
                    Object value = row.getValue(columnNames[j]);
                    if (value != null) {
                        if (value instanceof ErrorObject) {
                            value = columnTypes[j] == SimpleType.STRING ? DMSNLSupport.getString("NO_VALUE") : null;
                        } else if (columnTypes[j] == SimpleType.STRING && !(value instanceof String)) {
                            value = value.toString();
                        }
                    }
                    map.put(columnNames[j], (Serializable)value);
                }
                if (!hasKeys) {
                    map.put(columnNames[size], Integer.valueOf(i));
                }
                CompositeDataSupport openRows = new CompositeDataSupport(rowType, map);
                rows.put(openRows);
                ++i;
            }
            tableFields.add("Rows");
            tableFieldDescs.add(DMSNLSupport.getString("OMB_Rows"));
            tableFieldTypes.add(rowsType);
            tableFieldValues.add(rows);
        }
        if (this.hasSchema()) {
            CompositeType columnSchemaType = new CompositeType("MetricColumnSchema", DMSNLSupport.getString("OMB_ColumnTypeSchema"), new String[]{"Column", "Type", "Unit", "Description"}, new String[]{DMSNLSupport.getString("OMB_Column"), DMSNLSupport.getString("OMB_Type"), DMSNLSupport.getString("OMB_Unit"), DMSNLSupport.getString("OMB_Description")}, new SimpleType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
            TabularType rowSchemaType = new TabularType("MetricRowSchema", DMSNLSupport.getString("OMB_RowTypeSchema"), columnSchemaType, new String[]{"Column"});
            TabularDataSupport rschema = new TabularDataSupport(rowSchemaType);
            Enumeration<? extends ColumnDefinition> iter = this.m_schema.enumerateColumnDefinitions(false);
            while (iter.hasMoreElements()) {
                ColumnDefinitionSupport cdef = (ColumnDefinitionSupport)iter.nextElement();
                String name = cdef.getName();
                String unit = cdef.getUnit();
                String description = cdef.getDescription();
                String type = cdef.getType();
                CompositeDataSupport columnSchema = new CompositeDataSupport(columnSchemaType, new String[]{"Column", "Type", "Unit", "Description"}, new String[]{name, type, unit, description});
                rschema.put(columnSchema);
            }
            tableFields.add("Schema");
            tableFieldDescs.add(DMSNLSupport.getString("OMB_Schema"));
            tableFieldTypes.add(rowSchemaType);
            tableFieldValues.add(rschema);
        }
        String[] fields = new String[tableFields.size()];
        String[] fieldDescs = new String[tableFieldDescs.size()];
        OpenType[] fieldTypes = new OpenType[tableFieldTypes.size()];
        Object[] fieldValues = new Object[tableFieldValues.size()];
        tableFields.toArray(fields);
        tableFieldDescs.toArray(fieldDescs);
        tableFieldTypes.toArray(fieldTypes);
        tableFieldValues.toArray(fieldValues);
        CompositeType tableType = new CompositeType("MetricTable", DMSNLSupport.getString("OMB_TableType"), fields, fieldDescs, fieldTypes);
        CompositeDataSupport ret = new CompositeDataSupport(tableType, fields, fieldValues);
        return ret;
    }

    public static CompositeData[] toOpenMBeans(Table[] tables) throws OpenDataException {
        if (tables == null) {
            return null;
        }
        CompositeData[] ret = new CompositeData[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i] == null) continue;
            ret[i] = tables[i].toOpenMBean();
        }
        return ret;
    }

    protected RowSelector getRowSelector(QueryOptions options) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepRows(QueryOptions options) {
        RowSelector selector = this.getRowSelector(options);
        if (selector == null) {
            return;
        }
        Map<Key, RowSupport> map = this.m_rows;
        synchronized (map) {
            Iterator<RowSupport> iter = this.m_rows.values().iterator();
            while (iter.hasNext()) {
                RowSupport row = iter.next();
                if (selector.select(row)) continue;
                iter.remove();
            }
        }
    }

    public void setCacheable(boolean isCacheable) {
        this.m_isCacheable = isCacheable;
    }

    public boolean isCacheable() {
        return this.m_isCacheable;
    }

    public void setFamily(Table.TableFamily family) {
        this.m_family = family;
    }

    @Override
    public Table.TableFamily getFamily() {
        return this.m_family;
    }

    public boolean tableMatchesQueryOptions(QueryOptions queryOptions) {
        boolean retVal = false;
        if (this.getFamily() == Table.TableFamily.DEFAULT) {
            retVal = true;
        } else if (this.getFamily() == Table.TableFamily.PARAMETER_SCOPED_METRICS_TABLES && queryOptions.isIncludeParamScopedMetricTables()) {
            retVal = true;
        }
        return retVal;
    }
}

