/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.trace2.runtime;

import java.io.Serializable;
import java.util.logging.Level;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.dms.event.EventResourceBundle;

public enum DataType {
    DOUBLE(Double.TYPE, new TypeConvertor(){

        @Override
        public Comparable getComparable(String value) {
            return new Double(value);
        }
    }),
    LONG(Long.TYPE, new TypeConvertor(){

        @Override
        public Comparable getComparable(String value) {
            return new Long(value);
        }
    }),
    STRING(String.class, new TypeConvertor(){

        @Override
        public Comparable getComparable(String value) {
            return value;
        }
    });

    private Class m_type;
    private TypeConvertor m_convertor;
    private static final String CLASS_NAME;
    public static final ODLLogger LOGGER;
    private static final long serialVersionUID = 0L;

    private DataType(Class type, TypeConvertor convertor) {
        this.m_type = type;
        this.m_convertor = convertor;
    }

    public boolean isValidType(Serializable object) {
        return this.m_type.isAssignableFrom(object.getClass());
    }

    public Comparable getComparable(String s) {
        String METHOD_NAME = "getComparable";
        Comparable value = null;
        try {
            value = this.m_convertor.getComparable(s);
        }
        catch (Exception e) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "getComparable", "The DataType value: " + s + " is not valid for a " + (Object)((Object)this) + ".", (Throwable)e);
        }
        return value;
    }

    public static DataType decodeConfigDataType(oracle.dms.event.config.DataType dataType) {
        if (dataType != null) {
            switch (dataType) {
                case LONG: {
                    return LONG;
                }
                case STRING: {
                    return STRING;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
            }
        }
        return null;
    }

    static {
        CLASS_NAME = DataType.class.getName();
        LOGGER = ODLLogger.getODLLogger((String)"oracle.dms.event", (String)EventResourceBundle.class.getName());
    }

    private static interface TypeConvertor {
        public Comparable getComparable(String var1);
    }
}

