/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ControlReportNouns {
    public static void main(String[] args) throws IOException {
        VirtualMachine vm = null;
        Map<String, String> argMap = ControlReportNouns.convertToArgMap(args);
        String pid = ControlReportNouns.getArg(argMap, "pid", null);
        if (pid == null) {
            System.out.println("You must specify the process id of the server (use jps to check).");
            System.out.println("Usage: ControlReportNouns -pid <pid> -operation <op>");
            return;
        }
        try {
            vm = VirtualMachine.attach(pid);
        }
        catch (AttachNotSupportedException anse) {
            System.out.println("You must specify the process id of the server (use jps to check).");
            return;
        }
        System.out.println("Successfully attached to process " + pid);
        String op = ControlReportNouns.getArg(argMap, "operation", "null");
        if (op == null) {
            System.out.println("You must specify an operation.");
            System.out.println("Usage: ControlReportNouns -pid <pid> -operation <op>");
            System.out.println("Valid operations: ");
            System.out.println("enable|disableReportNouns");
            System.out.println("enable|disableReportSensors");
            System.out.println("clearStackTraces");
            System.out.println("printStackTraces");
            return;
        }
        URL url = ControlReportNouns.class.getResource("ControlReportNouns.class");
        String urlpath = url.getFile();
        int startPath = urlpath.indexOf("file:") + "file:".length();
        int endPath = urlpath.indexOf(33);
        String agent = urlpath.substring(startPath, endPath);
        try {
            vm.loadAgent(agent, op);
        }
        catch (AgentLoadException ale) {
            System.out.println("Could not load the Agent at pathname:" + agent);
        }
        catch (AgentInitializationException aie) {
            System.out.println("Could not initialize the Agent at pathname:" + agent);
        }
        vm.detach();
    }

    private static Map<String, String> convertToArgMap(String[] args) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String argName = args[i];
                String argVal = null;
                if (i + 1 < args.length) {
                    argVal = args[i + 1];
                }
                if (argName.charAt(0) != '-' || argName.length() <= 1) continue;
                argMap.put(argName.substring(1), argVal);
            }
        }
        return argMap;
    }

    private static int getArg(Map<String, String> argMap, String name, int defolt) {
        int retVal = defolt;
        String argVal = argMap.get(name);
        if (argVal != null) {
            try {
                retVal = Integer.parseInt(argVal);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return retVal;
    }

    private static boolean getArg(Map<String, String> argMap, String name, boolean defolt) {
        boolean retVal = defolt;
        String argVal = argMap.get(name);
        if (argVal != null) {
            try {
                retVal = Boolean.parseBoolean(argVal);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return retVal;
    }

    private static String getArg(Map<String, String> argMap, String name, String defolt) {
        String retVal = defolt;
        String argVal = argMap.get(name);
        if (argVal != null) {
            try {
                retVal = argVal;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return retVal;
    }
}

