/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.util.HashMap;
import oracle.as.management.tracing.model.TreeNode;
import oracle.as.management.tracing.model.build.ProcessedRecord;
import oracle.as.management.tracing.model.build.ProcessedRecordFactory;
import oracle.as.management.tracing.model.build.RecordProcessor;
import oracle.core.ojdl.reader.LogRecord;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventParser;

public class DMSTraceRecordProcessor
implements RecordProcessor<LogRecord> {
    private DMSTraceRecordProcessor() {
    }

    public static DMSTraceRecordProcessor create() {
        return new DMSTraceRecordProcessor();
    }

    public ProcessedRecord processRecord(LogRecord logRecord, ProcessedRecordFactory processedRecordFactory, TreeNode<LogRecord> currentNode) {
        EventParser.ParsedEvent pe;
        String dmsTraceString;
        ProcessedRecord retVal = null;
        HashMap<String, Object> additionalData = null;
        if (logRecord != null && (dmsTraceString = (String)logRecord.getField("MSG_TEXT")) != null && (pe = EventParser.parseEvent(dmsTraceString)) != null) {
            ProcessedRecord.Advice advice = null;
            long timestamp = -1L;
            timestamp = pe.getEventTime();
            additionalData = new HashMap<String, Object>(2);
            additionalData.put("oracle.dms.trace.EventRecord", dmsTraceString);
            additionalData.put("oracle.dms.trace.ParsedEvent", pe);
            advice = pe.getEventActionType() == EventActionType.START ? ProcessedRecord.Advice.START_OF_CHILD_ACTION : (pe.getEventActionType() == EventActionType.STOP ? ProcessedRecord.Advice.END_OF_CHILD_ACTION : (pe.getEventActionType() == EventActionType.METRIC_SELECTION_CHANGED ? ProcessedRecord.Advice.NO_ACTION : ProcessedRecord.Advice.NEW_ACTION));
            retVal = processedRecordFactory.create(advice, timestamp, additionalData);
        }
        return retVal;
    }
}

