/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;

@ProxyFor(value={OracleClob.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableClob
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETASCIISTREAM_METHOD;
    private static final Method GETASCIISTREAM_LONG_METHOD;
    private static final Method GETCHARSTREAM_METHOD;
    private static final Method GETCHARSTREAM_LONG_METHOD;
    private static final Method GETCHARSTREAM_LONG_LONG_METHOD;
    private static final Method SETASCIISTREAM_LONG_METHOD;
    private static final Method SETCHARSTREAM_LONG_METHOD;
    protected boolean isFreed;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    protected TxnReplayableClob() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$27, null, new Object[0]);
            }
            this.isFreed = false;
            this.thisProxyNameInLog = "CLOB" + this.thisProxyNameInLog;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$27, null);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$27, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$27, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final Method getGetAsciiStreamMethod() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Method method;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$0, null, new Object[0]);
                }
                try {
                    method = OracleClob.class.getMethod("getAsciiStream", new Class[0]);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    Method method2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$0, null, method2);
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$0, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$0, null, method);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$0, null, null);
            }
            return method;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final Method getGetAsciiStreamLongMethod() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Method method;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$1, null, new Object[0]);
                }
                try {
                    method = OracleClob.class.getMethod("getAsciiStream", Long.TYPE);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    Method method2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$1, null, method2);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$1, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$1, null, method);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$1, null, null);
            }
            return method;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final Method getGetCharacterStreamMethod() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Method method;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$2, null, new Object[0]);
                }
                try {
                    method = OracleClob.class.getMethod("getCharacterStream", new Class[0]);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    Method method2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$2, null, method2);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$2, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$2, null, method);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$2, null, null);
            }
            return method;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final Method getGetCharacterStreamLongMethod() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Method method;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$3, null, new Object[0]);
                }
                try {
                    method = OracleClob.class.getMethod("getCharacterStream", Long.TYPE);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    Method method2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$3, null, method2);
                        ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$3, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$3, null, method);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$3, null, null);
            }
            return method;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final Method getGetCharacterStreamLongLongMethod() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Method method;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$4, null, new Object[0]);
                }
                try {
                    method = OracleClob.class.getMethod("getCharacterStream", Long.TYPE, Long.TYPE);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    Method method2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$4, null, method2);
                        ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$4, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$4, null, method);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$4, null, null);
            }
            return method;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final Method getSetAsciiStreamLongMethod() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Method method;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$5, null, new Object[0]);
                }
                try {
                    method = OracleClob.class.getMethod("setAsciiStream", Long.TYPE);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    Method method2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$5, null, method2);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$5, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$5, null, method);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$5, null, null);
            }
            return method;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final Method getSetCharacterStreamLongMethod() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Method method;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$6, null, new Object[0]);
                }
                try {
                    method = OracleClob.class.getMethod("setCharacterStream", Long.TYPE);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    Method method2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$6, null, method2);
                        ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$6, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$6, null, method);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$6, null, null);
            }
            return method;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void args;
            void receiver;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$7, this, method, object, objectArray);
            }
            super.preForAll((Method)m2, receiver, (Object[])args);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Post
    protected void postForAll(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$8, this, method);
            }
            this.postForAll((Method)m2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            void result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$9, this, method, object);
            }
            if (result instanceof TxnReplayableBase) {
                TxnReplayableBase jdbcProxy = (TxnReplayableBase)result;
                jdbcProxy.setFailoverManager(this.getFailoverManager());
            }
            Object object2 = super.postForAll((Method)m2, result);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$9, this, object2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$9, this, null);
            }
            return object2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block8: {
                void m2;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$10, this, method);
                }
                this.postForAll((Method)m2);
                TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
                if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                    this.isLogicallyClosed = true;
                    try {
                        TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                        connProxy.checkImplicitRequestBoundary();
                    }
                    catch (Throwable error) {
                        if (!bl) break block8;
                        OracleLog.log($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "On Clob {0}, implicit boundary check failed", this);
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="free", args={})})
    protected void postForFree(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block8: {
                TxnFailoverManagerImpl.ReplayLifecycle lifecycle;
                void m2;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$11, this, method);
                }
                super.postForAll((Method)m2);
                if (!this.isFreed && (lifecycle = this.failoverMngr.getReplayLifecycle()) == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                    this.failoverMngr.setStateSignatureSyncUp();
                    try {
                        TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                        connProxy.checkImplicitRequestBoundary();
                    }
                    catch (Throwable error) {
                        if (!bl) break block8;
                        OracleLog.log($$$loggerRef$$$11, Level.FINEST, this.getClass(), $$$methodRef$$$11, "On Clob {0}, implicit boundary check failed", this);
                    }
                }
            }
            this.isFreed = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$12, this, method, sQLException);
            }
            super.onErrorVoidForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$13, this, method, sQLException);
            }
            Object object = super.onErrorForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$13, this, object);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$13, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    /*
     * WARNING - void declaration
     */
    @Override
    public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$14, this, callHistoryEntry, sQLRecoverableException);
            }
            if (entry == this.headSameProxy) {
                this.isFreed = false;
            }
            Object object = super.replayOneCall((TxnFailoverManagerImpl.CallHistoryEntry)entry, (SQLRecoverableException)origError);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$14, this, object);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$14, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            InputStream inputStream;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$15, this, new Object[0]);
                }
                if (GETASCIISTREAM_METHOD == null) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot get ascii stream");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$15, this, sQLException);
                    }
                    throw sQLException;
                }
                Method m2 = GETASCIISTREAM_METHOD;
                this.failoverMngr.setLobStreamInRequest(true);
                this.preForAll(m2, this, new Object[0]);
                try {
                    OracleClob delegate = (OracleClob)this.getDelegate();
                    if (this.isFreed) {
                        SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                        sqlexc.fillInStackTrace();
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$15, this, sQLException);
                        }
                        throw sQLException;
                    }
                    InputStream delegateReturn = delegate.canReadBasicLobDataInLocator() ? delegate.getAsciiStream() : delegate.getDBAccess().newInputStream((OracleClob)((Object)this), delegate.getBufferSize(), 0L);
                    inputStream = (InputStream)this.postForAll(m2, delegateReturn);
                    if (!bl) break block11;
                }
                catch (SQLException sqlexc) {
                    InputStream inputStream2 = (InputStream)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$15, this, inputStream2);
                        ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$15, this, null);
                    }
                    return inputStream2;
                }
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$15, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$15, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getAsciiStream(long l2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            InputStream inputStream;
            block15: {
                void pos;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$16, this, l2);
                }
                if (GETASCIISTREAM_LONG_METHOD == null) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot get ascii stream");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$16, this, sQLException);
                    }
                    throw sQLException;
                }
                Method m2 = GETASCIISTREAM_LONG_METHOD;
                this.failoverMngr.setLobStreamInRequest(true);
                this.preForAll(m2, this, (long)pos);
                try {
                    InputStream delegateReturn;
                    OracleClob delegate = (OracleClob)this.getDelegate();
                    if (this.isFreed) {
                        SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                        sqlexc.fillInStackTrace();
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$16, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (delegate.canReadBasicLobDataInLocator()) {
                        delegateReturn = delegate.getAsciiStream((long)pos);
                    } else {
                        if (pos < 1L) {
                            SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 68);
                            sqlexc.fillInStackTrace();
                            SQLException sQLException = sqlexc;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$16, this, sQLException);
                            }
                            throw sQLException;
                        }
                        delegateReturn = delegate.getDBAccess().newInputStream((OracleClob)((Object)this), delegate.getBufferSize(), (long)pos);
                    }
                    inputStream = (InputStream)this.postForAll(m2, delegateReturn);
                    if (!bl) break block15;
                }
                catch (SQLException sqlexc) {
                    InputStream inputStream2 = (InputStream)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$16, this, inputStream2);
                        ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$16, this, null);
                    }
                    return inputStream2;
                }
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$16, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$16, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Reader reader;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$17, this, new Object[0]);
                }
                if (GETCHARSTREAM_METHOD == null) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot get character stream");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$17, this, sQLException);
                    }
                    throw sQLException;
                }
                Method m2 = GETCHARSTREAM_METHOD;
                this.failoverMngr.setLobStreamInRequest(true);
                this.preForAll(m2, this, new Object[0]);
                try {
                    OracleClob delegate = (OracleClob)this.getDelegate();
                    if (this.isFreed) {
                        SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                        sqlexc.fillInStackTrace();
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$17, this, sQLException);
                        }
                        throw sQLException;
                    }
                    Reader delegateReturn = delegate.canReadBasicLobDataInLocator() ? delegate.getCharacterStream() : delegate.getDBAccess().newReader((OracleClob)((Object)this), delegate.getBufferSize(), 0L);
                    reader = (Reader)this.postForAll(m2, delegateReturn);
                    if (!bl) break block11;
                }
                catch (SQLException sqlexc) {
                    Reader reader2 = (Reader)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$17, this, reader2);
                        ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$17, this, null);
                    }
                    return reader2;
                }
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$17, this, reader);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$17, this, null);
            }
            return reader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Reader getCharacterStream(long l2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Reader reader;
            block15: {
                void pos;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$18, this, l2);
                }
                if (GETCHARSTREAM_LONG_METHOD == null) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot get character stream");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$18, this, sQLException);
                    }
                    throw sQLException;
                }
                Method m2 = GETCHARSTREAM_LONG_METHOD;
                this.failoverMngr.setLobStreamInRequest(true);
                this.preForAll(m2, this, (long)pos);
                try {
                    Reader delegateReturn;
                    OracleClob delegate = (OracleClob)this.getDelegate();
                    if (this.isFreed) {
                        SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                        sqlexc.fillInStackTrace();
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$18, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (delegate.canReadBasicLobDataInLocator()) {
                        delegateReturn = delegate.getCharacterStream((long)pos);
                    } else {
                        if (pos < 1L) {
                            SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 68);
                            sqlexc.fillInStackTrace();
                            SQLException sQLException = sqlexc;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$18, this, sQLException);
                            }
                            throw sQLException;
                        }
                        delegateReturn = delegate.getDBAccess().newReader((OracleClob)((Object)this), delegate.getBufferSize(), (long)pos);
                    }
                    reader = (Reader)this.postForAll(m2, delegateReturn);
                    if (!bl) break block15;
                }
                catch (SQLException sqlexc) {
                    Reader reader2 = (Reader)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$18, this, reader2);
                        ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$18, this, null);
                    }
                    return reader2;
                }
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$18, this, reader);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$18, this, null);
            }
            return reader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Reader reader;
            block15: {
                void length;
                void pos;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$19, this, l2, l3);
                }
                if (GETCHARSTREAM_LONG_LONG_METHOD == null) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot get character stream");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$19, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$19, this, sQLException);
                    }
                    throw sQLException;
                }
                Method m2 = GETCHARSTREAM_LONG_LONG_METHOD;
                this.failoverMngr.setLobStreamInRequest(true);
                this.preForAll(m2, this, (long)pos, (long)length);
                try {
                    Reader delegateReturn;
                    OracleClob delegate = (OracleClob)this.getDelegate();
                    if (this.isFreed) {
                        SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                        sqlexc.fillInStackTrace();
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$19, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$19, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (delegate.canReadBasicLobDataInLocator()) {
                        delegateReturn = delegate.getCharacterStream((long)pos, (long)length);
                    } else {
                        long lobLen = delegate.length();
                        if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
                            SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 68);
                            sqlexc.fillInStackTrace();
                            SQLException sQLException = sqlexc;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$19, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$19, this, sQLException);
                            }
                            throw sQLException;
                        }
                        delegateReturn = delegate.getDBAccess().newReader((OracleClob)((Object)this), delegate.getBufferSize(), (long)pos, (long)length);
                    }
                    reader = (Reader)this.postForAll(m2, delegateReturn);
                    if (!bl) break block15;
                }
                catch (SQLException sqlexc) {
                    Reader reader2 = (Reader)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$19, this, reader2);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$19, this, null);
                    }
                    return reader2;
                }
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$19, this, reader);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$19, this, null);
            }
            return reader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream setAsciiStream(long l2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            OutputStream outputStream;
            block11: {
                void pos;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$20, this, l2);
                }
                if (SETASCIISTREAM_LONG_METHOD == null) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot set ascii stream");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$20, this, sQLException);
                    }
                    throw sQLException;
                }
                Method m2 = SETASCIISTREAM_LONG_METHOD;
                this.failoverMngr.setLobStreamInRequest(true);
                this.preForAll(m2, this, (long)pos);
                try {
                    OracleClob delegate = (OracleClob)this.getDelegate();
                    if (this.isFreed) {
                        SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                        sqlexc.fillInStackTrace();
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$20, this, sQLException);
                        }
                        throw sQLException;
                    }
                    OutputStream delegateReturn = delegate.getDBAccess().newOutputStream((OracleClob)((Object)this), delegate.getBufferSize(), (long)pos, true);
                    outputStream = (OutputStream)this.postForAll(m2, delegateReturn);
                    if (!bl) break block11;
                }
                catch (SQLException sqlexc) {
                    OutputStream outputStream2 = (OutputStream)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$20, this, outputStream2);
                        ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$20, this, null);
                    }
                    return outputStream2;
                }
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$20, this, outputStream);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$20, this, null);
            }
            return outputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Writer setCharacterStream(long l2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Writer writer;
            block11: {
                void pos;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$21, this, l2);
                }
                if (SETCHARSTREAM_LONG_METHOD == null) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot set character stream");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$21, this, sQLException);
                    }
                    throw sQLException;
                }
                Method m2 = SETCHARSTREAM_LONG_METHOD;
                this.failoverMngr.setLobStreamInRequest(true);
                this.preForAll(m2, this, (long)pos);
                try {
                    OracleClob delegate = (OracleClob)this.getDelegate();
                    if (this.isFreed) {
                        SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                        sqlexc.fillInStackTrace();
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$21, this, sQLException);
                        }
                        throw sQLException;
                    }
                    Writer delegateReturn = delegate.getDBAccess().newWriter((OracleClob)((Object)this), delegate.getBufferSize(), (long)pos, true);
                    writer = (Writer)this.postForAll(m2, delegateReturn);
                    if (!bl) break block11;
                }
                catch (SQLException sqlexc) {
                    Writer writer2 = (Writer)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$21, this, writer2);
                        ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$21, this, null);
                    }
                    return writer2;
                }
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$21, this, writer);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$21, this, null);
            }
            return writer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$22, this, new Object[0]);
            }
            OutputStream outputStream = this.setAsciiStream(1L);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$22, this, outputStream);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$22, this, null);
            }
            return outputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream getAsciiOutputStream(long l2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void pos;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$23, this, l2);
            }
            OutputStream outputStream = this.setAsciiStream((long)pos);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$23, this, outputStream);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$23, this, null);
            }
            return outputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    public Writer getCharacterOutputStream() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$24, this, new Object[0]);
            }
            Writer writer = this.setCharacterStream(1L);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$24, this, writer);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$24, this, null);
            }
            return writer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Writer getCharacterOutputStream(long l2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void pos;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$25, this, l2);
            }
            Writer writer = this.setCharacterStream((long)pos);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$25, this, writer);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$25, this, null);
            }
            return writer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$26, this, new Object[0]);
            }
            OracleClob delegate = (OracleClob)this.getDelegate();
            OracleConnection oracleConnection = delegate.getInternalConnection();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$26, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$26, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TxnReplayableClob.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$27 = TxnReplayableClob.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = TxnReplayableClob.class.getDeclaredMethod("getInternalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = TxnReplayableClob.class.getDeclaredMethod("getCharacterOutputStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = TxnReplayableClob.class.getDeclaredMethod("getCharacterOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = TxnReplayableClob.class.getDeclaredMethod("getAsciiOutputStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = TxnReplayableClob.class.getDeclaredMethod("getAsciiOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = TxnReplayableClob.class.getDeclaredMethod("setCharacterStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = TxnReplayableClob.class.getDeclaredMethod("setAsciiStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = TxnReplayableClob.class.getDeclaredMethod("getCharacterStream", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = TxnReplayableClob.class.getDeclaredMethod("getCharacterStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnReplayableClob.class.getDeclaredMethod("getCharacterStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnReplayableClob.class.getDeclaredMethod("getAsciiStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnReplayableClob.class.getDeclaredMethod("getAsciiStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnReplayableClob.class.getDeclaredMethod("replayOneCall", TxnFailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnReplayableClob.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnReplayableClob.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnReplayableClob.class.getDeclaredMethod("postForFree", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnReplayableClob.class.getDeclaredMethod("postForClose", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnReplayableClob.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnReplayableClob.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnReplayableClob.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnReplayableClob.class.getDeclaredMethod("getSetCharacterStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnReplayableClob.class.getDeclaredMethod("getSetAsciiStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnReplayableClob.class.getDeclaredMethod("getGetCharacterStreamLongLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnReplayableClob.class.getDeclaredMethod("getGetCharacterStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnReplayableClob.class.getDeclaredMethod("getGetCharacterStreamMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnReplayableClob.class.getDeclaredMethod("getGetAsciiStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnReplayableClob.class.getDeclaredMethod("getGetAsciiStreamMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        GETASCIISTREAM_METHOD = TxnReplayableClob.getGetAsciiStreamMethod();
        GETASCIISTREAM_LONG_METHOD = TxnReplayableClob.getGetAsciiStreamLongMethod();
        GETCHARSTREAM_METHOD = TxnReplayableClob.getGetCharacterStreamMethod();
        GETCHARSTREAM_LONG_METHOD = TxnReplayableClob.getGetCharacterStreamLongMethod();
        GETCHARSTREAM_LONG_LONG_METHOD = TxnReplayableClob.getGetCharacterStreamLongLongMethod();
        SETASCIISTREAM_LONG_METHOD = TxnReplayableClob.getSetAsciiStreamLongMethod();
        SETCHARSTREAM_LONG_METHOD = TxnReplayableClob.getSetCharacterStreamLongMethod();
    }
}

