/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T4CXAConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.xa.OracleXAConnectionBuilderImpl;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int rmid;
    private String xaOpenString;
    private static boolean libraryLoaded;
    private static final String dbSuffix = "HeteroXA";
    private static final String dllName = "heteroxa19";
    private static final char atSignChar = '@';
    private static int rmidSeed;
    private static final int MAX_RMID_SEED = 65536;
    private String driverCharSetIdString;
    private String oldTnsEntry;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Apr_04_20:58:27_PDT_2019";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    public OracleXADataSource() throws SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$17, null, new Object[0]);
            }
            this.rmid = -1;
            this.xaOpenString = null;
            this.driverCharSetIdString = null;
            this.oldTnsEntry = null;
            this.isOracleDataSource = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$17, null);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$17, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$0, this, new Object[0]);
            }
            Properties prop = new Properties(this.connectionProperties);
            if (this.user != null && this.password != null) {
                prop.setProperty("user", this.user);
                prop.setProperty("password", this.password.get());
            }
            XAConnection xAConnection = this.getXAConnection(prop);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$0, this, xAConnection);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$0, this, null);
            }
            return xAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public XAConnection getXAConnection(String string, @Blind String string2) throws SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void passwd;
            void userName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$1, this, string, "*****");
            }
            Properties prop = new Properties(this.connectionProperties);
            if (userName == null || passwd == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            prop.setProperty("user", (String)userName);
            prop.setProperty("password", (String)passwd);
            XAConnection xAConnection = this.getXAConnection(prop);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$1, this, xAConnection);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$1, this, null);
            }
            return xAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public XAConnection getXAConnection(Properties properties) throws SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$2, this, properties);
            }
            if (this.connCachingEnabled) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(163).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            XAConnection xAConnection = (XAConnection)this.getPooledConnection((Properties)prop);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$2, this, xAConnection);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$2, this, null);
            }
            return xAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public XAConnection getXAConnection(OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void builder;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$3, this, oracleXAConnectionBuilderImpl);
            }
            Properties prop = new Properties(this.connectionProperties);
            if (builder.getUser() != null && builder.getPassword() != null) {
                prop.setProperty("user", builder.getUser());
                prop.setProperty("password", builder.getPassword());
            }
            if (builder.getServiceName() != null) {
                prop.setProperty("oracle.jdbc.targetServiceName", builder.getServiceName());
            }
            if (builder.getShardingKey() != null) {
                String b64EncodedShardingKey = builder.getShardingKey().encodeKeyinB64Format();
                prop.setProperty("oracle.jdbc.targetShardingKey", b64EncodedShardingKey);
            }
            if (builder.getSuperShardingKey() != null) {
                String b64EncodedSuperKey = builder.getSuperShardingKey().encodeKeyinB64Format();
                prop.setProperty("oracle.jdbc.targetSuperShardingKey", b64EncodedSuperKey);
            }
            XAConnection xAConnection = (XAConnection)this.getPooledConnection(prop, builder.getGSSCredential());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$3, this, xAConnection);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$3, this, null);
            }
            return xAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleXAConnectionBuilderImpl createXAConnectionBuilder() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$4, this, new Object[0]);
            }
            OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl = new OracleXAConnectionBuilderImpl(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public oracle.jdbc.datasource.OracleXAConnection build() throws SQLException {
                    if (this.gssCredential != null && (this.user != null || this.password != null)) {
                        throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
                    }
                    return (OracleXAConnection)OracleXADataSource.this.getXAConnection(this);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleXADataSource.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$4, this, oracleXAConnectionBuilderImpl);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$4, this, null);
            }
            return oracleXAConnectionBuilderImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PooledConnection getPooledConnection(String string, @Blind String string2) throws SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void passwd;
            void userName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$5, this, string, "*****");
            }
            Properties prop = new Properties();
            prop.setProperty("user", (String)userName);
            prop.setProperty("password", (String)passwd);
            PooledConnection pooledConnection = this.getPooledConnection(prop);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$5, this, pooledConnection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$5, this, null);
            }
            return pooledConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public PooledConnection getPooledConnection(Properties properties) throws SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void info;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$6, this, properties);
            }
            PooledConnection pooledConnection = this.getPooledConnection((Properties)info, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$6, this, pooledConnection);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$6, this, null);
            }
            return pooledConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    PooledConnection getPooledConnection(Properties properties, GSSCredential gSSCredential) throws SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            String superShardingKeyStr;
            String shardingKeyStr;
            String localServiceName;
            String localInstanceName;
            String passwd;
            String userName;
            block79: {
                void gssCredential;
                String url;
                block77: {
                    OracleXAHeteroConnection oracleXAHeteroConnection;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, properties, gSSCredential);
                    }
                    try {
                        int status;
                        Class<OracleXADataSource> clazz;
                        void info;
                        url = this.getURL();
                        userName = info.getProperty("user");
                        passwd = info.getProperty("password");
                        localInstanceName = info.getProperty("oracle.jdbc.targetInstanceName");
                        localServiceName = info.getProperty("oracle.jdbc.targetServiceName");
                        shardingKeyStr = info.getProperty("oracle.jdbc.targetShardingKey");
                        superShardingKeyStr = info.getProperty("oracle.jdbc.targetSuperShardingKey");
                        String rmName = null;
                        String xaclsstr = null;
                        String localXaOpenString = null;
                        int localRmid = 0;
                        if (!this.useNativeXA || !url.startsWith("jdbc:oracle:oci8") && !url.startsWith("jdbc:oracle:oci")) break block77;
                        long[] ociHandles = new long[]{0L, 0L};
                        String tnsentry = null;
                        String propNlsLangBackdoor = null;
                        OracleXADataSource oracleXADataSource = this;
                        // MONITORENTER : oracleXADataSource
                        try {
                            tnsentry = this.tnsEntry != null ? this.tnsEntry : this.getTNSEntryFromUrl(url);
                            if (tnsentry != null && tnsentry.length() == 0 || tnsentry.startsWith("(DESCRIPTION")) {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(207).fillInStackTrace();
                                if (!bl) throw sQLException;
                                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, sQLException);
                                throw sQLException;
                            }
                            if (!libraryLoaded) {
                                clazz = OracleXADataSource.class;
                                // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                                try {
                                    if (!libraryLoaded) {
                                        try {
                                            System.loadLibrary(dllName);
                                            libraryLoaded = true;
                                        }
                                        catch (Error exc) {
                                            if (bl) {
                                                this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "------ JNI JDBC XA lib not loaded properly. ------");
                                            }
                                            libraryLoaded = false;
                                            Error error = exc;
                                            if (!bl) throw error;
                                            ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, error);
                                            throw error;
                                        }
                                    }
                                    // MONITOREXIT : clazz
                                }
                                catch (Throwable throwable) {
                                    // MONITOREXIT : clazz
                                    Throwable throwable2 = throwable;
                                    if (!bl) throw throwable2;
                                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, throwable2);
                                    throw throwable2;
                                }
                            }
                            if (this.connectionProperties != null) {
                                propNlsLangBackdoor = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
                            }
                            // MONITOREXIT : oracleXADataSource
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT : oracleXADataSource
                            Throwable throwable3 = throwable;
                            if (!bl) throw throwable3;
                            ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, throwable3);
                            throw throwable3;
                        }
                        if (propNlsLangBackdoor != null && propNlsLangBackdoor.equalsIgnoreCase("true")) {
                            short driverCharSetId = T2CConnection.getDriverCharSetIdFromNLS_LANG();
                            this.driverCharSetIdString = Integer.toString(driverCharSetId);
                        } else if (!tnsentry.equals(this.oldTnsEntry)) {
                            short driverCharSetId = T2CConnection.getClientCharSetId();
                            this.driverCharSetIdString = Integer.toString(driverCharSetId);
                            this.oldTnsEntry = tnsentry;
                        }
                        OracleXADataSource driverCharSetId = this;
                        // MONITORENTER : driverCharSetId
                        try {
                            rmName = this.databaseName + dbSuffix + rmidSeed;
                            this.rmid = localRmid = rmidSeed;
                            clazz = OracleXADataSource.class;
                            // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                            try {
                                rmidSeed = (rmidSeed + 1) % 65536;
                                // MONITOREXIT : clazz
                            }
                            catch (Throwable throwable) {
                                // MONITOREXIT : clazz
                                Throwable throwable4 = throwable;
                                if (!bl) throw throwable4;
                                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, throwable4);
                                throw throwable4;
                            }
                            int trcLevel = 0;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                block78: {
                                    try {
                                        trcLevel = 7;
                                        if (!bl) break block78;
                                        this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "getXAConnection(user, pwd): trcLevel = " + trcLevel);
                                    }
                                    catch (Throwable throwable) {
                                        OracleLog.recursiveExit();
                                        Throwable throwable5 = throwable;
                                        if (!bl) throw throwable5;
                                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, throwable5);
                                        throw throwable5;
                                    }
                                }
                                OracleLog.recursiveExit();
                            }
                            String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                            this.xaOpenString = localXaOpenString = this.generateXAOpenString(rmName, tnsentry, userName, passwd, 60, 2000, true, true, ".", trcLevel, false, l_xaLoose != null && l_xaLoose.equalsIgnoreCase("true"), this.driverCharSetIdString, this.driverCharSetIdString);
                            xaclsstr = this.generateXACloseString(rmName, false);
                            // MONITOREXIT : driverCharSetId
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT : driverCharSetId
                            Throwable throwable6 = throwable;
                            if (!bl) throw throwable6;
                            ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, throwable6);
                            throw throwable6;
                        }
                        if (bl) {
                            this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "getPooledConnection(user, pwd): before t2cDoXaOpen()");
                        }
                        if ((status = this.t2cDoXaOpen(localXaOpenString, localRmid, 0, 0)) != 0) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, -1 * status).fillInStackTrace();
                            if (!bl) throw sQLException;
                            ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, sQLException);
                            throw sQLException;
                        }
                        if (bl) {
                            this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "getPooledConnection(user, pwd): before t2cConvertOciHandles()");
                        }
                        if ((status = this.t2cConvertOciHandles(rmName, ociHandles)) != 0) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, -1 * status).fillInStackTrace();
                            if (!bl) throw sQLException;
                            ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, sQLException);
                            throw sQLException;
                        }
                        info.put("OCISvcCtxHandle", String.valueOf(ociHandles[0]));
                        info.put("OCIEnvHandle", String.valueOf(ociHandles[1]));
                        info.put("JDBCDriverCharSetId", this.driverCharSetIdString);
                        if (this.loginTimeout != 0) {
                            info.put("oracle.net.CONNECT_TIMEOUT", "" + this.loginTimeout * 1000);
                        }
                        if (bl) {
                            this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "getPooledConnection(user, pwd): before getConnection(url, info)");
                        }
                        Connection conn = this.driver.connect(this.getURL(), (Properties)info);
                        if (this.maxStatementsSet) {
                            ((OracleConnection)conn).setStatementCacheSize(this.maxStatements);
                        }
                        if (this.explicitCachingEnabledSet) {
                            ((OracleConnection)conn).setExplicitCachingEnabled(this.explicitCachingEnabled);
                        }
                        if (this.implicitCachingEnabledSet) {
                            ((OracleConnection)conn).setImplicitCachingEnabled(this.implicitCachingEnabled);
                        }
                        if (this.maxStatements > 0 && !this.explicitCachingEnabled && !this.implicitCachingEnabled) {
                            ((OracleConnection)conn).setImplicitCachingEnabled(true);
                            ((OracleConnection)conn).setExplicitCachingEnabled(true);
                        }
                        OracleXAHeteroConnection xaconn = new OracleXAHeteroConnection(conn);
                        if (userName != null && passwd != null) {
                            xaconn.setUserName(userName, passwd);
                        }
                        xaconn.setRmid(localRmid);
                        xaconn.setXaCloseString(xaclsstr);
                        xaconn.registerCloseCallback(new OracleXAHeteroCloseCallback(), xaconn);
                        oracleXAHeteroConnection = xaconn;
                        if (!bl) return oracleXAHeteroConnection;
                    }
                    catch (XAException xae) {
                        if (bl) {
                            this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "getPooledConnection(user, pwd): XAException at end " + xae);
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xae);
                        if (!bl) throw sQLException;
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, sQLException);
                        throw sQLException;
                    }
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, oracleXAHeteroConnection);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, null);
                    return oracleXAHeteroConnection;
                }
                if (!this.useNativeXA || !url.startsWith("jdbc:oracle:thin")) break block79;
                Properties prop = new Properties();
                OracleXADataSource tnsentry = this;
                // MONITORENTER : tnsentry
                try {
                    Class<OracleXADataSource> propNlsLangBackdoor = OracleXADataSource.class;
                    // MONITORENTER : oracle.jdbc.xa.client.OracleXADataSource.class
                    try {
                        this.rmid = rmidSeed = (rmidSeed + 1) % 65536;
                        // MONITOREXIT : propNlsLangBackdoor
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : propNlsLangBackdoor
                        Throwable throwable7 = throwable;
                        if (!bl) throw throwable7;
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, throwable7);
                        throw throwable7;
                    }
                    if (this.connectionProperties == null) {
                        this.connectionProperties = new Properties();
                    }
                    this.connectionProperties.put("RessourceManagerId", Integer.toString(this.rmid));
                    if (userName != null) {
                        prop.setProperty("user", userName);
                    }
                    if (passwd != null) {
                        prop.setProperty("password", passwd);
                    }
                    if (this.maxStatementsSet) {
                        prop.setProperty("stmt_cache_size", "" + this.maxStatements);
                    }
                    if (this.implicitCachingEnabledSet) {
                        prop.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                    }
                    if (this.explicitCachingEnabledSet) {
                        prop.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                    }
                    if (this.loginTimeout != 0) {
                        prop.setProperty("LoginTimeout", "" + this.loginTimeout);
                    }
                    if (localInstanceName != null) {
                        prop.setProperty("oracle.jdbc.targetInstanceName", localInstanceName);
                    }
                    if (localServiceName != null) {
                        prop.setProperty("oracle.jdbc.targetServiceName", localServiceName);
                    }
                    if (shardingKeyStr != null) {
                        prop.setProperty("oracle.jdbc.targetShardingKey", shardingKeyStr);
                    }
                    if (superShardingKeyStr != null) {
                        prop.setProperty("oracle.jdbc.targetSuperShardingKey", superShardingKeyStr);
                    }
                    // MONITOREXIT : tnsentry
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : tnsentry
                    Throwable throwable8 = throwable;
                    if (!bl) throw throwable8;
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, throwable8);
                    throw throwable8;
                }
                T4CXAConnection conn = new T4CXAConnection(super.getPhysicalConnection(prop, (GSSCredential)gssCredential));
                if (userName != null && passwd != null) {
                    conn.setUserName(userName, passwd);
                }
                String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                conn.isXAResourceTransLoose = l_xaLoose != null && (l_xaLoose.equals("true") || l_xaLoose.equalsIgnoreCase("true"));
                T4CXAConnection t4CXAConnection = conn;
                if (!bl) return t4CXAConnection;
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, t4CXAConnection);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, null);
                return t4CXAConnection;
            }
            if (bl) {
                this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "OracleXADataSource.getPooledConnection(user, pwd) return: non-oci");
            }
            Properties prop = new Properties();
            OracleXADataSource conn = this;
            // MONITORENTER : conn
            try {
                if (userName != null) {
                    prop.setProperty("user", userName);
                }
                if (passwd != null) {
                    prop.setProperty("password", passwd);
                }
                if (this.maxStatementsSet) {
                    prop.setProperty("stmt_cache_size", "" + this.maxStatements);
                }
                if (this.implicitCachingEnabledSet) {
                    prop.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                }
                if (this.explicitCachingEnabledSet) {
                    prop.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                }
                if (this.loginTimeout != 0) {
                    prop.setProperty("LoginTimeout", "" + this.loginTimeout);
                }
                if (localInstanceName != null) {
                    prop.setProperty("oracle.jdbc.targetInstanceName", localInstanceName);
                }
                if (localServiceName != null) {
                    prop.setProperty("oracle.jdbc.targetServiceName", localServiceName);
                }
                if (shardingKeyStr != null) {
                    prop.setProperty("oracle.jdbc.targetShardingKey", shardingKeyStr);
                }
                if (superShardingKeyStr != null) {
                    prop.setProperty("oracle.jdbc.targetSuperShardingKey", superShardingKeyStr);
                }
                // MONITOREXIT : conn
            }
            catch (Throwable throwable) {
                // MONITOREXIT : conn
                Throwable throwable9 = throwable;
                if (!bl) throw throwable9;
                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, throwable9);
                throw throwable9;
            }
            OracleXAConnection l_xaconn = new OracleXAConnection(super.getPhysicalConnection(prop, null));
            if (userName != null && passwd != null) {
                l_xaconn.setUserName(userName, passwd);
            }
            String l_xaLoose = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
            l_xaconn.isXAResourceTransLoose = l_xaLoose != null && (l_xaLoose.equals("true") || l_xaLoose.equalsIgnoreCase("true"));
            OracleXAConnection oracleXAConnection = l_xaconn;
            if (!bl) return oracleXAConnection;
            ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, oracleXAConnection);
            ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, null);
            return oracleXAConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable10 = throwable;
            if (!bl) throw throwable;
            ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$7, this, throwable10);
            throw throwable;
        }
    }

    private native int t2cDoXaOpen(String var1, int var2, int var3, int var4);

    private native int t2cConvertOciHandles(String var1, long[] var2);

    /*
     * WARNING - void declaration
     */
    synchronized void setRmid(int n2) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rmid;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, n2);
            }
            this.rmid = rmid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized int getRmid() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$9, this, new Object[0]);
            }
            int n2 = this.rmid;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$9, this, n2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$9, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setXaOpenString(String string) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void xaOpenString;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$10, this, string);
            }
            this.xaOpenString = xaOpenString;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized String getXaOpenString() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$11, this, new Object[0]);
            }
            String string = this.xaOpenString;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$11, this, string);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$11, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Blind
    private String generateXAOpenString(String string, String string2, String string3, @Blind String string4, int n2, int n3, boolean bl, boolean bl2, String string5, int n4, boolean bl3, boolean bl4, String string6, String string7) {
        boolean bl5 = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dbNCharCsId;
            void dbCsId;
            void isLoose;
            void cacheFlag;
            void traceLevel;
            void objectFlag;
            void threadFlag;
            void connectString;
            void logDir;
            void lockTimeout;
            void sessionTimeout;
            void passwd;
            void userName;
            void rmName;
            if (bl5) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$12, this, string, string2, string3, "*****", n2, n3, bl, bl2, string5, n4, bl3, bl4, string6, string7);
            }
            String string8 = "ORACLE_XA+DB=" + (String)rmName + "+ACC=P/" + (String)userName + "/" + (String)passwd + "+SESTM=" + (int)sessionTimeout + "+SESWT=" + (int)lockTimeout + "+LOGDIR=" + (String)logDir + "+SQLNET=" + (String)connectString + (threadFlag != false ? "+THREADS=true" : "") + (objectFlag != false ? "+OBJECTS=true" : "") + "+DBGFL=0x" + (int)traceLevel + (cacheFlag != false ? "+CONNCACHE=t" : "+CONNCACHE=f") + (isLoose != false ? "+Loose_Coupling=t" : "") + "+CharSet=" + (String)dbCsId + "+NCharSet=" + (String)dbNCharCsId;
            if (bl5) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$12, this, "******");
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$12, this, null);
            }
            return string8;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl5) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String generateXACloseString(String string, boolean bl) {
        boolean bl2 = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cacheFlag;
            void rmName;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$13, this, string, bl);
            }
            String string2 = "ORACLE_XA+DB=" + (String)rmName + (cacheFlag != false ? "+CONNCACHE=t" : "+CONNCACHE=f");
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$13, this, string2);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$13, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getTNSEntryFromUrl(String string) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            void url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$14, this, string);
            }
            int at_sign = url.indexOf(64);
            String string2 = url.substring(at_sign + 1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$14, this, string2);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$14, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    private static Logger logger() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$15, null, new Object[0]);
            }
            if (LOGGER == null) {
                LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
            }
            Logger logger = LOGGER;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$15, null, logger);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$15, null, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleXADataSource.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$17 = OracleXADataSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleXADataSource.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleXADataSource.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleXADataSource.class.getDeclaredMethod("getTNSEntryFromUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleXADataSource.class.getDeclaredMethod("generateXACloseString", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleXADataSource.class.getDeclaredMethod("generateXAOpenString", String.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleXADataSource.class.getDeclaredMethod("getXaOpenString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleXADataSource.class.getDeclaredMethod("setXaOpenString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleXADataSource.class.getDeclaredMethod("getRmid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleXADataSource.class.getDeclaredMethod("setRmid", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", Properties.class, GSSCredential.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleXADataSource.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", OracleXAConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        libraryLoaded = false;
        rmidSeed = 0;
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXADataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

