/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.TNSAddress.AddressList;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;

public class NavAddressList
extends AddressList
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int sBuflength;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    public NavAddressList(SchemaObjectFactoryInterface fac) {
        super(fac);
    }

    @Override
    public void navigate(ConnStrategy cs, StringBuffer sBuf) {
        this.navigate2(cs, sBuf, 0);
    }

    private void navigate2(ConnStrategy cs, StringBuffer sBuf, int reCurCnt) {
        int i2;
        boolean nested = false;
        ++reCurCnt;
        this.sBuflength = sBuf.length();
        sBuf.append("(ADDRESS_LIST=");
        if (this.sourceRoute) {
            this.activeChildren = this.children;
            ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(cs, sBuf);
            for (i2 = 1; i2 < this.activeChildren.size(); ++i2) {
                ((NavSchemaObject)this.activeChildren.elementAt(i2)).addToString(cs);
            }
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            for (i2 = 0; i2 < this.activeChildren.size(); ++i2) {
                if (this.getChildrenType(i2) == 1) {
                    nested = true;
                    ((NavAddressList)this.activeChildren.elementAt(i2)).navigate2(cs, sBuf, reCurCnt);
                    continue;
                }
                ((NavSchemaObject)this.activeChildren.elementAt(i2)).navigate(cs, sBuf);
            }
        }
        if (!(--reCurCnt == 0 && nested || this.sourceRoute)) {
            this.closeNVPair(cs, false);
        } else {
            this.closeNVPair(cs, true);
        }
        sBuf.setLength(this.sBuflength);
        if (this.loadBalance) {
            cs.addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF();
        }
    }

    @Override
    public void addToString(ConnStrategy cs) {
        String NVString = this.toString();
        ArrayList<ConnOption> cOpts = cs.currentDescription().getConnectOptions();
        for (ConnOption co : cOpts) {
            if (co.done) continue;
            co.conn_data.append(NVString);
        }
    }

    @Override
    @DisableTrace
    public String toString() {
        String s2 = "";
        s2 = s2 + "(ADDRESS_LIST=";
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            s2 = s2 + ((NavSchemaObject)this.children.elementAt(i2)).toString();
        }
        if (this.sourceRoute) {
            s2 = s2 + "(SOURCE_ROUTE=yes)(HOP_COUNT=0)";
        }
        if (this.loadBalance) {
            s2 = s2 + "(LOAD_BALANCE=yes)";
        }
        if (!this.failover) {
            s2 = s2 + "(FAILOVER=false)";
        }
        s2 = s2 + ")";
        return s2;
    }

    public int getChildrenSize() {
        return this.children.size();
    }

    public int getChildrenType(int childNum) {
        return ((NavSchemaObject)this.children.elementAt(childNum)).isA();
    }

    public NavAddress getChild(int childNum) {
        return (NavAddress)this.children.elementAt(childNum);
    }

    private void closeNVPair(ConnStrategy cs, boolean mode) {
        ArrayList<ConnOption> cOpts = cs.currentDescription().getConnectOptions();
        for (int i2 = cOpts.size() - 1; i2 >= 0 && !cOpts.get((int)i2).done && (mode || cOpts.size() - 1 - i2 < this.getChildrenSize()); --i2) {
            if (this.sourceRoute) {
                cOpts.get((int)i2).conn_data.append("(SOURCE_ROUTE=yes)");
                cOpts.get((int)i2).conn_data.append("(HOP_COUNT=0)");
            }
            cOpts.get((int)i2).conn_data.append(")");
        }
    }

    static {
        try {
            $$$methodRef$$$7 = NavAddressList.class.getDeclaredConstructor(SchemaObjectFactoryInterface.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NavAddressList.class.getDeclaredMethod("closeNVPair", ConnStrategy.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NavAddressList.class.getDeclaredMethod("getChild", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NavAddressList.class.getDeclaredMethod("getChildrenType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NavAddressList.class.getDeclaredMethod("getChildrenSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NavAddressList.class.getDeclaredMethod("addToString", ConnStrategy.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NavAddressList.class.getDeclaredMethod("navigate2", ConnStrategy.class, StringBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NavAddressList.class.getDeclaredMethod("navigate", ConnStrategy.class, StringBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

