package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

/**
 * Event produced after <code>docker-compose pull</code>.
 */
@JsonDeserialize(builder = PullEvent.Builder.class)
@Generated("com.palantir.conjure.java.types.BeanGenerator")
public final class PullEvent {
    private final Task task;

    private PullEvent(Task task) {
        validateFields(task);
        this.task = task;
    }

    @JsonProperty("task")
    public Task getTask() {
        return this.task;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || (other instanceof PullEvent && equalTo((PullEvent) other));
    }

    private boolean equalTo(PullEvent other) {
        return this.task.equals(other.task);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.task);
    }

    @Override
    public String toString() {
        return "PullEvent{task: " + task + '}';
    }

    public static PullEvent of(Task task) {
        return builder().task(task).build();
    }

    private static void validateFields(Task task) {
        List<String> missingFields = null;
        missingFields = addFieldIfMissing(missingFields, task, "task");
        if (missingFields != null) {
            throw new SafeIllegalArgumentException(
                    "Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated("com.palantir.conjure.java.types.BeanBuilderGenerator")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Task task;

        private Builder() {}

        public Builder from(PullEvent other) {
            task(other.getTask());
            return this;
        }

        @JsonSetter("task")
        public Builder task(@Nonnull Task task) {
            this.task = Preconditions.checkNotNull(task, "task cannot be null");
            return this;
        }

        public PullEvent build() {
            return new PullEvent(task);
        }
    }
}
