/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.docker.compose.events.BuildEvent;
import com.palantir.docker.compose.events.ClusterWaitEvent;
import com.palantir.docker.compose.events.LogCollectionEvent;
import com.palantir.docker.compose.events.PullEvent;
import com.palantir.docker.compose.events.ShutdownEvent;
import com.palantir.docker.compose.events.ShutdownStopEvent;
import com.palantir.docker.compose.events.UpEvent;
import com.palantir.docker.compose.events.WaitForServicesEvent;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class Event {
    private final Base value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private Event(Base value) {
        this.value = value;
    }

    @JsonValue
    private Base getValue() {
        return this.value;
    }

    public static Event build(BuildEvent value) {
        return new Event(new BuildWrapper(value));
    }

    public static Event pull(PullEvent value) {
        return new Event(new PullWrapper(value));
    }

    public static Event up(UpEvent value) {
        return new Event(new UpWrapper(value));
    }

    public static Event waitForServices(WaitForServicesEvent value) {
        return new Event(new WaitForServicesWrapper(value));
    }

    public static Event clusterWait(ClusterWaitEvent value) {
        return new Event(new ClusterWaitWrapper(value));
    }

    public static Event shutdownStop(ShutdownStopEvent value) {
        return new Event(new ShutdownStopWrapper(value));
    }

    public static Event logCollection(LogCollectionEvent value) {
        return new Event(new LogCollectionWrapper(value));
    }

    public static Event shutdown(ShutdownEvent value) {
        return new Event(new ShutdownWrapper(value));
    }

    public <T> T accept(Visitor<T> visitor) {
        return this.value.accept(visitor);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Event && this.equalTo((Event)other);
    }

    private boolean equalTo(Event other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return "Event{value: " + this.value + '}';
    }

    private static final class UnknownWrapper
    implements Base {
        private final String type;
        private final Map<String, Object> value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UnknownWrapper(@JsonProperty(value="type") String type) {
            this(type, new HashMap<String, Object>());
        }

        private UnknownWrapper(@Nonnull String type, @Nonnull Map<String, Object> value) {
            Preconditions.checkNotNull((Object)type, (String)"type cannot be null");
            Preconditions.checkNotNull(value, (String)"value cannot be null");
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        private String getType() {
            return this.type;
        }

        @JsonAnyGetter
        private Map<String, Object> getValue() {
            return this.value;
        }

        @JsonAnySetter
        private void put(String key, Object val) {
            this.value.put(key, val);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUnknown(this.type);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof UnknownWrapper && this.equalTo((UnknownWrapper)other);
        }

        private boolean equalTo(UnknownWrapper other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "UnknownWrapper{type: " + this.type + ", value: " + this.value + '}';
        }
    }

    @JsonTypeName(value="shutdown")
    private static final class ShutdownWrapper
    implements Base {
        private final ShutdownEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ShutdownWrapper(@JsonSetter(value="shutdown") @Nonnull ShutdownEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"shutdown cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "shutdown";
        }

        @JsonProperty(value="shutdown")
        private ShutdownEvent getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitShutdown(this.value);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ShutdownWrapper && this.equalTo((ShutdownWrapper)other);
        }

        private boolean equalTo(ShutdownWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return "ShutdownWrapper{value: " + this.value + '}';
        }
    }

    @JsonTypeName(value="logCollection")
    private static final class LogCollectionWrapper
    implements Base {
        private final LogCollectionEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private LogCollectionWrapper(@JsonSetter(value="logCollection") @Nonnull LogCollectionEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"logCollection cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "logCollection";
        }

        @JsonProperty(value="logCollection")
        private LogCollectionEvent getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitLogCollection(this.value);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof LogCollectionWrapper && this.equalTo((LogCollectionWrapper)other);
        }

        private boolean equalTo(LogCollectionWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return "LogCollectionWrapper{value: " + this.value + '}';
        }
    }

    @JsonTypeName(value="shutdownStop")
    private static final class ShutdownStopWrapper
    implements Base {
        private final ShutdownStopEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ShutdownStopWrapper(@JsonSetter(value="shutdownStop") @Nonnull ShutdownStopEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"shutdownStop cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "shutdownStop";
        }

        @JsonProperty(value="shutdownStop")
        private ShutdownStopEvent getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitShutdownStop(this.value);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ShutdownStopWrapper && this.equalTo((ShutdownStopWrapper)other);
        }

        private boolean equalTo(ShutdownStopWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return "ShutdownStopWrapper{value: " + this.value + '}';
        }
    }

    @JsonTypeName(value="clusterWait")
    private static final class ClusterWaitWrapper
    implements Base {
        private final ClusterWaitEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ClusterWaitWrapper(@JsonSetter(value="clusterWait") @Nonnull ClusterWaitEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"clusterWait cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "clusterWait";
        }

        @JsonProperty(value="clusterWait")
        private ClusterWaitEvent getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitClusterWait(this.value);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ClusterWaitWrapper && this.equalTo((ClusterWaitWrapper)other);
        }

        private boolean equalTo(ClusterWaitWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return "ClusterWaitWrapper{value: " + this.value + '}';
        }
    }

    @JsonTypeName(value="waitForServices")
    private static final class WaitForServicesWrapper
    implements Base {
        private final WaitForServicesEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private WaitForServicesWrapper(@JsonSetter(value="waitForServices") @Nonnull WaitForServicesEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"waitForServices cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "waitForServices";
        }

        @JsonProperty(value="waitForServices")
        private WaitForServicesEvent getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitWaitForServices(this.value);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof WaitForServicesWrapper && this.equalTo((WaitForServicesWrapper)other);
        }

        private boolean equalTo(WaitForServicesWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return "WaitForServicesWrapper{value: " + this.value + '}';
        }
    }

    @JsonTypeName(value="up")
    private static final class UpWrapper
    implements Base {
        private final UpEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UpWrapper(@JsonSetter(value="up") @Nonnull UpEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"up cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "up";
        }

        @JsonProperty(value="up")
        private UpEvent getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUp(this.value);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof UpWrapper && this.equalTo((UpWrapper)other);
        }

        private boolean equalTo(UpWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return "UpWrapper{value: " + this.value + '}';
        }
    }

    @JsonTypeName(value="pull")
    private static final class PullWrapper
    implements Base {
        private final PullEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private PullWrapper(@JsonSetter(value="pull") @Nonnull PullEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"pull cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "pull";
        }

        @JsonProperty(value="pull")
        private PullEvent getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitPull(this.value);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof PullWrapper && this.equalTo((PullWrapper)other);
        }

        private boolean equalTo(PullWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return "PullWrapper{value: " + this.value + '}';
        }
    }

    @JsonTypeName(value="build")
    private static final class BuildWrapper
    implements Base {
        private final BuildEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private BuildWrapper(@JsonSetter(value="build") @Nonnull BuildEvent value) {
            Preconditions.checkNotNull((Object)value, (String)"build cannot be null");
            this.value = value;
        }

        @JsonProperty(value="type", index=0)
        private String getType() {
            return "build";
        }

        @JsonProperty(value="build")
        private BuildEvent getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitBuild(this.value);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof BuildWrapper && this.equalTo((BuildWrapper)other);
        }

        private boolean equalTo(BuildWrapper other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return "BuildWrapper{value: " + this.value + '}';
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=UnknownWrapper.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=BuildWrapper.class), @JsonSubTypes.Type(value=PullWrapper.class), @JsonSubTypes.Type(value=UpWrapper.class), @JsonSubTypes.Type(value=WaitForServicesWrapper.class), @JsonSubTypes.Type(value=ClusterWaitWrapper.class), @JsonSubTypes.Type(value=ShutdownStopWrapper.class), @JsonSubTypes.Type(value=LogCollectionWrapper.class), @JsonSubTypes.Type(value=ShutdownWrapper.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Base {
        public <T> T accept(Visitor<T> var1);
    }

    public static interface Completed_StageVisitorBuilder<T> {
        public Visitor<T> build();
    }

    public static interface UnknownStageVisitorBuilder<T> {
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> var1);

        public Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public static interface WaitForServicesStageVisitorBuilder<T> {
        public UnknownStageVisitorBuilder<T> waitForServices(@Nonnull Function<WaitForServicesEvent, T> var1);
    }

    public static interface UpStageVisitorBuilder<T> {
        public WaitForServicesStageVisitorBuilder<T> up(@Nonnull Function<UpEvent, T> var1);
    }

    public static interface ShutdownStopStageVisitorBuilder<T> {
        public UpStageVisitorBuilder<T> shutdownStop(@Nonnull Function<ShutdownStopEvent, T> var1);
    }

    public static interface ShutdownStageVisitorBuilder<T> {
        public ShutdownStopStageVisitorBuilder<T> shutdown(@Nonnull Function<ShutdownEvent, T> var1);
    }

    public static interface PullStageVisitorBuilder<T> {
        public ShutdownStageVisitorBuilder<T> pull(@Nonnull Function<PullEvent, T> var1);
    }

    public static interface LogCollectionStageVisitorBuilder<T> {
        public PullStageVisitorBuilder<T> logCollection(@Nonnull Function<LogCollectionEvent, T> var1);
    }

    public static interface ClusterWaitStageVisitorBuilder<T> {
        public LogCollectionStageVisitorBuilder<T> clusterWait(@Nonnull Function<ClusterWaitEvent, T> var1);
    }

    public static interface BuildStageVisitorBuilder<T> {
        public ClusterWaitStageVisitorBuilder<T> build(@Nonnull Function<BuildEvent, T> var1);
    }

    private static final class VisitorBuilder<T>
    implements BuildStageVisitorBuilder<T>,
    ClusterWaitStageVisitorBuilder<T>,
    LogCollectionStageVisitorBuilder<T>,
    PullStageVisitorBuilder<T>,
    ShutdownStageVisitorBuilder<T>,
    ShutdownStopStageVisitorBuilder<T>,
    UpStageVisitorBuilder<T>,
    WaitForServicesStageVisitorBuilder<T>,
    UnknownStageVisitorBuilder<T>,
    Completed_StageVisitorBuilder<T> {
        private Function<BuildEvent, T> buildVisitor;
        private Function<ClusterWaitEvent, T> clusterWaitVisitor;
        private Function<LogCollectionEvent, T> logCollectionVisitor;
        private Function<PullEvent, T> pullVisitor;
        private Function<ShutdownEvent, T> shutdownVisitor;
        private Function<ShutdownStopEvent, T> shutdownStopVisitor;
        private Function<UpEvent, T> upVisitor;
        private Function<WaitForServicesEvent, T> waitForServicesVisitor;
        private Function<String, T> unknownVisitor;

        private VisitorBuilder() {
        }

        @Override
        public ClusterWaitStageVisitorBuilder<T> build(@Nonnull Function<BuildEvent, T> buildVisitor) {
            Preconditions.checkNotNull(buildVisitor, (String)"buildVisitor cannot be null");
            this.buildVisitor = buildVisitor;
            return this;
        }

        @Override
        public LogCollectionStageVisitorBuilder<T> clusterWait(@Nonnull Function<ClusterWaitEvent, T> clusterWaitVisitor) {
            Preconditions.checkNotNull(clusterWaitVisitor, (String)"clusterWaitVisitor cannot be null");
            this.clusterWaitVisitor = clusterWaitVisitor;
            return this;
        }

        @Override
        public PullStageVisitorBuilder<T> logCollection(@Nonnull Function<LogCollectionEvent, T> logCollectionVisitor) {
            Preconditions.checkNotNull(logCollectionVisitor, (String)"logCollectionVisitor cannot be null");
            this.logCollectionVisitor = logCollectionVisitor;
            return this;
        }

        @Override
        public ShutdownStageVisitorBuilder<T> pull(@Nonnull Function<PullEvent, T> pullVisitor) {
            Preconditions.checkNotNull(pullVisitor, (String)"pullVisitor cannot be null");
            this.pullVisitor = pullVisitor;
            return this;
        }

        @Override
        public ShutdownStopStageVisitorBuilder<T> shutdown(@Nonnull Function<ShutdownEvent, T> shutdownVisitor) {
            Preconditions.checkNotNull(shutdownVisitor, (String)"shutdownVisitor cannot be null");
            this.shutdownVisitor = shutdownVisitor;
            return this;
        }

        @Override
        public UpStageVisitorBuilder<T> shutdownStop(@Nonnull Function<ShutdownStopEvent, T> shutdownStopVisitor) {
            Preconditions.checkNotNull(shutdownStopVisitor, (String)"shutdownStopVisitor cannot be null");
            this.shutdownStopVisitor = shutdownStopVisitor;
            return this;
        }

        @Override
        public WaitForServicesStageVisitorBuilder<T> up(@Nonnull Function<UpEvent, T> upVisitor) {
            Preconditions.checkNotNull(upVisitor, (String)"upVisitor cannot be null");
            this.upVisitor = upVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> waitForServices(@Nonnull Function<WaitForServicesEvent, T> waitForServicesVisitor) {
            Preconditions.checkNotNull(waitForServicesVisitor, (String)"waitForServicesVisitor cannot be null");
            this.waitForServicesVisitor = waitForServicesVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, (String)"unknownVisitor cannot be null");
            this.unknownVisitor = unknownVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException("Unknown variant of the 'Event' union", new Arg[]{SafeArg.of((String)"unknownType", (Object)unknownType)});
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Function<BuildEvent, T> buildVisitor = this.buildVisitor;
            final Function<ClusterWaitEvent, T> clusterWaitVisitor = this.clusterWaitVisitor;
            final Function<LogCollectionEvent, T> logCollectionVisitor = this.logCollectionVisitor;
            final Function<PullEvent, T> pullVisitor = this.pullVisitor;
            final Function<ShutdownEvent, T> shutdownVisitor = this.shutdownVisitor;
            final Function<ShutdownStopEvent, T> shutdownStopVisitor = this.shutdownStopVisitor;
            final Function<UpEvent, T> upVisitor = this.upVisitor;
            final Function<WaitForServicesEvent, T> waitForServicesVisitor = this.waitForServicesVisitor;
            final Function<String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>(){

                @Override
                public T visitBuild(BuildEvent value) {
                    return buildVisitor.apply(value);
                }

                @Override
                public T visitClusterWait(ClusterWaitEvent value) {
                    return clusterWaitVisitor.apply(value);
                }

                @Override
                public T visitLogCollection(LogCollectionEvent value) {
                    return logCollectionVisitor.apply(value);
                }

                @Override
                public T visitPull(PullEvent value) {
                    return pullVisitor.apply(value);
                }

                @Override
                public T visitShutdown(ShutdownEvent value) {
                    return shutdownVisitor.apply(value);
                }

                @Override
                public T visitShutdownStop(ShutdownStopEvent value) {
                    return shutdownStopVisitor.apply(value);
                }

                @Override
                public T visitUp(UpEvent value) {
                    return upVisitor.apply(value);
                }

                @Override
                public T visitWaitForServices(WaitForServicesEvent value) {
                    return waitForServicesVisitor.apply(value);
                }

                @Override
                public T visitUnknown(String value) {
                    return unknownVisitor.apply(value);
                }
            };
        }
    }

    public static interface Visitor<T> {
        public T visitBuild(BuildEvent var1);

        public T visitPull(PullEvent var1);

        public T visitUp(UpEvent var1);

        public T visitWaitForServices(WaitForServicesEvent var1);

        public T visitClusterWait(ClusterWaitEvent var1);

        public T visitShutdownStop(ShutdownStopEvent var1);

        public T visitLogCollection(LogCollectionEvent var1);

        public T visitShutdown(ShutdownEvent var1);

        public T visitUnknown(String var1);

        public static <T> BuildStageVisitorBuilder<T> builder() {
            return new VisitorBuilder();
        }
    }
}

