/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.palantir.javaformat.BreakBehaviour;
import com.palantir.javaformat.BreakBehaviours;
import com.palantir.javaformat.ImmutableOpenOp;
import com.palantir.javaformat.Indent;
import com.palantir.javaformat.LastLevelBreakability;
import com.palantir.javaformat.Op;
import com.palantir.javaformat.PartialInlineability;
import com.palantir.javaformat.doc.DocBuilder;
import com.palantir.javaformat.doc.HasUniqueId;
import java.util.Optional;
import java.util.OptionalInt;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableOpenOp.class)
@Value.Immutable
public abstract class OpenOp
extends HasUniqueId
implements Op {
    public abstract Indent plusIndent();

    @Value.Default
    public BreakBehaviour breakBehaviour() {
        return BreakBehaviours.breakThisLevel();
    }

    @Value.Default
    public LastLevelBreakability breakabilityIfLastLevel() {
        return LastLevelBreakability.ABORT;
    }

    @Value.Default
    public PartialInlineability partialInlineability() {
        return PartialInlineability.ALWAYS_PARTIALLY_INLINEABLE;
    }

    @Value.Default
    public Complexity complexity() {
        return Complexity.SIMPLE;
    }

    public abstract Optional<String> debugName();

    public abstract OptionalInt columnLimitBeforeLastBreak();

    public static Op make(Indent plusIndent) {
        return OpenOp.builder().plusIndent(plusIndent).build();
    }

    @Override
    public void add(DocBuilder builder) {
        builder.open(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableOpenOp.Builder {
        public Builder isSimple(boolean isSimple) {
            return this.complexity(isSimple ? Complexity.SIMPLE : Complexity.COMPLEX);
        }
    }

    public static enum Complexity {
        SIMPLE,
        COMPLEX;

    }
}

