/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java.javadoc;

import com.google.common.collect.ImmutableList;
import com.palantir.javaformat.java.javadoc.JavadocLexer;
import com.palantir.javaformat.java.javadoc.JavadocWriter;
import com.palantir.javaformat.java.javadoc.Token;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavadocFormatter {
    private final int maxLineLength;
    private static final Token STANDARD_BR_TOKEN = new Token(Token.Type.BR_TAG, "<br>");
    private static final Token STANDARD_P_TOKEN = new Token(Token.Type.PARAGRAPH_OPEN_TAG, "<p>");
    private static final Pattern SIMPLE_TAG_PATTERN = Pattern.compile("^<\\w+\\s*/?\\s*>", 2);
    private static final Pattern ONE_CONTENT_LINE_PATTERN = Pattern.compile(" */[*][*]\n *[*] (.*)\n *[*]/");

    public JavadocFormatter(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public String formatJavadoc(String input, int blockIndent) {
        ImmutableList<Token> tokens;
        try {
            tokens = JavadocLexer.lex(input);
        }
        catch (JavadocLexer.LexException e) {
            return input;
        }
        String result = this.render((List<Token>)tokens, blockIndent);
        return this.makeSingleLineIfPossible(blockIndent, result);
    }

    private String render(List<Token> input, int blockIndent) {
        JavadocWriter output = new JavadocWriter(blockIndent, this.maxLineLength);
        block26: for (Token token : input) {
            switch (token.getType()) {
                case BEGIN_JAVADOC: {
                    output.writeBeginJavadoc();
                    continue block26;
                }
                case END_JAVADOC: {
                    output.writeEndJavadoc();
                    return output.toString();
                }
                case FOOTER_JAVADOC_TAG_START: {
                    output.writeFooterJavadocTagStart(token);
                    continue block26;
                }
                case LIST_OPEN_TAG: {
                    output.writeListOpen(token);
                    continue block26;
                }
                case LIST_CLOSE_TAG: {
                    output.writeListClose(token);
                    continue block26;
                }
                case LIST_ITEM_OPEN_TAG: {
                    output.writeListItemOpen(token);
                    continue block26;
                }
                case HEADER_OPEN_TAG: {
                    output.writeHeaderOpen(token);
                    continue block26;
                }
                case HEADER_CLOSE_TAG: {
                    output.writeHeaderClose(token);
                    continue block26;
                }
                case PARAGRAPH_OPEN_TAG: {
                    output.writeParagraphOpen(JavadocFormatter.standardizePToken(token));
                    continue block26;
                }
                case BLOCKQUOTE_OPEN_TAG: 
                case BLOCKQUOTE_CLOSE_TAG: {
                    output.writeBlockquoteOpenOrClose(token);
                    continue block26;
                }
                case PRE_OPEN_TAG: {
                    output.writePreOpen(token);
                    continue block26;
                }
                case PRE_CLOSE_TAG: {
                    output.writePreClose(token);
                    continue block26;
                }
                case CODE_OPEN_TAG: {
                    output.writeCodeOpen(token);
                    continue block26;
                }
                case CODE_CLOSE_TAG: {
                    output.writeCodeClose(token);
                    continue block26;
                }
                case TABLE_OPEN_TAG: {
                    output.writeTableOpen(token);
                    continue block26;
                }
                case TABLE_CLOSE_TAG: {
                    output.writeTableClose(token);
                    continue block26;
                }
                case MOE_BEGIN_STRIP_COMMENT: {
                    output.requestMoeBeginStripComment(token);
                    continue block26;
                }
                case MOE_END_STRIP_COMMENT: {
                    output.writeMoeEndStripComment(token);
                    continue block26;
                }
                case HTML_COMMENT: {
                    output.writeHtmlComment(token);
                    continue block26;
                }
                case BR_TAG: {
                    output.writeBr(JavadocFormatter.standardizeBrToken(token));
                    continue block26;
                }
                case WHITESPACE: {
                    output.requestWhitespace();
                    continue block26;
                }
                case FORCED_NEWLINE: {
                    output.writeLineBreakNoAutoIndent();
                    continue block26;
                }
                case LITERAL: 
                case INLINE_TAG_OPEN: 
                case INLINE_TAG_CLOSE: {
                    output.writeLiteral(token);
                    continue block26;
                }
                case PARAGRAPH_CLOSE_TAG: 
                case LIST_ITEM_CLOSE_TAG: 
                case OPTIONAL_LINE_BREAK: {
                    continue block26;
                }
            }
            throw new AssertionError((Object)token.getType());
        }
        throw new IllegalStateException();
    }

    private static Token standardizeBrToken(Token token) {
        return JavadocFormatter.standardize(token, STANDARD_BR_TOKEN);
    }

    private static Token standardizePToken(Token token) {
        return JavadocFormatter.standardize(token, STANDARD_P_TOKEN);
    }

    private static Token standardize(Token token, Token standardToken) {
        return SIMPLE_TAG_PATTERN.matcher(token.getValue()).matches() ? standardToken : token;
    }

    private String makeSingleLineIfPossible(int blockIndent, String input) {
        int oneLinerContentLength = this.maxLineLength - "/**  */".length() - blockIndent;
        Matcher matcher = ONE_CONTENT_LINE_PATTERN.matcher(input);
        if (matcher.matches() && matcher.group(1).isEmpty()) {
            return "/** */";
        }
        if (matcher.matches() && matcher.group(1).length() <= oneLinerContentLength) {
            return "/** " + matcher.group(1) + " */";
        }
        return input;
    }
}

