/*
 * Decompiled with CFR 0.152.
 */
package com.paulhammant.ngwebdriver;

import com.paulhammant.ngwebdriver.ByAngular;
import com.paulhammant.ngwebdriver.ByAngularRepeaterCell;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.AbstractFindByBuilder;
import org.openqa.selenium.support.PageFactoryFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByAngularRepeaterRow
extends ByAngular.BaseBy {
    private final String repeater;
    private boolean exact;
    private final int row;

    public ByAngularRepeaterRow(String rootSelector, String repeater, boolean exact, int row) {
        super(rootSelector);
        this.repeater = repeater;
        this.exact = exact;
        this.row = row;
    }

    public ByAngularRepeaterCell column(String column) {
        return new ByAngularRepeaterCell(this.rootSelector, this.repeater, this.exact, this.row, column);
    }

    @Override
    protected Object getObject(SearchContext context, JavascriptExecutor javascriptExecutor) {
        return javascriptExecutor.executeScript("var using = arguments[0] || document;\nvar rootSelector = '" + this.rootSelector + "';\nvar repeater = '" + this.repeater.replace("'", "\\'") + "';\nvar index = " + this.row + ";\nvar exact = " + this.exact + ";\n\n" + ByAngular.functions.get("findRepeaterRows"), new Object[]{context});
    }

    @Override
    public List<WebElement> findElements(SearchContext searchContext) {
        throw new UnsupportedOperationException("This locator zooms in on a single row, findElements() is meaningless");
    }

    public String toString() {
        return (this.exact ? "exactR" : "r") + "epeater(" + this.repeater + ").row(" + this.row + ")";
    }

    public static class NgFindByBuilder
    extends AbstractFindByBuilder {
        public By buildIt(Object annotation, Field field) {
            FindBy findBy = (FindBy)annotation;
            return new ByAngularRepeaterRow(findBy.rootSelector(), findBy.repeater(), findBy.exact(), findBy.row());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @PageFactoryFinder(value=NgFindByBuilder.class)
    public static @interface FindBy {
        public String rootSelector() default "[ng-app]";

        public String repeater();

        public boolean exact();

        public int row();
    }
}

