/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.OffsetIndexItem;
import com.pff.PSTDescriptorItem;
import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedList;

public class PSTNodeInputStream
extends InputStream {
    private RandomAccessFile in;
    private PSTFile pstFile;
    private LinkedList<Long> skipPoints = new LinkedList();
    private LinkedList<OffsetIndexItem> indexItems = new LinkedList();
    private int currentBlock = 0;
    private long currentLocation = 0L;
    private byte[] allData = null;
    private long length = 0L;
    private boolean encrypted = false;
    private int totalLoopCount = 0;

    PSTNodeInputStream(PSTFile pstFile, byte[] attachmentData) {
        this.allData = attachmentData;
        this.length = this.allData.length;
        this.encrypted = pstFile.getEncryptionType() == 1;
        this.currentBlock = 0;
        this.currentLocation = 0L;
    }

    PSTNodeInputStream(PSTFile pstFile, PSTDescriptorItem descriptorItem) throws IOException, PSTException {
        this.in = pstFile.getFileHandle();
        this.pstFile = pstFile;
        this.encrypted = pstFile.getEncryptionType() == 1;
        OffsetIndexItem offsetItem = pstFile.getOffsetIndexNode(descriptorItem.offsetIndexIdentifier);
        this.loadFromOffsetItem(offsetItem);
        this.currentBlock = 0;
        this.currentLocation = 0L;
    }

    PSTNodeInputStream(PSTFile pstFile, OffsetIndexItem offsetItem) throws IOException, PSTException {
        this.in = pstFile.getFileHandle();
        this.pstFile = pstFile;
        this.encrypted = pstFile.getEncryptionType() == 1;
        this.loadFromOffsetItem(offsetItem);
        this.currentBlock = 0;
        this.currentLocation = 0L;
    }

    private void loadFromOffsetItem(OffsetIndexItem offsetItem) throws IOException, PSTException {
        boolean bInternal = (offsetItem.indexIdentifier & 2L) != 0L;
        this.in.seek(offsetItem.fileOffset);
        byte[] data = new byte[offsetItem.size];
        this.in.read(data);
        if (bInternal) {
            if (offsetItem.size < 8) {
                throw new PSTException("Invalid internal block size");
            }
            if (data[0] == 1) {
                bInternal = false;
                this.length = PSTObject.convertLittleEndianBytesToLong(data, 4, 8);
                this.getBlockSkipPoints(data);
                return;
            }
        }
        if (bInternal) {
            this.encrypted = false;
        }
        this.allData = data;
        this.length = this.allData.length;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    private void getBlockSkipPoints(byte[] data) throws IOException, PSTException {
        block5: {
            int arraySize;
            int numberOfEntries;
            block4: {
                if (data[0] != 1) {
                    throw new PSTException("Unable to process XBlock, incorrect identifier");
                }
                numberOfEntries = (int)PSTObject.convertLittleEndianBytesToLong(data, 2, 4);
                arraySize = 8;
                if (this.pstFile.getPSTFileType() == 14) {
                    arraySize = 4;
                }
                if (data[1] != 2) break block4;
                int offset = 8;
                for (int x = 0; x < numberOfEntries; ++x) {
                    long bid = PSTObject.convertLittleEndianBytesToLong(data, offset, offset + arraySize);
                    OffsetIndexItem offsetItem = this.pstFile.getOffsetIndexNode(bid &= 0xFFFFFFFFFFFFFFFEL);
                    this.in.seek(offsetItem.fileOffset);
                    byte[] blockData = new byte[offsetItem.size];
                    this.in.read(blockData);
                    this.getBlockSkipPoints(blockData);
                    offset += arraySize;
                }
                break block5;
            }
            if (data[1] != 1) break block5;
            int offset = 8;
            for (int x = 0; x < numberOfEntries; ++x) {
                long bid = PSTObject.convertLittleEndianBytesToLong(data, offset, offset + arraySize);
                OffsetIndexItem offsetItem = this.pstFile.getOffsetIndexNode(bid &= 0xFFFFFFFFFFFFFFFEL);
                this.indexItems.add(offsetItem);
                this.skipPoints.add(this.currentLocation);
                this.currentLocation += (long)offsetItem.size;
                offset += arraySize;
            }
        }
    }

    public long length() {
        return this.length;
    }

    public int read() throws IOException {
        int output;
        if (this.allData != null) {
            if (this.currentLocation == this.length) {
                return -1;
            }
            int value = this.allData[(int)this.currentLocation] & 0xFF;
            ++this.currentLocation;
            if (this.encrypted) {
                value = PSTObject.compEnc[value];
            }
            return value;
        }
        OffsetIndexItem item = this.indexItems.get(this.currentBlock);
        long skipPoint = this.skipPoints.get(this.currentBlock);
        if (this.currentLocation + 1L > skipPoint + (long)item.size) {
            ++this.currentBlock;
            if (this.currentBlock >= this.indexItems.size()) {
                return -1;
            }
            item = this.indexItems.get(this.currentBlock);
            skipPoint = this.skipPoints.get(this.currentBlock);
        }
        long pos = item.fileOffset + (this.currentLocation - skipPoint);
        if (this.in.getFilePointer() != pos) {
            this.in.seek(pos);
        }
        if ((output = this.in.read()) < 0) {
            return -1;
        }
        if (this.encrypted) {
            output = PSTObject.compEnc[output];
        }
        ++this.currentLocation;
        return output;
    }

    public int read(byte[] output) throws IOException {
        if (this.currentLocation == this.length) {
            return -1;
        }
        if (this.allData != null) {
            int bytesRemaining = (int)(this.length - this.currentLocation);
            if (output.length >= bytesRemaining) {
                System.arraycopy(this.allData, (int)this.currentLocation, output, 0, bytesRemaining);
                if (this.encrypted) {
                    PSTObject.decode(output);
                }
                this.currentLocation += (long)bytesRemaining;
                return bytesRemaining;
            }
            System.arraycopy(this.allData, (int)this.currentLocation, output, 0, output.length);
            if (this.encrypted) {
                PSTObject.decode(output);
            }
            this.currentLocation += (long)output.length;
            return output.length;
        }
        boolean filled = false;
        int totalBytesFilled = 0;
        while (!filled) {
            OffsetIndexItem offset = this.indexItems.get(this.currentBlock);
            long skipPoint = this.skipPoints.get(this.currentBlock);
            int currentPosInBlock = (int)(this.currentLocation - skipPoint);
            this.in.seek(offset.fileOffset + (long)currentPosInBlock);
            long nextSkipPoint = skipPoint + (long)offset.size;
            int bytesRemaining = output.length - totalBytesFilled;
            if (bytesRemaining > (int)(this.length - this.currentLocation)) {
                bytesRemaining = (int)(this.length - this.currentLocation);
            }
            if (nextSkipPoint >= this.currentLocation + (long)bytesRemaining) {
                byte[] chunk = new byte[bytesRemaining];
                this.in.read(chunk);
                System.arraycopy(chunk, 0, output, totalBytesFilled, bytesRemaining);
                totalBytesFilled += bytesRemaining;
                filled = true;
                this.currentLocation += (long)bytesRemaining;
            } else {
                int bytesToRead = offset.size - currentPosInBlock;
                byte[] chunk = new byte[bytesToRead];
                this.in.read(chunk);
                System.arraycopy(chunk, 0, output, totalBytesFilled, bytesToRead);
                totalBytesFilled += bytesToRead;
                ++this.currentBlock;
                this.currentLocation += (long)bytesToRead;
            }
            ++this.totalLoopCount;
        }
        if (this.encrypted) {
            PSTObject.decode(output);
        }
        return totalBytesFilled;
    }

    public int read(byte[] output, int offset, int length) throws IOException {
        if (this.currentLocation == this.length) {
            return -1;
        }
        if (output.length < length) {
            length = output.length;
        }
        byte[] buf = new byte[length];
        int lengthRead = this.read(buf);
        System.arraycopy(buf, 0, output, offset, lengthRead);
        return lengthRead;
    }

    public void reset() {
        this.currentBlock = 0;
        this.currentLocation = 0L;
    }

    public boolean markSupported() {
        return false;
    }

    public Long[] getBlockOffsets() {
        if (this.skipPoints.size() == 0) {
            Long[] output = new Long[]{this.length};
            return output;
        }
        Long[] output = new Long[this.skipPoints.size()];
        for (int x = 0; x < output.length; ++x) {
            output[x] = new Long(this.skipPoints.get(x) + (long)this.indexItems.get((int)x).size);
        }
        return output;
    }

    public void seek(long location) throws IOException, PSTException {
        if (location > this.length) {
            throw new PSTException("Unable to seek past end of item! size = " + this.length + ", seeking to:" + location);
        }
        if (this.currentLocation == location) {
            return;
        }
        long skipPoint = 0L;
        this.currentBlock = 0;
        if (this.allData == null) {
            skipPoint = this.skipPoints.get(this.currentBlock + 1);
            while (location >= skipPoint) {
                ++this.currentBlock;
                if (this.currentBlock == this.skipPoints.size() - 1) break;
                skipPoint = this.skipPoints.get(this.currentBlock + 1);
            }
        }
        this.currentLocation = location;
        long blockStart = 0L;
        if (this.allData == null) {
            blockStart = this.indexItems.get((int)this.currentBlock).fileOffset;
        }
        long newFilePos = blockStart + (location - skipPoint);
        this.in.seek(newFilePos);
    }

    public long seekAndReadLong(long location, int bytes) throws IOException, PSTException {
        this.seek(location);
        byte[] buffer = new byte[bytes];
        this.read(buffer);
        return PSTObject.convertLittleEndianBytesToLong(buffer);
    }

    public PSTFile getPSTFile() {
        return this.pstFile;
    }
}

