/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.reporter.plain;

import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.cli.reporter.core.api.ReporterV2;
import com.pinterest.ktlint.cli.reporter.plain.Color;
import com.pinterest.ktlint.cli.reporter.plain.PlainReporterKt;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J \u0010\u0019\u001a\u00020\u0014*\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\r2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\f\u0010\u001d\u001a\u00020\u000e*\u00020\u000eH\u0002J\f\u0010\u001e\u001a\u00020\u000e*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/pinterest/ktlint/cli/reporter/plain/PlainReporter;", "Lcom/pinterest/ktlint/cli/reporter/core/api/ReporterV2;", "out", "Ljava/io/PrintStream;", "groupByFile", "", "shouldColorOutput", "outputColor", "Lcom/pinterest/ktlint/cli/reporter/plain/Color;", "pad", "<init>", "(Ljava/io/PrintStream;ZZLcom/pinterest/ktlint/cli/reporter/plain/Color;Z)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "ruleViolationCount", "", "onLintError", "", "file", "ktlintCliError", "after", "afterAll", "printSummary", "header", "colorFileName", "fileName", "colored", "causedBy", "Companion", "ktlint-cli-reporter-plain"})
@SourceDebugExtension(value={"SMAP\nPlainReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlainReporter.kt\ncom/pinterest/ktlint/cli/reporter/plain/PlainReporter\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n72#2,2:122\n1#3:124\n1#3:129\n1563#4:125\n1634#4,3:126\n*S KotlinDebug\n*F\n+ 1 PlainReporter.kt\ncom/pinterest/ktlint/cli/reporter/plain/PlainReporter\n*L\n31#1:122,2\n31#1:124\n82#1:125\n82#1:126,3\n*E\n"})
public final class PlainReporter
implements ReporterV2 {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PrintStream out;
    private final boolean groupByFile;
    private final boolean shouldColorOutput;
    @NotNull
    private final Color outputColor;
    private final boolean pad;
    @NotNull
    private final ConcurrentHashMap<String, List<KtlintCliError>> acc;
    @NotNull
    private final ConcurrentHashMap<String, Long> ruleViolationCount;
    @NotNull
    private static final Comparator<Pair<String, Long>> COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR;
    @Deprecated
    @NotNull
    public static final String KOTLIN_PARSE_EXCEPTION_MESSAGE = "Not a valid Kotlin file";
    @Deprecated
    @NotNull
    public static final String KTLINT_RULE_ENGINE_EXCEPTION_MESSAGE = "An internal error occurred in the Ktlint Rule Engine";
    @Deprecated
    @NotNull
    public static final String UNKNOWN_CAUSE_MESSAGE = "Unknown";

    public PlainReporter(@NotNull PrintStream out, boolean groupByFile, boolean shouldColorOutput, @NotNull Color outputColor, boolean pad) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)((Object)outputColor), (String)"outputColor");
        this.out = out;
        this.groupByFile = groupByFile;
        this.shouldColorOutput = shouldColorOutput;
        this.outputColor = outputColor;
        this.pad = pad;
        this.acc = new ConcurrentHashMap();
        this.ruleViolationCount = new ConcurrentHashMap();
    }

    public /* synthetic */ PlainReporter(PrintStream printStream, boolean bl, boolean bl2, Color color, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            color = Color.DARK_GRAY;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        this(printStream, bl, bl2, color, bl3);
    }

    /*
     * WARNING - void declaration
     */
    public void onLintError(@NotNull String file, @NotNull KtlintCliError ktlintCliError) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)ktlintCliError, (String)"ktlintCliError");
        if (ktlintCliError.getStatus() != KtlintCliError.Status.FORMAT_IS_AUTOCORRECTED) {
            if (this.groupByFile) {
                void $this$getOrPut$iv;
                ConcurrentMap concurrentMap = this.acc;
                String key$iv = file;
                boolean $i$f$getOrPut = false;
                Object object = $this$getOrPut$iv.get(key$iv);
                if (object == null) {
                    boolean bl = false;
                    List default$iv = new ArrayList();
                    boolean bl2 = false;
                    object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                    if (object == null) {
                        object = default$iv;
                    }
                }
                ((List)object).add(ktlintCliError);
            } else {
                Object object;
                if (this.pad) {
                    String string = "%-4s";
                    Object[] objectArray = new Object[]{ktlintCliError.getCol()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    object = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                } else {
                    object = ktlintCliError.getCol();
                }
                Integer column = object;
                this.out.println(this.colorFileName(file) + this.colored(":") + ktlintCliError.getLine() + this.colored("" + ':' + column + ':') + ' ' + ktlintCliError.getDetail() + ' ' + this.colored('(' + ktlintCliError.getRuleId() + ')'));
            }
            this.ruleViolationCount.merge(this.causedBy(ktlintCliError), 1L, (arg_0, arg_1) -> PlainReporter.onLintError$lambda$2(PlainReporter::onLintError$lambda$1, arg_0, arg_1));
        }
    }

    public void after(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.groupByFile) {
            List<KtlintCliError> list = this.acc.get(file);
            if (list == null) {
                return;
            }
            List<KtlintCliError> errList = list;
            this.out.println(this.colorFileName(file));
            Iterator<KtlintCliError> iterator = errList.iterator();
            while (iterator.hasNext()) {
                Object object;
                KtlintCliError err;
                KtlintCliError $this$after_u24lambda_u240 = err = iterator.next();
                boolean bl = false;
                if (this.pad) {
                    String string = "%-3s";
                    Object[] objectArray = new Object[]{$this$after_u24lambda_u240.getCol()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    object = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                } else {
                    object = $this$after_u24lambda_u240.getCol();
                }
                Integer column = object;
                this.out.println("  " + $this$after_u24lambda_u240.getLine() + this.colored("" + ':' + column) + ' ' + $this$after_u24lambda_u240.getDetail() + ' ' + this.colored('(' + $this$after_u24lambda_u240.getRuleId() + ')'));
            }
        }
    }

    public void afterAll() {
        if (!((Map)this.ruleViolationCount).isEmpty()) {
            this.out.println("");
            this.printSummary(this.ruleViolationCount, "Summary error count (descending) by rule:");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void printSummary(ConcurrentHashMap<String, Long> $this$printSummary, String header) {
        void $this$mapTo$iv$iv;
        this.out.println(header);
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)MapsKt.toList((Map)$this$printSummary), COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.out.println("  " + (String)it.getFirst() + ": " + ((Number)it.getSecond()).longValue());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final String colorFileName(String fileName) {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String name = StringsKt.substringAfterLast$default((String)fileName, (String)string, null, (int)2, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = fileName.substring(0, fileName.length() - name.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return stringBuilder.append(this.colored(string2)).append(name).toString();
    }

    private final String colored(String $this$colored) {
        return this.shouldColorOutput ? PlainReporterKt.color($this$colored, this.outputColor) : $this$colored;
    }

    private final String causedBy(KtlintCliError $this$causedBy) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$causedBy.getStatus().ordinal()]) {
            case 1: {
                string = KOTLIN_PARSE_EXCEPTION_MESSAGE;
                break;
            }
            case 2: {
                string = KTLINT_RULE_ENGINE_EXCEPTION_MESSAGE;
                break;
            }
            default: {
                CharSequence charSequence;
                CharSequence charSequence2 = $this$causedBy.getRuleId();
                if (charSequence2.length() == 0) {
                    boolean bl = false;
                    charSequence = UNKNOWN_CAUSE_MESSAGE;
                } else {
                    charSequence = charSequence2;
                }
                string = (String)charSequence;
            }
        }
        return string;
    }

    private static final Long onLintError$lambda$1(Long previousValue, Long l) {
        Intrinsics.checkNotNullParameter((Object)previousValue, (String)"previousValue");
        Intrinsics.checkNotNullParameter((Object)l, (String)"<unused var>");
        return previousValue + 1L;
    }

    private static final Long onLintError$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (Long)$tmp0.invoke(p0, p1);
    }

    private static final int COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR$lambda$0(Pair left, Pair right) {
        Pair it = left;
        boolean bl = false;
        Comparable comparable = (Comparable)it.getSecond();
        it = right;
        Comparable comparable2 = comparable;
        bl = false;
        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getSecond()));
    }

    static {
        Comparator comparator = ((Comparator)PlainReporter::COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR$lambda$0).reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        Comparator comparator2 = comparator;
        COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR = new Comparator(comparator2){
            final /* synthetic */ Comparator $this_thenComparator;
            {
                this.$this_thenComparator = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenComparator.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    void right;
                    Pair pair = (Pair)b;
                    Pair left = (Pair)a;
                    boolean bl = false;
                    Pair it = left;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)it.getFirst();
                    it = right;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getFirst()));
                }
                return n;
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Ra\u0010\u0004\u001aR\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u00060\u0005j(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u0006`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/pinterest/ktlint/cli/reporter/plain/PlainReporter$Companion;", "", "<init>", "()V", "COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR", "Ljava/util/Comparator;", "Lkotlin/Pair;", "", "", "kotlin.jvm.PlatformType", "Lkotlin/Comparator;", "getCOUNT_DESC_AND_RULE_ID_ASC_COMPARATOR", "()Ljava/util/Comparator;", "KOTLIN_PARSE_EXCEPTION_MESSAGE", "KTLINT_RULE_ENGINE_EXCEPTION_MESSAGE", "UNKNOWN_CAUSE_MESSAGE", "ktlint-cli-reporter-plain"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<Pair<String, Long>> getCOUNT_DESC_AND_RULE_ID_ASC_COMPARATOR() {
            return COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KtlintCliError.Status.values().length];
            try {
                nArray[KtlintCliError.Status.KOTLIN_PARSE_EXCEPTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtlintCliError.Status.KTLINT_RULE_ENGINE_EXCEPTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

