/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.internal.RegExIgnoringDiacriticsAndStrokesOnLettersKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042K\u0010\n\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\f\u0010\u0013\u001a\u00020\u0004*\u00020\bH\u0002J\f\u0010\u0014\u001a\u00020\u0004*\u00020\bH\u0002J\f\u0010\u0015\u001a\u00020\u0004*\u00020\bH\u0002J\f\u0010\u0016\u001a\u00020\u0004*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/FunctionNamingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "isTestClass", "", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "hasValidFunctionName", "hasValidTestFunctionName", "isFactoryMethod", "isTestMethod", "Companion", "ktlint-ruleset-standard"})
@SinceKtlint.Container(value={@SinceKtlint(version="0.48", status=SinceKtlint.Status.EXPERIMENTAL), @SinceKtlint(version="1.0", status=SinceKtlint.Status.STABLE)})
@SourceDebugExtension(value={"SMAP\nFunctionNamingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionNamingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/FunctionNamingRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class FunctionNamingRule
extends StandardRule {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private boolean isTestClass;
    @NotNull
    private static final Regex VALID_FUNCTION_NAME_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("[a-z][A-Za-z\\d]*");
    @NotNull
    private static final Regex VALID_TEST_FUNCTION_NAME_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("(`.*`)|([a-z][A-Za-z\\d_]*)");
    @NotNull
    private static final String KOTLIN_TEST = "kotlin.test";
    @NotNull
    private static final String ORG_JUNIT = "org.junit";
    @NotNull
    private static final String ORG_TESTNG = "org.testng";

    public FunctionNamingRule() {
        super("function-naming", null, null, 6, null);
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block4: {
            ImportPath importPath;
            Object object;
            ImportPath importPath2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(emit, (String)"emit");
            if (!this.isTestClass && Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_DIRECTIVE())) {
                PsiElement psiElement = node.getPsi();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                importPath2 = ((KtImportDirective)psiElement).getImportPath();
                if (importPath2 != null && (object = importPath2.getPathStr()) != null) {
                    Object object2;
                    Object it = object2 = object;
                    boolean bl = false;
                    Object object3 = importPath = StringsKt.startsWith$default((String)it, (String)ORG_JUNIT, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)ORG_TESTNG, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)KOTLIN_TEST, (boolean)false, (int)2, null) ? object2 : null;
                    if (importPath != null) {
                        it = importPath;
                        boolean bl2 = false;
                        this.isTestClass = true;
                    }
                }
            }
            ASTNode it = object = node;
            boolean bl = false;
            Object object4 = importPath2 = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUN()) ? object : null;
            if (importPath2 == null) break block4;
            ImportPath it2 = importPath = importPath2;
            boolean bl3 = false;
            Object object5 = object = !(this.isFactoryMethod(node) || this.isTestMethod(node) || this.hasValidFunctionName(node)) ? importPath : null;
            if (object != null) {
                it2 = object;
                boolean bl4 = false;
                ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
                int identifierOffset = aSTNode != null ? aSTNode.getStartOffset() : 1;
                emit.invoke((Object)identifierOffset, (Object)"Function name should start with a lowercase letter (except factory methods) and use camel case", (Object)false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFactoryMethod(ASTNode $this$isFactoryMethod) {
        PsiElement psiElement = $this$isFactoryMethod.getPsi();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        KtFunction it = (KtFunction)psiElement;
        boolean bl = false;
        if (!it.hasDeclaredReturnType()) return false;
        KtTypeReference ktTypeReference = it.getTypeReference();
        if (!Intrinsics.areEqual((Object)it.getName(), (Object)(ktTypeReference != null ? ktTypeReference.getText() : null))) return false;
        return true;
    }

    private final boolean isTestMethod(ASTNode $this$isTestMethod) {
        return this.isTestClass && this.hasValidTestFunctionName($this$isTestMethod);
    }

    private final boolean hasValidTestFunctionName(ASTNode $this$hasValidTestFunctionName) {
        Object object = $this$hasValidTestFunctionName.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
        String string = object != null ? object.getText() : null;
        if (string == null) {
            string = "";
        }
        object = string;
        return VALID_TEST_FUNCTION_NAME_REGEXP.matches((CharSequence)object);
    }

    private final boolean hasValidFunctionName(ASTNode $this$hasValidFunctionName) {
        Object object = $this$hasValidFunctionName.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
        String string = object != null ? object.getText() : null;
        if (string == null) {
            string = "";
        }
        object = string;
        return VALID_FUNCTION_NAME_REGEXP.matches((CharSequence)object);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/FunctionNamingRule$Companion;", "", "()V", "KOTLIN_TEST", "", "ORG_JUNIT", "ORG_TESTNG", "VALID_FUNCTION_NAME_REGEXP", "Lkotlin/text/Regex;", "getVALID_FUNCTION_NAME_REGEXP", "()Lkotlin/text/Regex;", "VALID_TEST_FUNCTION_NAME_REGEXP", "getVALID_TEST_FUNCTION_NAME_REGEXP", "ktlint-ruleset-standard"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getVALID_FUNCTION_NAME_REGEXP() {
            return VALID_FUNCTION_NAME_REGEXP;
        }

        @NotNull
        public final Regex getVALID_TEST_FUNCTION_NAME_REGEXP() {
            return VALID_TEST_FUNCTION_NAME_REGEXP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

