/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.cloud2.CloudReactiveFeign;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactivefeign.spring.config.AbstractReactiveFeignConfigurator;
import reactivefeign.spring.config.ReactiveFeignBasicConfigurator;
import reactivefeign.spring.config.ReactiveFeignClientsProperties;
import reactivefeign.spring.config.ReactiveFeignNamedContext;
import reactivefeign.spring.config.ReactiveRetryPolicies;

public class ReactiveFeignLoadBalancerConfigurator
extends AbstractReactiveFeignConfigurator {
    protected ReactiveFeignLoadBalancerConfigurator() {
        super(2);
    }

    @Override
    public ReactiveFeignBuilder configure(ReactiveFeignBuilder builder, ReactiveFeignNamedContext namedContext) {
        ReactiveRetryPolicy retryOnNext;
        if (!(builder instanceof CloudReactiveFeign.Builder)) {
            throw new IllegalArgumentException("CloudReactiveFeign.Builder expected");
        }
        CloudReactiveFeign.Builder cloudBuilder = (CloudReactiveFeign.Builder)builder;
        ReactiveLoadBalancer.Factory loadBalancerFactory = namedContext.get(ReactiveLoadBalancer.Factory.class);
        cloudBuilder = cloudBuilder.enableLoadBalancer(loadBalancerFactory);
        ReactiveRetryPolicy retryOnSame = this.getRetry(namedContext, properties -> this.getRetryOnSameUsingProperties(namedContext, (ReactiveFeignClientsProperties.ReactiveFeignClientProperties<?>)properties), this::getRetryOnSameUsingConfiguration);
        if (retryOnSame != null) {
            cloudBuilder = cloudBuilder.retryOnSame(retryOnSame);
        }
        if ((retryOnNext = this.getRetry(namedContext, properties -> this.getRetryOnNextUsingProperties(namedContext, (ReactiveFeignClientsProperties.ReactiveFeignClientProperties<?>)properties), this::getRetryOnNextUsingConfiguration)) != null) {
            cloudBuilder = cloudBuilder.retryOnNext(retryOnNext);
        }
        return cloudBuilder;
    }

    private ReactiveRetryPolicy getRetry(ReactiveFeignNamedContext namedContext, Function<ReactiveFeignClientsProperties.ReactiveFeignClientProperties<?>, ReactiveRetryPolicy> retryPropertiesFunction, Function<ReactiveFeignNamedContext, ReactiveRetryPolicy> retryConfigFunction) {
        Stream<ReactiveRetryPolicy> retryPolicyFromConfig = Stream.of(retryConfigFunction.apply(namedContext));
        Stream<ReactiveRetryPolicy> retryPoliciesFromProperties = namedContext.getConfigs().stream().map(retryPropertiesFunction);
        Stream<ReactiveRetryPolicy> reactiveRetryPolicyStream = namedContext.getProperties().isDefaultToProperties() ? Stream.concat(retryPoliciesFromProperties, retryPolicyFromConfig) : Stream.concat(retryPolicyFromConfig, retryPoliciesFromProperties);
        return reactiveRetryPolicyStream.filter(Objects::nonNull).findFirst().orElse(null);
    }

    private ReactiveRetryPolicy getRetryOnSameUsingProperties(ReactiveFeignNamedContext namedContext, ReactiveFeignClientsProperties.ReactiveFeignClientProperties<?> config) {
        return config != null && config.getRetryOnSame() != null ? ReactiveFeignBasicConfigurator.configureRetryPolicyFromProperties(namedContext, config.getRetryOnSame()) : null;
    }

    private ReactiveRetryPolicy getRetryOnSameUsingConfiguration(ReactiveFeignNamedContext context) {
        ReactiveRetryPolicies policies = context.getOptional(ReactiveRetryPolicies.class);
        return policies != null ? policies.getRetryOnSame() : null;
    }

    private ReactiveRetryPolicy getRetryOnNextUsingProperties(ReactiveFeignNamedContext namedContext, ReactiveFeignClientsProperties.ReactiveFeignClientProperties<?> config) {
        return config != null && config.getRetryOnNext() != null ? ReactiveFeignBasicConfigurator.configureRetryPolicyFromProperties(namedContext, config.getRetryOnNext()) : null;
    }

    private ReactiveRetryPolicy getRetryOnNextUsingConfiguration(ReactiveFeignNamedContext context) {
        ReactiveRetryPolicies policies = context.getOptional(ReactiveRetryPolicies.class);
        return policies != null ? policies.getRetryOnNext() : null;
    }
}

