/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jsensors;

import com.profesorfalken.jsensors.manager.SensorsManager;
import com.profesorfalken.jsensors.manager.stub.StubSensorsManager;
import com.profesorfalken.jsensors.manager.unix.UnixSensorsManager;
import com.profesorfalken.jsensors.manager.windows.WindowsSensorsManager;
import com.profesorfalken.jsensors.model.components.Components;
import com.profesorfalken.jsensors.util.OSDetector;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum SensorsLocator {
    get;


    Components getComponents(Map<String, String> config) {
        return SensorsLocator.getManager(config).getComponents();
    }

    private static SensorsManager getManager(Map<String, String> config) {
        boolean debugMode = false;
        if ("true".equals(config.get("debugMode"))) {
            debugMode = true;
        }
        if ("STUB".equals(config.get("testMode"))) {
            return new StubSensorsManager(config.get("stubContent")).debugMode(debugMode);
        }
        if (OSDetector.isWindows()) {
            return new WindowsSensorsManager().debugMode(debugMode);
        }
        if (OSDetector.isUnix()) {
            return new UnixSensorsManager().debugMode(debugMode);
        }
        throw new UnsupportedOperationException("Sorry, but your Operating System is not supported by jSensors");
    }
}

