/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jsensors.manager.windows;

import com.profesorfalken.jsensors.manager.SensorsManager;
import com.profesorfalken.jsensors.manager.windows.powershell.PowerShellOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsSensorsManager
extends SensorsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsSensorsManager.class);
    private static final String LINE_BREAK = "\r\n";
    private static final String COMPONENT_SEPARATOR = "[COMPONENT]";

    public String getSensorsData() {
        String rawSensorsData = PowerShellOperations.getRawSensorsData();
        if (this.debugMode) {
            LOGGER.info("RawSensorData: " + rawSensorsData);
        }
        String normalizedSensorsData = WindowsSensorsManager.normalizeSensorsData(rawSensorsData);
        if (this.debugMode) {
            LOGGER.info("NormalizeSensorData: " + normalizedSensorsData);
        }
        return normalizedSensorsData;
    }

    private static String normalizeSensorsData(String rawSensorsData) {
        StringBuilder normalizedSensorsData = new StringBuilder();
        String[] dataLines = rawSensorsData.split("\\r?\\n");
        boolean readingHardLabel = false;
        boolean readingSensor = false;
        for (String dataLine : dataLines) {
            if (!readingHardLabel && "HardwareType".equals(WindowsSensorsManager.getKey(dataLine))) {
                String hardwareType = WindowsSensorsManager.getValue(dataLine);
                if ("CPU".equals(hardwareType)) {
                    normalizedSensorsData.append(COMPONENT_SEPARATOR).append(LINE_BREAK);
                    normalizedSensorsData.append("CPU").append(LINE_BREAK);
                    readingHardLabel = true;
                    continue;
                }
                if (hardwareType.toUpperCase().startsWith("GPU")) {
                    normalizedSensorsData.append(COMPONENT_SEPARATOR).append(LINE_BREAK);
                    normalizedSensorsData.append("GPU").append(LINE_BREAK);
                    readingHardLabel = true;
                    continue;
                }
                if ("HDD".equals(hardwareType)) {
                    normalizedSensorsData.append(COMPONENT_SEPARATOR).append(LINE_BREAK);
                    normalizedSensorsData.append("DISK").append(LINE_BREAK);
                    readingHardLabel = true;
                    continue;
                }
                if (!"Mainboard".equals(hardwareType)) continue;
                normalizedSensorsData.append(COMPONENT_SEPARATOR).append(LINE_BREAK);
                normalizedSensorsData.append("MOBO").append(LINE_BREAK);
                readingHardLabel = false;
                continue;
            }
            if (readingHardLabel) {
                if (!"Name".equals(WindowsSensorsManager.getKey(dataLine))) continue;
                normalizedSensorsData.append("Label: ").append(WindowsSensorsManager.getValue(dataLine)).append(LINE_BREAK);
                readingHardLabel = false;
                continue;
            }
            readingSensor = WindowsSensorsManager.addSensorsData(readingSensor, dataLine, normalizedSensorsData);
        }
        return normalizedSensorsData.toString();
    }

    private static boolean addSensorsData(boolean readingSensor, String dataLine, StringBuilder normalizedSensorsData) {
        if ("SensorType".equals(WindowsSensorsManager.getKey(dataLine))) {
            String sensorType = WindowsSensorsManager.getValue(dataLine);
            if ("Temperature".equals(sensorType)) {
                normalizedSensorsData.append("Temp ");
                return true;
            }
            if ("Fan".equals(sensorType)) {
                normalizedSensorsData.append("Fan ");
                return true;
            }
            if ("Load".equals(sensorType)) {
                normalizedSensorsData.append("Load ");
                return true;
            }
        }
        if (readingSensor) {
            if ("Name".equals(WindowsSensorsManager.getKey(dataLine))) {
                normalizedSensorsData.append(WindowsSensorsManager.getValue(dataLine)).append(": ");
                return true;
            }
            if ("Value".equals(WindowsSensorsManager.getKey(dataLine))) {
                normalizedSensorsData.append(WindowsSensorsManager.getValue(dataLine)).append(LINE_BREAK);
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getKey(String line) {
        return WindowsSensorsManager.getData(line, 0);
    }

    private static String getValue(String line) {
        return WindowsSensorsManager.getData(line, 1);
    }

    private static String getData(String line, int index) {
        if (line.contains(":")) {
            return line.split(":", 2)[index].trim();
        }
        return "";
    }
}

