/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jsensors.manager.windows.powershell;

import com.profesorfalken.jsensors.manager.windows.powershell.PowerShellOperations;
import com.profesorfalken.jsensors.util.SensorsUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PowerShellScriptHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PowerShellOperations.class);
    private static final String LINE_BREAK = "\r\n";

    private PowerShellScriptHelper() {
    }

    private static String dllImport() {
        return "[System.Reflection.Assembly]::LoadFile(\"" + SensorsUtils.generateLibTmpPath("/lib/win/", "OpenHardwareMonitorLib.dll") + "\") | Out-Null" + LINE_BREAK;
    }

    private static String newComputerInstance() {
        StringBuilder code = new StringBuilder();
        code.append("$PC = New-Object OpenHardwareMonitor.Hardware.Computer").append(LINE_BREAK);
        code.append("$PC.MainboardEnabled = $true").append(LINE_BREAK);
        code.append("$PC.CPUEnabled = $true").append(LINE_BREAK);
        code.append("$PC.RAMEnabled = $true").append(LINE_BREAK);
        code.append("$PC.GPUEnabled = $true").append(LINE_BREAK);
        code.append("$PC.FanControllerEnabled = $true").append(LINE_BREAK);
        code.append("$PC.HDDEnabled = $true").append(LINE_BREAK);
        return code.toString();
    }

    private static String sensorsQueryLoop() {
        StringBuilder code = new StringBuilder();
        code.append("try").append(LINE_BREAK);
        code.append("{").append(LINE_BREAK);
        code.append("$PC.Open()").append(LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        code.append("catch").append(LINE_BREAK);
        code.append("{").append(LINE_BREAK);
        code.append("$PC.Open()").append(LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        code.append("ForEach ($hw in $PC.Hardware)").append(LINE_BREAK);
        code.append("{").append(LINE_BREAK);
        code.append("$hw").append(LINE_BREAK);
        code.append("$hw.Update()").append(LINE_BREAK);
        code.append("ForEach ($subhw in $hw.SubHardware)").append(LINE_BREAK);
        code.append("{").append(LINE_BREAK);
        code.append("$subhw.Update()").append(LINE_BREAK);
        code.append("ForEach ($sensor in $subhw.Sensors)").append(LINE_BREAK);
        code.append("{").append(LINE_BREAK);
        code.append("$sensor").append(LINE_BREAK);
        code.append("Write-Host \"\"").append(LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        code.append("ForEach ($sensor in $hw.Sensors)").append(LINE_BREAK);
        code.append("{").append(LINE_BREAK);
        code.append("$sensor").append(LINE_BREAK);
        code.append("Write-Host \"\"").append(LINE_BREAK);
        code.append("}").append(LINE_BREAK);
        code.append("}");
        return code.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String generateScript() {
        File tmpFile = null;
        OutputStreamWriter writer = null;
        String scriptPath = null;
        try {
            tmpFile = File.createTempFile("jsensors_" + new Date().getTime(), ".ps1");
            tmpFile.deleteOnExit();
            writer = new FileWriter(tmpFile);
            writer.write(PowerShellScriptHelper.getPowerShellScript());
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot create PowerShell script file", (Throwable)ex);
            String string = "Error";
            return string;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("Error when finish writing Powershell script file", (Throwable)ioe);
            }
        }
        if (tmpFile != null) {
            scriptPath = tmpFile.getAbsolutePath();
        }
        return scriptPath;
    }

    private static String getPowerShellScript() {
        StringBuilder script = new StringBuilder();
        script.append(PowerShellScriptHelper.dllImport());
        script.append(PowerShellScriptHelper.newComputerInstance());
        script.append(PowerShellScriptHelper.sensorsQueryLoop());
        return script.toString();
    }
}

