/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.MIR;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field280
extends Field
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "280";
    public static final String F_280 = "280";
    public static final String PARSER_PATTERN = "<HHMM><MIR>cS";
    public static final String COMPONENTS_PATTERN = "HRLS";
    public static final Integer INPUT_TIME = 1;
    public static final Integer MIR = 2;
    public static final Integer ACCEPTED = 3;
    public static final Integer ERROR = 4;

    public Field280() {
        super(4);
    }

    public Field280(String value) {
        super(value);
    }

    public Field280(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"280")) {
            throw new IllegalArgumentException("cannot create field 280 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field280 newInstance(Field280 source) {
        Field280 cp = new Field280();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("280", value);
    }

    public static Tag emptyTag() {
        return new Tag("280", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        if (value != null) {
            if (value.length() >= 4) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)4));
            }
            if (value.length() >= 32) {
                this.setComponent2(StringUtils.substring((String)value, (int)4, (int)32));
            }
            if (value.length() >= 33) {
                this.setComponent3(StringUtils.substring((String)value, (int)32, (int)33));
            }
            if (value.length() > 33) {
                this.setComponent4(StringUtils.substring((String)value, (int)33));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 280");
        }
        if (component == 1) {
            SimpleDateFormat f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            Calendar cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<HHMM><MIR>1!a<?>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Input Time");
        result.add("MIR");
        result.add("Accepted");
        result.add("Error");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "inputTime");
        result.put(2, "mIR");
        result.put(3, "accepted");
        result.put(4, "error");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(1));
    }

    public String getInputTime() {
        return this.getComponent(1);
    }

    public Calendar getInputTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(1));
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public MIR getComponent2AsMIR() {
        return SwiftFormatUtils.getMIR(this.getComponent(2));
    }

    public String getMIR() {
        return this.getComponent(2);
    }

    public MIR getMIRAsMIR() {
        return SwiftFormatUtils.getMIR(this.getComponent(2));
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Boolean getComponent3AsBoolean() {
        return SwiftFormatUtils.getBoolean(this.getComponent(3));
    }

    public String getAccepted() {
        return this.getComponent(3);
    }

    public Boolean getAcceptedAsBoolean() {
        return SwiftFormatUtils.getBoolean(this.getComponent(3));
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getError() {
        return this.getComponent(4);
    }

    public Field280 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field280 setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getTime3(component1));
        return this;
    }

    public Field280 setInputTime(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field280 setInputTime(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    public Field280 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field280 setComponent2(MIR component2) {
        this.setComponent(2, SwiftFormatUtils.getMIR(component2));
        return this;
    }

    public Field280 setMIR(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field280 setMIR(MIR component2) {
        this.setComponent2(component2);
        return this;
    }

    public Field280 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field280 setComponent3(Boolean component3) {
        this.setComponent(3, SwiftFormatUtils.getBoolean(component3));
        return this;
    }

    public Field280 setAccepted(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field280 setAccepted(Boolean component3) {
        this.setComponent3(component3);
        return this;
    }

    public Field280 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field280 setError(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    @Override
    public String getName() {
        return "280";
    }

    public static Field280 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("280");
        if (t == null) {
            return null;
        }
        return new Field280(t);
    }

    public static Field280 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field280.get(msg.getBlock4());
    }

    public static List<Field280> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field280.getAll(msg.getBlock4());
    }

    public static List<Field280> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("280");
        if (arr != null && arr.length > 0) {
            ArrayList<Field280> result = new ArrayList<Field280>(arr.length);
            for (Tag f : arr) {
                result.add(new Field280(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field280 fromJson(String json) {
        Field280 field = new Field280();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("inputTime") != null) {
            field.setComponent1(jsonObject.get("inputTime").getAsString());
        }
        if (jsonObject.get("mIR") != null) {
            field.setComponent2(jsonObject.get("mIR").getAsString());
        }
        if (jsonObject.get("accepted") != null) {
            field.setComponent3(jsonObject.get("accepted").getAsString());
        }
        if (jsonObject.get("error") != null) {
            field.setComponent4(jsonObject.get("error").getAsString());
        }
        return field;
    }
}

