/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import com.prowidesoftware.ProwideException;
import com.prowidesoftware.swift.io.IConversionService;
import com.prowidesoftware.swift.io.parser.XMLParser;
import com.prowidesoftware.swift.io.writer.SwiftWriter;
import com.prowidesoftware.swift.io.writer.XMLWriterVisitor;
import com.prowidesoftware.swift.model.SwiftMessage;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.commons.lang3.Validate;

public class ConversionService
implements IConversionService {
    @Override
    public String getFIN(SwiftMessage msg) {
        Validate.notNull((Object)msg);
        StringWriter writer = new StringWriter();
        SwiftWriter.writeMessage(msg, writer, true);
        String fin = writer.getBuffer().toString();
        return SwiftWriter.ensureEols(fin);
    }

    @Override
    public String getFIN(String xml) {
        Validate.notNull((Object)xml);
        SwiftMessage msg = this.getMessageFromXML(xml);
        if (msg == null) {
            throw new ProwideException("parsed SwiftMessage from XML is null");
        }
        return this.getFIN(msg);
    }

    @Override
    public String getXml(SwiftMessage msg) {
        return this.getXml(msg, false);
    }

    public String getXml(SwiftMessage msg, boolean useField) {
        Validate.notNull((Object)msg);
        StringWriter w = new StringWriter();
        msg.visit(new XMLWriterVisitor(w, useField));
        return w.getBuffer().toString();
    }

    @Override
    public String getXml(String fin) {
        return this.getXml(fin, false);
    }

    public String getXml(String fin, boolean useField) {
        Validate.notNull((Object)fin);
        SwiftMessage msg = this.getMessageFromFIN(fin);
        return this.getXml(msg, useField);
    }

    @Override
    public SwiftMessage getMessageFromFIN(String fin) {
        Validate.notNull((Object)fin);
        try {
            return SwiftMessage.parse(fin);
        }
        catch (IOException e) {
            throw new ProwideException(e + " during parse of message");
        }
    }

    @Override
    public SwiftMessage getMessageFromXML(String xml) {
        return new XMLParser().parse(xml);
    }
}

