/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field137
extends Field
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "137";
    public static final String F_137 = "137";
    public static final String PARSER_PATTERN = "c3!S<CC>N";
    public static final String COMPONENTS_PATTERN = "cSKN";
    public static final Integer BROADCAST_INDICATOR = 1;
    public static final Integer UNSEQUENCED_BROADCAST = 2;
    public static final Integer BROADCAST_ISSUER = 3;
    public static final Integer BROADCAST_NUMBER = 4;

    public Field137() {
        super(4);
    }

    public Field137(String value) {
        super(value);
    }

    public Field137(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"137")) {
            throw new IllegalArgumentException("cannot create field 137 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field137 newInstance(Field137 source) {
        Field137 cp = new Field137();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("137", value);
    }

    public static Tag emptyTag() {
        return new Tag("137", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        if (value != null) {
            String toparse = SwiftParseUtils.getAlphaPrefix(value);
            if (toparse != null && toparse.length() > 0 && toparse.length() > 0) {
                this.setComponent1(StringUtils.substring((String)toparse, (int)0, (int)1));
                if (toparse.length() >= 4) {
                    this.setComponent2(StringUtils.substring((String)toparse, (int)1, (int)4));
                    if (toparse.length() > 4) {
                        this.setComponent3(StringUtils.substring((String)toparse, (int)4));
                    }
                } else {
                    this.setComponent2(StringUtils.substring((String)toparse, (int)1));
                }
            }
            this.setComponent4(SwiftParseUtils.getNumericSuffix(value));
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 137");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            Number n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "1a3!x<CC>4!n";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Broadcast Indicator");
        result.add("Unsequenced Broadcast");
        result.add("Broadcast Issuer");
        result.add("Broadcast Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "broadcastIndicator");
        result.put(2, "unsequencedBroadcast");
        result.put(3, "broadcastIssuer");
        result.put(4, "broadcastNumber");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getBroadcastIndicator() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getUnsequencedBroadcast() {
        return this.getComponent(2);
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getBroadcastIssuer() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getBroadcastNumber() {
        return this.getComponent(4);
    }

    public Number getBroadcastNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field137 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field137 setBroadcastIndicator(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field137 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field137 setUnsequencedBroadcast(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field137 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field137 setBroadcastIssuer(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field137 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field137 setComponent4(Number component4) {
        if (component4 != null) {
            this.setComponent(4, Integer.toString(component4.intValue()));
        }
        return this;
    }

    public Field137 setBroadcastNumber(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field137 setBroadcastNumber(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public String getName() {
        return "137";
    }

    public static Field137 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("137");
        if (t == null) {
            return null;
        }
        return new Field137(t);
    }

    public static Field137 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field137.get(msg.getBlock4());
    }

    public static List<Field137> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field137.getAll(msg.getBlock4());
    }

    public static List<Field137> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("137");
        if (arr != null && arr.length > 0) {
            ArrayList<Field137> result = new ArrayList<Field137>(arr.length);
            for (Tag f : arr) {
                result.add(new Field137(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field137 fromJson(String json) {
        Field137 field = new Field137();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("broadcastIndicator") != null) {
            field.setComponent1(jsonObject.get("broadcastIndicator").getAsString());
        }
        if (jsonObject.get("unsequencedBroadcast") != null) {
            field.setComponent2(jsonObject.get("unsequencedBroadcast").getAsString());
        }
        if (jsonObject.get("broadcastIssuer") != null) {
            field.setComponent3(jsonObject.get("broadcastIssuer").getAsString());
        }
        if (jsonObject.get("broadcastNumber") != null) {
            field.setComponent4(jsonObject.get("broadcastNumber").getAsString());
        }
        return field;
    }
}

