/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt4xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52B;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT450
extends AbstractMT
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT450.class.getName());
    public static final String NAME = "450";

    public MT450(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT450(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT450 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT450(m);
    }

    public MT450() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT450(String sender, String receiver) {
        super(450, sender, receiver);
    }

    public MT450(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT450.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT450 object from FIN content with a Service Message. Check if the MT450 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT450 object from FIN content with message type " + param.getType());
        }
    }

    public static MT450 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT450(fin);
    }

    public MT450(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT450 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT450(stream);
    }

    public MT450(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT450 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT450(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT450 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT450 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT450 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT450 fromJson(String json) {
        return (MT450)AbstractMT.fromJson(json);
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field20> getField20() {
        ArrayList<Field20> result = new ArrayList<Field20>();
        Tag[] tags = this.tags("20");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field21(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field30> getField30() {
        ArrayList<Field30> result = new ArrayList<Field30>();
        Tag[] tags = this.tags("30");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field30(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32A> getField32A() {
        ArrayList<Field32A> result = new ArrayList<Field32A>();
        Tag[] tags = this.tags("32A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field52A> getField52A() {
        ArrayList<Field52A> result = new ArrayList<Field52A>();
        Tag[] tags = this.tags("52A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field52A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field52B> getField52B() {
        ArrayList<Field52B> result = new ArrayList<Field52B>();
        Tag[] tags = this.tags("52B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field52B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field52D> getField52D() {
        ArrayList<Field52D> result = new ArrayList<Field52D>();
        Tag[] tags = this.tags("52D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field52D(tag.getValue()));
            }
        }
        return result;
    }
}

